/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.shared.server.gateway.jaxrs.api;

import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.server.gateway.deserialization.impl.CourseTemplateJsonDeserializer;
import com.sap.sailing.server.gateway.serialization.impl.CourseTemplateJsonSerializer;
import com.sap.sailing.shared.server.SharedSailingData;
import com.sap.sailing.shared.server.gateway.jaxrs.SharedAbstractSailingServerResource;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.json.JsonSerializer;
import com.sun.jersey.api.client.ClientResponse;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@Path(value="/v1/coursetemplates")
public class CourseTemplateResource
extends SharedAbstractSailingServerResource {
    private final JsonSerializer<CourseTemplate> courseTemplateSerializer = new CourseTemplateJsonSerializer();

    private JsonDeserializer<CourseTemplate> getCourseTemplateDeserializer() {
        return new CourseTemplateJsonDeserializer(arg_0 -> ((SharedSailingData)this.getSharedSailingData()).getMarkTemplateById(arg_0), arg_0 -> ((SharedSailingData)this.getSharedSailingData()).getMarkRoleById(arg_0));
    }

    private Response getBadCourseTemplateValidationErrorResponse(String errorText) {
        return Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)(String.valueOf(StringEscapeUtils.escapeHtml((String)errorText)) + ".")).type("text/plain").build();
    }

    private Response getCourseTemplateNotFoundErrorResponse() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getCourseTemplates(@QueryParam(value="tags") List<String> tags) throws Exception {
        Iterable courseTemplateList = this.getSharedSailingData().getAllCourseTemplates(tags);
        JSONArray result = new JSONArray();
        for (CourseTemplate courseTemplate : courseTemplateList) {
            result.add((Object)this.courseTemplateSerializer.serialize((Object)courseTemplate));
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @GET
    @Path(value="{courseTemplateId}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getCourseTemplate(@PathParam(value="courseTemplateId") String courseTemplateId) throws Exception {
        CourseTemplate courseTemplate = this.getSharedSailingData().getCourseTemplateById(UUID.fromString(courseTemplateId));
        if (courseTemplate == null) {
            return this.getCourseTemplateNotFoundErrorResponse();
        }
        JSONObject serializedMarkProperties = this.courseTemplateSerializer.serialize((Object)courseTemplate);
        return Response.ok((Object)this.streamingOutput(serializedMarkProperties)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createCourseTemplate(String json) throws Exception {
        Object parsedObject;
        if (json == null || json.isEmpty()) {
            this.getBadCourseTemplateValidationErrorResponse("Course template is required to be given as json object");
        }
        if ((parsedObject = new JSONParser().parse(json)) == null || !(parsedObject instanceof JSONObject)) {
            this.getBadCourseTemplateValidationErrorResponse("Course template is required to be given as json object");
        }
        CourseTemplate deserializedCourseTemplate = (CourseTemplate)this.getCourseTemplateDeserializer().deserialize((JSONObject)parsedObject);
        CourseTemplate createdCourseTemplate = this.getSharedSailingData().createCourseTemplate(deserializedCourseTemplate.getName(), deserializedCourseTemplate.getShortName(), deserializedCourseTemplate.getMarkTemplates(), deserializedCourseTemplate.getWaypointTemplates(), deserializedCourseTemplate.getDefaultMarkRolesForMarkTemplates(), deserializedCourseTemplate.getDefaultMarkTemplatesForMarkRoles(), deserializedCourseTemplate.getRepeatablePart(), deserializedCourseTemplate.getTags(), deserializedCourseTemplate.getOptionalImageURL(), deserializedCourseTemplate.getDefaultNumberOfLaps());
        JSONObject serializedMarkProperties = this.courseTemplateSerializer.serialize((Object)createdCourseTemplate);
        return Response.ok((Object)this.streamingOutput(serializedMarkProperties)).build();
    }

    @DELETE
    @Path(value="{courseTemplateId}")
    public Response deleteCourseTemplate(@PathParam(value="courseTemplateId") String courseTemplateId) throws Exception {
        CourseTemplate courseTemplate = this.getSharedSailingData().getCourseTemplateById(UUID.fromString(courseTemplateId));
        if (courseTemplate == null) {
            return this.getCourseTemplateNotFoundErrorResponse();
        }
        this.getSharedSailingData().deleteCourseTemplate(courseTemplate);
        return Response.ok().build();
    }
}

