/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.shared.server.gateway.jaxrs;

import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.shared.server.gateway.jaxrs.SharedAbstractSailingServerResource;
import com.sap.sse.common.Util;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.UnauthorizedException;

public abstract class AbstractSailingServerResource
extends SharedAbstractSailingServerResource {
    private static final Logger logger = Logger.getLogger(AbstractSailingServerResource.class.getName());

    private Iterable<ScoreCorrectionProvider> getScoreCorrectionProviders() {
        return Arrays.asList(this.getServices(ScoreCorrectionProvider.class));
    }

    protected Optional<ScoreCorrectionProvider> getScoreCorrectionProvider(String scoreCorrectionProviderName) {
        return StreamSupport.stream(this.getScoreCorrectionProviders().spliterator(), false).filter(scp -> scp.getName().equals(scoreCorrectionProviderName)).findAny();
    }

    protected boolean validateAuthenticationParameters(String user, String password, String bearer) {
        return Util.hasLength((String)user) && Util.hasLength((String)password) && !Util.hasLength((String)bearer) || !Util.hasLength((String)user) && !Util.hasLength((String)password) && Util.hasLength((String)bearer) || !Util.hasLength((String)user) && !Util.hasLength((String)password) && !Util.hasLength((String)bearer);
    }

    protected Response returnInternalServerError(Throwable e) {
        Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        logger.severe(e.getMessage());
        return response;
    }

    protected Response badRequest(String message) {
        Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)message).build();
        return response;
    }

    protected Response returnUnauthorized(UnauthorizedException e) {
        Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        logger.warning(String.valueOf(e.getMessage()) + " for user: " + this.getSecurityService().getCurrentUser());
        return response;
    }

    protected static Double roundDouble(Double value, int places) {
        BigDecimal bigDecimal = new BigDecimal(value);
        bigDecimal = bigDecimal.setScale(places, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }
}

