/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.race.CompetitorResult;
import com.sap.sailing.domain.abstractlog.race.CompetitorResults;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFinishPositioningConfirmedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFlagEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogPassChangeEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.AbortingFlagFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.AbstractFinishPositioningListFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.impl.BaseRaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.impl.CompetitorResultImpl;
import com.sap.sailing.domain.abstractlog.race.impl.CompetitorResultsImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFinishPositioningConfirmedEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFlagEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogPassChangeEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateImpl;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.impl.OfficialCompetitorUpdateProvider;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.event.IRaceCompetitor;
import com.tractrac.model.lib.api.event.RaceCompetitorStatusType;
import com.tractrac.model.lib.api.event.RaceStatusType;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;

public class RaceAndCompetitorStatusWithRaceLogReconciler {
    private static final Logger logger = Logger.getLogger(RaceAndCompetitorStatusWithRaceLogReconciler.class.getName());
    private final DomainFactory domainFactory;
    private final RaceLogResolver raceLogResolver;
    private final LogEventAuthorImpl raceLogEventAuthor;
    private final IRace tractracRace;
    private final Map<Util.Pair<TrackedRace, RaceLog>, RaceLogListener> raceLogListeners;
    private OfficialCompetitorUpdateProvider officialCompetitorUpdateProvider;
    private static final Map<RaceStatusType, Flags> flagForRaceStatus = new HashMap<RaceStatusType, Flags>();
    private final ConcurrentLinkedQueue<RaceLogEvent> raceLogEventsAddedToRaceLogByMyself = new ConcurrentLinkedQueue();

    static {
        flagForRaceStatus.put(RaceStatusType.ABANDONED, Flags.NOVEMBER);
        flagForRaceStatus.put(RaceStatusType.POSTPONED, Flags.AP);
        flagForRaceStatus.put(RaceStatusType.GENERAL_RECALL, Flags.FIRSTSUBSTITUTE);
    }

    public RaceAndCompetitorStatusWithRaceLogReconciler(DomainFactory domainFactory, RaceLogResolver raceLogResolver, IRace tractracRace) {
        this.domainFactory = domainFactory;
        this.raceLogResolver = raceLogResolver;
        this.tractracRace = tractracRace;
        this.raceLogListeners = Collections.synchronizedMap(new HashMap());
        this.raceLogEventAuthor = new LogEventAuthorImpl(this.getClass().getName(), 1);
    }

    public void raceLogAttached(TrackedRace trackedRace, RaceLog raceLog) {
        RaceLogListener listener = new RaceLogListener(trackedRace, raceLog);
        raceLog.addListener((Object)listener);
        this.raceLogListeners.put((Util.Pair<TrackedRace, RaceLog>)new Util.Pair((Object)trackedRace, (Object)raceLog), listener);
    }

    public void raceLogDetached(TrackedRace trackedRace, RaceLog raceLog) {
        RaceLogListener listener = this.raceLogListeners.remove(new Util.Pair((Object)trackedRace, (Object)raceLog));
        if (listener != null) {
            raceLog.removeListener((Object)listener);
        }
    }

    public void reconcileRaceStatus(IRace tractracRace, TrackedRace trackedRace) {
        RaceStatusType raceStatus = tractracRace.getStatus();
        TimePoint raceStatusUpdateTime = TimePoint.of((long)tractracRace.getStatusLastChangedTime());
        RaceLogFlagEvent abortingFlagEvent = null;
        for (RaceLog raceLog : trackedRace.getAttachedRaceLogs()) {
            ReadonlyRaceState raceState;
            RaceLogRaceStatus status;
            if (abortingFlagEvent != null || !(status = (raceState = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)trackedRace.getRaceLogResolver(), (RaceLog)raceLog)).getStatus()).isAbortingFlagFromPreviousPassValid()) continue;
            AbortingFlagFinder abortingFlagFinder = new AbortingFlagFinder(raceLog);
            abortingFlagEvent = (RaceLogFlagEvent)abortingFlagFinder.analyze();
        }
        for (RaceLog raceLog : trackedRace.getAttachedRaceLogs()) {
            boolean resultsAreOfficial = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.raceLogResolver, (RaceLog)raceLog).isResultsAreOfficial();
            if (raceStatus == RaceStatusType.OFFICIAL && !resultsAreOfficial) {
                logger.info("Race status for race " + trackedRace.getName() + " is OFFICIAL with TracTrac and we have it as not official so far. Scheduling update.");
                Runnable setResultsAreOfficial = () -> {
                    logger.info("Setting race status for race " + trackedRace.getName() + " to OFFICIAL now");
                    RaceStateImpl.create((RaceLogResolver)this.raceLogResolver, (RaceLog)raceLog, (AbstractLogEventAuthor)this.raceLogEventAuthor).setResultsAreOfficial(raceStatusUpdateTime);
                };
                if (this.officialCompetitorUpdateProvider != null) {
                    logger.info("Enqueuing the setting of race status for race " + trackedRace.getName() + " to OFFICIAL until all competitor updates have been handled");
                    this.officialCompetitorUpdateProvider.runWhenNoMoreOfficialCompetitorUpdatesPending(setResultsAreOfficial);
                } else {
                    setResultsAreOfficial.run();
                }
            }
            if (abortingFlagEvent != null && !this.isAbortedState(raceStatus) && raceStatusUpdateTime.after(abortingFlagEvent.getLogicalTimePoint())) {
                logger.info("RaceLog considered race " + trackedRace.getName() + " as aborted (" + abortingFlagEvent + "), and the TracTrac race status " + raceStatus + " from " + raceStatusUpdateTime + " suggests it's not aborted. Starting a new pass.");
                this.startNewPass(raceStatusUpdateTime, raceLog);
                continue;
            }
            if (!this.isAbortedState(raceStatus) || abortingFlagEvent != null && (this.abortingFlagMatches(raceStatus, abortingFlagEvent.getUpperFlag()) || !raceStatusUpdateTime.after(abortingFlagEvent.getLogicalTimePoint()))) continue;
            Flags upperFlag = flagForRaceStatus.get(raceStatus);
            logger.info("RaceLog considered race " + trackedRace.getName() + " as NOT aborted, and the TracTrac race status " + raceStatus + " from " + raceStatusUpdateTime + " suggests it's aborted. Adding abort flag event " + upperFlag + ", starting a new pass.");
            RaceLogFlagEventImpl flagEvent = new RaceLogFlagEventImpl(raceStatusUpdateTime, (AbstractLogEventAuthor)this.raceLogEventAuthor, raceLog.getCurrentPassId(), upperFlag, Flags.NONE, true);
            this.addRaceLogEventAndPreventRecursion(raceLog, (RaceLogEvent)flagEvent);
            this.startNewPass(raceStatusUpdateTime, raceLog);
        }
    }

    private void addRaceLogEventAndPreventRecursion(RaceLog raceLog, RaceLogEvent event) {
        this.raceLogEventsAddedToRaceLogByMyself.add(event);
        raceLog.add((AbstractLogEvent)event);
    }

    protected void startNewPass(TimePoint timePointForStartOfNewPass, RaceLog raceLog) {
        RaceLogPassChangeEventImpl passChangeEvent = new RaceLogPassChangeEventImpl(timePointForStartOfNewPass, (AbstractLogEventAuthor)this.raceLogEventAuthor, raceLog.getCurrentPassId() + 1);
        this.addRaceLogEventAndPreventRecursion(raceLog, (RaceLogEvent)passChangeEvent);
    }

    private boolean abortingFlagMatches(RaceStatusType raceStatus, Flags upperFlag) {
        return flagForRaceStatus.get(raceStatus) == upperFlag;
    }

    private boolean isAbortedState(RaceStatusType raceStatus) {
        return raceStatus == RaceStatusType.ABANDONED || raceStatus == RaceStatusType.GENERAL_RECALL || raceStatus == RaceStatusType.POSTPONED;
    }

    private MaxPointsReason getMaxPointsReason(RaceCompetitorStatusType raceCompetitorStatusType) {
        MaxPointsReason result;
        if (raceCompetitorStatusType == null) {
            result = MaxPointsReason.NONE;
        } else {
            switch (raceCompetitorStatusType) {
                case ABANDONED: {
                    result = MaxPointsReason.NONE;
                    break;
                }
                case BFD: {
                    result = MaxPointsReason.BFD;
                    break;
                }
                case DISQUALIFIED: {
                    result = MaxPointsReason.DSQ;
                    break;
                }
                case DNC: {
                    result = MaxPointsReason.DNC;
                    break;
                }
                case DNF: {
                    result = MaxPointsReason.DNF;
                    break;
                }
                case DONT_RACE: {
                    result = MaxPointsReason.DNS;
                    break;
                }
                case FIN: {
                    result = MaxPointsReason.NONE;
                    break;
                }
                case FINISH_CONFIRMED: {
                    result = MaxPointsReason.NONE;
                    break;
                }
                case MIS: {
                    result = MaxPointsReason.NONE;
                    break;
                }
                case NO_COLLECT: {
                    result = MaxPointsReason.NONE;
                    break;
                }
                case NO_DATA: {
                    result = MaxPointsReason.NONE;
                    break;
                }
                case OCS: {
                    result = MaxPointsReason.OCS;
                    break;
                }
                case RACING: {
                    result = MaxPointsReason.NONE;
                    break;
                }
                case RETIRED: {
                    result = MaxPointsReason.RET;
                    break;
                }
                case UFD: {
                    result = MaxPointsReason.UFD;
                    break;
                }
                case NSC: {
                    result = MaxPointsReason.NSC;
                    break;
                }
                case TLE: {
                    result = MaxPointsReason.TLE;
                    break;
                }
                case SCP: {
                    result = MaxPointsReason.SCP;
                    break;
                }
                case STP: {
                    result = MaxPointsReason.STP;
                    break;
                }
                case DCT: {
                    result = MaxPointsReason.DCT;
                    break;
                }
                case DNE: {
                    result = MaxPointsReason.DNE;
                    break;
                }
                case RCT: {
                    result = MaxPointsReason.RCT;
                    break;
                }
                default: {
                    result = MaxPointsReason.NONE;
                }
            }
        }
        return result;
    }

    public void reconcileCompetitorStatus(IRaceCompetitor raceCompetitor, TrackedRace trackedRace) {
        int officialRank = raceCompetitor.getOfficialRank();
        long officialFinishingTime = raceCompetitor.getOfficialFinishTime();
        long timePointForStatusEvent = raceCompetitor.getStatusLastChangedTime();
        logger.info("Received a status change for competitor " + raceCompetitor + " in race " + trackedRace.getRaceIdentifier() + ": officialRank: " + officialRank + ", officialFinishingTime: " + officialFinishingTime + ", competitorStatus: " + raceCompetitor.getStatus() + ", statusTime: " + timePointForStatusEvent);
        if (timePointForStatusEvent != 0L) {
            Competitor competitor = this.domainFactory.resolveCompetitor(raceCompetitor.getCompetitor());
            if (competitor == null) {
                logger.warning("Received a competitor status update from TracTrac for a competitor in race " + raceCompetitor.getRace() + " we don't know: " + raceCompetitor.getCompetitor() + "; ignoring.");
            } else {
                RaceCompetitorStatusType competitorStatus = raceCompetitor.getStatus();
                MaxPointsReason officialMaxPointsReason = this.getMaxPointsReason(competitorStatus);
                MillisecondsTimePoint officialResultTime = new MillisecondsTimePoint(timePointForStatusEvent);
                for (RaceLog raceLog : trackedRace.getAttachedRaceLogs()) {
                    Util.Pair<CompetitorResult, TimePoint> resultFromRaceLogAndItsCreationTimePoint = this.getRaceLogResultAndCreationTimePointForCompetitor(raceLog, competitor);
                    if (resultFromRaceLogAndItsCreationTimePoint == null || (((CompetitorResult)resultFromRaceLogAndItsCreationTimePoint.getA()).getOneBasedRank() != officialRank || (((CompetitorResult)resultFromRaceLogAndItsCreationTimePoint.getA()).getFinishingTime() == null ? 0L : ((CompetitorResult)resultFromRaceLogAndItsCreationTimePoint.getA()).getFinishingTime().asMillis()) != officialFinishingTime || ((CompetitorResult)resultFromRaceLogAndItsCreationTimePoint.getA()).getMaxPointsReason() != officialMaxPointsReason) && ((TimePoint)resultFromRaceLogAndItsCreationTimePoint.getB()).before((TimePoint)officialResultTime)) {
                        logger.info("Applying official competitor result because its time point " + officialResultTime + " is newer than the latest result for that competitor from the race log " + (resultFromRaceLogAndItsCreationTimePoint == null ? "null" : (Serializable)resultFromRaceLogAndItsCreationTimePoint.getB()));
                        CompetitorResultImpl resultForRaceLog = new CompetitorResultImpl(competitor.getId(), competitor.getName(), competitor.getShortName(), competitor.hasBoat() ? ((CompetitorWithBoat)competitor).getBoat().getName() : competitor.getShortInfo(), competitor.hasBoat() ? ((CompetitorWithBoat)competitor).getBoat().getSailID() : competitor.getShortInfo(), officialRank, officialMaxPointsReason, null, (TimePoint)(officialFinishingTime == 0L ? null : new MillisecondsTimePoint(officialFinishingTime)), "Official results from TracTrac connector", CompetitorResult.MergeState.OK);
                        CompetitorResultsImpl resultsForRaceLog = new CompetitorResultsImpl();
                        resultsForRaceLog.add((CompetitorResult)resultForRaceLog);
                        RaceLogFinishPositioningConfirmedEventImpl raceLogEvent = new RaceLogFinishPositioningConfirmedEventImpl((TimePoint)officialResultTime, (TimePoint)officialResultTime, (AbstractLogEventAuthor)this.raceLogEventAuthor, (Serializable)UUID.randomUUID(), raceLog.getCurrentPassId(), (CompetitorResults)resultsForRaceLog);
                        this.addRaceLogEventAndPreventRecursion(raceLog, (RaceLogEvent)raceLogEvent);
                        logger.info("Added the following result to the race log of " + trackedRace.getRaceIdentifier() + " for competitor " + raceCompetitor + ": " + resultForRaceLog);
                        continue;
                    }
                    logger.info("Did not produce a new competitor result for competitor " + raceCompetitor + " in race " + trackedRace.getRaceIdentifier() + " because existing result " + resultFromRaceLogAndItsCreationTimePoint + " was not older than status time " + officialResultTime + " or was an equal result");
                }
            }
        } else {
            logger.info("Ignoring status change for competitor " + raceCompetitor + " in race " + trackedRace.getRaceIdentifier() + " because the status time was 0");
        }
    }

    protected Util.Pair<CompetitorResult, TimePoint> getRaceLogResultAndCreationTimePointForCompetitor(RaceLog raceLog, Competitor competitor) {
        Optional<CompetitorResult> result;
        Util.Pair resultFromRaceLogAndItsCreationTimePoint = null;
        ReadonlyRaceState raceState = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.raceLogResolver, (RaceLog)raceLog);
        AbstractFinishPositioningListFinder.CompetitorResultsAndTheirCreationTimePoints results = raceState.getConfirmedFinishPositioningList();
        if (results.getCompetitorResults() != null && (result = StreamSupport.stream(results.getCompetitorResults().spliterator(), false).filter(r -> Util.equalsWithNull((Object)competitor.getId(), (Object)r.getCompetitorId())).findAny()).isPresent()) {
            resultFromRaceLogAndItsCreationTimePoint = new Util.Pair((Object)result.get(), (Object)results.getCreationTimePointOfResultForCompetitorWithId(result.get().getCompetitorId()));
        }
        return resultFromRaceLogAndItsCreationTimePoint;
    }

    public void setOfficialCompetitorUpdateProvider(OfficialCompetitorUpdateProvider officialCompetitorUpdateProvider) {
        this.officialCompetitorUpdateProvider = officialCompetitorUpdateProvider;
    }

    private class RaceLogListener
    extends BaseRaceLogEventVisitor {
        private final RaceLog raceLog;
        private final TrackedRace trackedRace;

        public RaceLogListener(TrackedRace trackedRace, RaceLog raceLog) {
            this.raceLog = raceLog;
            this.trackedRace = trackedRace;
            RaceAndCompetitorStatusWithRaceLogReconciler.this.reconcileRaceStatus(RaceAndCompetitorStatusWithRaceLogReconciler.this.tractracRace, trackedRace);
            this.reconcileAllCompetitors(trackedRace);
        }

        private void reconcileAllCompetitors(TrackedRace trackedRace) {
            for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
                if (!(competitor.getId() instanceof UUID)) continue;
                IRaceCompetitor raceCompetitor = RaceAndCompetitorStatusWithRaceLogReconciler.this.tractracRace.getRaceCompetitor((UUID)competitor.getId());
                RaceAndCompetitorStatusWithRaceLogReconciler.this.reconcileCompetitorStatus(raceCompetitor, trackedRace);
            }
        }

        public void visit(RaceLogFlagEvent event) {
            if (!RaceAndCompetitorStatusWithRaceLogReconciler.this.raceLogEventsAddedToRaceLogByMyself.remove(event)) {
                RaceAndCompetitorStatusWithRaceLogReconciler.this.reconcileRaceStatus(RaceAndCompetitorStatusWithRaceLogReconciler.this.tractracRace, this.trackedRace);
            }
        }

        public void visit(RaceLogPassChangeEvent event) {
            if (!RaceAndCompetitorStatusWithRaceLogReconciler.this.raceLogEventsAddedToRaceLogByMyself.remove(event)) {
                RaceAndCompetitorStatusWithRaceLogReconciler.this.reconcileRaceStatus(RaceAndCompetitorStatusWithRaceLogReconciler.this.tractracRace, this.trackedRace);
                this.reconcileAllCompetitors(this.trackedRace);
            }
        }

        public void visit(RaceLogFinishPositioningConfirmedEvent event) {
            if (!RaceAndCompetitorStatusWithRaceLogReconciler.this.raceLogEventsAddedToRaceLogByMyself.remove(event)) {
                this.reconcileCompetitorsWithResults(event);
            }
        }

        public void visit(RaceLogRevokeEvent event) {
            if (!RaceAndCompetitorStatusWithRaceLogReconciler.this.raceLogEventsAddedToRaceLogByMyself.remove(event)) {
                RaceLogEvent revokedEvent;
                this.raceLog.lockForRead();
                try {
                    revokedEvent = (RaceLogEvent)this.raceLog.getEventById(event.getRevokedEventId());
                }
                finally {
                    this.raceLog.unlockAfterRead();
                }
                if (revokedEvent != null) {
                    if (revokedEvent instanceof RaceLogFinishPositioningConfirmedEvent) {
                        RaceLogFinishPositioningConfirmedEvent revokedResultsEvent = (RaceLogFinishPositioningConfirmedEvent)revokedEvent;
                        this.reconcileCompetitorsWithResults(revokedResultsEvent);
                    } else if (revokedEvent instanceof RaceLogFlagEvent || revokedEvent instanceof RaceLogPassChangeEvent) {
                        RaceAndCompetitorStatusWithRaceLogReconciler.this.reconcileRaceStatus(RaceAndCompetitorStatusWithRaceLogReconciler.this.tractracRace, this.trackedRace);
                    }
                }
            }
        }

        private void reconcileCompetitorsWithResults(RaceLogFinishPositioningConfirmedEvent resultsEvent) {
            for (CompetitorResult competitorResult : resultsEvent.getPositionedCompetitorsIDsNamesMaxPointsReasons()) {
                Serializable competitorId = competitorResult.getCompetitorId();
                if (!(competitorId instanceof UUID)) continue;
                RaceAndCompetitorStatusWithRaceLogReconciler.this.reconcileCompetitorStatus(RaceAndCompetitorStatusWithRaceLogReconciler.this.tractracRace.getRaceCompetitor((UUID)competitorId), this.trackedRace);
            }
        }
    }
}

