/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.impl.AbstractReceiverWithQueue;
import com.sap.sailing.domain.tractracadapter.impl.OfficialCompetitorUpdateProvider;
import com.sap.sailing.domain.tractracadapter.impl.RaceAndCompetitorStatusWithRaceLogReconciler;
import com.sap.sailing.domain.tractracadapter.impl.Simulator;
import com.sap.sse.common.Util;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.event.IRaceCompetitor;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import com.tractrac.subscription.lib.api.race.IRaceCompetitorListener;
import java.util.UUID;
import java.util.logging.Logger;

public class CompetitorChangeReceiver
extends AbstractReceiverWithQueue<IRaceCompetitor, Void, Void>
implements OfficialCompetitorUpdateProvider {
    private static final Logger logger = Logger.getLogger(CompetitorChangeReceiver.class.getName());
    private final IRaceCompetitorListener listener;
    private final RaceAndCompetitorStatusWithRaceLogReconciler reconciler;

    public CompetitorChangeReceiver(DynamicTrackedRegatta trackedRegatta, IEvent tractracEvent, IRace tractracRace, Simulator simulator, DomainFactory domainFactory, IEventSubscriber eventSubscriber, IRaceSubscriber raceSubscriber, long timeoutInMilliseconds, RaceAndCompetitorStatusWithRaceLogReconciler raceAndCompetitorStatusWithRaceLogReconciler) {
        super(domainFactory, tractracEvent, trackedRegatta, simulator, eventSubscriber, raceSubscriber, timeoutInMilliseconds);
        this.reconciler = raceAndCompetitorStatusWithRaceLogReconciler;
        this.reconciler.setOfficialCompetitorUpdateProvider(this);
        this.listener = new IRaceCompetitorListener(){

            public void addRaceCompetitor(long timestamp, IRaceCompetitor raceCompetitor) {
                logger.warning("The competitor " + raceCompetitor + " was added to the race " + CompetitorChangeReceiver.this.getTrackedRace(raceCompetitor.getRace()) + " but we don't know how to handle this. Ignoring.");
            }

            public void updateRaceCompetitor(long timestamp, IRaceCompetitor raceCompetitor) {
                CompetitorChangeReceiver.this.enqueue(new Util.Triple((Object)raceCompetitor, null, null));
            }

            public void deleteRaceCompetitor(long timestamp, UUID competitorId) {
                logger.warning("The competitor with ID " + competitorId + " was removed from a race " + "but we don't know how to handle this. Ignoring.");
            }

            public void removeOffsetPositions(long timestamp, UUID competitorId, int offset) {
            }
        };
    }

    @Override
    public void subscribe() {
        this.getRaceSubscriber().subscribeRaceCompetitor(this.listener);
        this.startThread();
    }

    @Override
    protected void unsubscribe() {
        this.getRaceSubscriber().unsubscribeRaceCompetitor(this.listener);
    }

    @Override
    protected void handleEvent(Util.Triple<IRaceCompetitor, Void, Void> event) {
        IRace race = ((IRaceCompetitor)event.getA()).getRace();
        if (race == null) {
            logger.warning("Received a competitor update for a null race for competitor " + ((IRaceCompetitor)event.getA()).getCompetitor().getName() + " in " + this + ". Ignoring.");
        } else {
            DynamicTrackedRace trackedRace = this.getTrackedRace(race);
            if (trackedRace != null) {
                IRaceCompetitor raceCompetitor = (IRaceCompetitor)event.getA();
                if (this.reconciler != null && raceCompetitor != null) {
                    this.reconciler.reconcileCompetitorStatus(raceCompetitor, (TrackedRace)trackedRace);
                }
            } else {
                logger.warning("Couldn't find tracked race for race " + race.getName() + ". Dropping competitor change event " + event);
            }
        }
    }

    @Override
    public void runWhenNoMoreOfficialCompetitorUpdatesPending(Runnable runnable) {
        this.callBackWhenLoadingQueueIsDone(receiver -> runnable.run());
    }
}

