/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.tractracadapter.impl;

import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tractracadapter.DomainFactory;
import com.sap.sailing.domain.tractracadapter.LoadingQueueDoneCallBack;
import com.sap.sailing.domain.tractracadapter.Receiver;
import com.sap.sailing.domain.tractracadapter.impl.Simulator;
import com.sap.sailing.domain.tractracadapter.impl.TracTracRaceTrackerImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.tractrac.model.lib.api.event.IEvent;
import com.tractrac.model.lib.api.event.IRace;
import com.tractrac.model.lib.api.map.IMapItem;
import com.tractrac.model.lib.api.map.IPositionedItem;
import com.tractrac.subscription.lib.api.IEventSubscriber;
import com.tractrac.subscription.lib.api.IRaceSubscriber;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractReceiverWithQueue<A, B, C>
implements Runnable,
Receiver {
    private static Logger logger = Logger.getLogger(AbstractReceiverWithQueue.class.getName());
    private static final long RETRY_TIMEOUT_IN_MILLIS = Duration.ONE_MINUTE.asMillis();
    private final LinkedBlockingDeque<Util.Triple<A, B, C>> queue;
    private final DomainFactory domainFactory;
    private final IEvent tractracEvent;
    private final IEventSubscriber eventSubscriber;
    private final IRaceSubscriber raceSubscriber;
    private final DynamicTrackedRegatta trackedRegatta;
    private final Simulator simulator;
    private final Thread thread;
    private final Map<Util.Triple<A, B, C>, Set<LoadingQueueDoneCallBack>> loadingQueueDoneCallBacks;
    private final long timeoutInMilliseconds;
    private boolean receivedEventDuringTimeout;
    private boolean stoppedPreemptively;

    public AbstractReceiverWithQueue(DomainFactory domainFactory, IEvent tractracEvent, DynamicTrackedRegatta trackedRegatta, Simulator simulator, IEventSubscriber eventSubscriber, IRaceSubscriber raceSubscriber, long timeoutInMilliseconds) {
        this.eventSubscriber = eventSubscriber;
        this.raceSubscriber = raceSubscriber;
        this.tractracEvent = tractracEvent;
        this.trackedRegatta = trackedRegatta;
        this.domainFactory = domainFactory;
        this.simulator = simulator;
        this.queue = new LinkedBlockingDeque();
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.loadingQueueDoneCallBacks = new HashMap<Util.Triple<A, B, C>, Set<LoadingQueueDoneCallBack>>();
        this.timeoutInMilliseconds = timeoutInMilliseconds;
    }

    protected IEventSubscriber getEventSubscriber() {
        return this.eventSubscriber;
    }

    protected IRaceSubscriber getRaceSubscriber() {
        return this.raceSubscriber;
    }

    protected synchronized void startThread() {
        this.thread.start();
    }

    protected DomainFactory getDomainFactory() {
        return this.domainFactory;
    }

    protected IEvent getTracTracEvent() {
        return this.tractracEvent;
    }

    protected DynamicTrackedRegatta getTrackedRegatta() {
        return this.trackedRegatta;
    }

    @Override
    public void stopPreemptively() {
        this.queue.clear();
        this.stopAfterProcessingQueuedEvents();
        this.stoppedPreemptively = true;
    }

    protected boolean hasBeenStoppedPreemptively() {
        return this.stoppedPreemptively;
    }

    @Override
    public void stopAfterProcessingQueuedEvents() {
        this.queue.add(new Util.Triple(null, null, null));
    }

    protected Simulator getSimulator() {
        return this.simulator;
    }

    protected abstract void unsubscribe();

    @Override
    public void stopAfterNotReceivingEventsForSomeTime(final long timeoutInMilliseconds) {
        this.receivedEventDuringTimeout = false;
        TracTracRaceTrackerImpl.scheduler.schedule(new Runnable(){

            @Override
            public void run() {
                if (!AbstractReceiverWithQueue.this.receivedEventDuringTimeout) {
                    logger.info("Stopping receiver " + AbstractReceiverWithQueue.this + " of class " + AbstractReceiverWithQueue.this.getClass().getName() + " after not having received an event during " + timeoutInMilliseconds + "ms");
                    AbstractReceiverWithQueue.this.stopAfterProcessingQueuedEvents();
                } else {
                    logger.info("Rescheduling the stopping of receiver " + AbstractReceiverWithQueue.this + " for another " + timeoutInMilliseconds + "ms");
                    AbstractReceiverWithQueue.this.receivedEventDuringTimeout = false;
                    TracTracRaceTrackerImpl.scheduler.schedule(this, timeoutInMilliseconds, TimeUnit.MILLISECONDS);
                }
            }
        }, timeoutInMilliseconds, TimeUnit.MILLISECONDS);
    }

    protected void enqueue(Util.Triple<A, B, C> event) {
        this.queue.add(event);
        this.receivedEventDuringTimeout = true;
    }

    private boolean isStopEvent(Util.Triple<A, B, C> event) {
        return event.getA() == null && event.getB() == null && event.getC() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Util.Triple<A, B, C> event = null;
        while (event == null || !this.isStopEvent(event)) {
            try {
                Set<Object> callBacks;
                event = this.queue.take();
                Map<Util.Triple<A, B, C>, Set<LoadingQueueDoneCallBack>> map = this.loadingQueueDoneCallBacks;
                synchronized (map) {
                    if (this.getSimulator() != null) {
                        callBacks = new HashSet();
                        for (Set<LoadingQueueDoneCallBack> set : this.loadingQueueDoneCallBacks.values()) {
                            callBacks.addAll(set);
                        }
                        this.loadingQueueDoneCallBacks.clear();
                    } else {
                        callBacks = this.loadingQueueDoneCallBacks.remove(event);
                    }
                }
                if (!this.isStopEvent(event)) {
                    this.handleEvent(event);
                }
                if (callBacks == null) continue;
                for (LoadingQueueDoneCallBack loadingQueueDoneCallBack : callBacks) {
                    loadingQueueDoneCallBack.loadingQueueDone(this);
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.INFO, "Interrupted while taking element from queue", e);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, this + " is terminating abnormally; the race will probably be left at LOADING (100%).", e);
                throw e;
            }
        }
        this.unsubscribe();
    }

    @Override
    public synchronized void join() throws InterruptedException {
        if (this.thread != null) {
            this.thread.join();
        }
    }

    @Override
    public synchronized void join(long timeoutInMilliseconds) throws InterruptedException {
        if (this.thread != null) {
            this.thread.join(timeoutInMilliseconds);
        }
    }

    protected abstract void handleEvent(Util.Triple<A, B, C> var1);

    protected DynamicTrackedRace getTrackedRace(IRace race) {
        Regatta domainRegatta;
        RaceDefinition raceDefinition;
        long effectiveTimeoutInMilliseconds;
        DynamicTrackedRace result = null;
        long l = effectiveTimeoutInMilliseconds = this.timeoutInMilliseconds == -1L ? RETRY_TIMEOUT_IN_MILLIS : this.timeoutInMilliseconds;
        while ((raceDefinition = this.getDomainFactory().getAndWaitForRaceDefinition(race.getId(), effectiveTimeoutInMilliseconds)) == null && this.timeoutInMilliseconds == -1L && !this.hasBeenStoppedPreemptively()) {
        }
        if (raceDefinition != null && (domainRegatta = this.trackedRegatta.getRegatta()).getRaceByName(raceDefinition.getName()) != null) {
            result = this.trackedRegatta.getTrackedRace(raceDefinition);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callBackWhenLoadingQueueIsDone(LoadingQueueDoneCallBack callback) {
        Map<Util.Triple<A, B, C>, Set<LoadingQueueDoneCallBack>> map = this.loadingQueueDoneCallBacks;
        synchronized (map) {
            Util.Triple<A, B, C> lastInQueue = this.queue.peekLast();
            if (lastInQueue == null || this.getSimulator() != null) {
                callback.loadingQueueDone(this);
            } else {
                Util.addToValueSet(this.loadingQueueDoneCallBacks, lastInQueue, (Object)callback);
            }
        }
    }

    protected void ensureAllSingleMarksOfCourseAreaAreCreated(IRace tractracRace) {
        for (IMapItem tractracControlPoint : this.getDomainFactory().getControlsForCourseArea(this.getTracTracEvent(), tractracRace.getCourseArea())) {
            if (tractracControlPoint.isMultiple()) continue;
            IPositionedItem mark = (IPositionedItem)tractracControlPoint.getPositionedItems().get(0);
            this.getDomainFactory().getOrCreateMark(mark);
        }
    }

    public String toString() {
        return "Receiver " + this.getClass().getName() + " for regatta " + this.getTrackedRegatta().getRegatta().getName() + " in event " + this.getTracTracEvent().getName() + " with ID " + this.getTracTracEvent().getId();
    }
}

