/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.sap.sailing.landscape.ui.shared.SailingAnalyticsProcessDTO;
import com.sap.sse.common.Named;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.aws.common.shared.RedirectDTO;
import com.sap.sse.security.ui.client.UserService;
import java.util.ArrayList;

public class SailingApplicationReplicaSetDTO<ShardingKey>
implements Named,
IsSerializable {
    private static final long serialVersionUID = 8449684019896974806L;
    private String replicaSetName;
    private SailingAnalyticsProcessDTO master;
    private ArrayList<SailingAnalyticsProcessDTO> replicas;
    private String version;
    private String releaseNotesLink;
    private String hostname;
    private String defaultRedirectPath;
    private String autoScalingGroupAmiId;

    @Deprecated
    SailingApplicationReplicaSetDTO() {
    }

    public SailingApplicationReplicaSetDTO(String replicaSetName, SailingAnalyticsProcessDTO master, Iterable<SailingAnalyticsProcessDTO> replicas, String version, String releaseNotesLink, String hostname, String defaultRedirectPath, String autoScalingGroupAmiId) {
        this.master = master;
        this.replicaSetName = replicaSetName;
        this.version = version;
        this.replicas = new ArrayList();
        this.releaseNotesLink = releaseNotesLink;
        this.hostname = hostname;
        this.defaultRedirectPath = defaultRedirectPath;
        this.autoScalingGroupAmiId = autoScalingGroupAmiId;
        Util.addAll(replicas, this.replicas);
    }

    public String getName() {
        return this.getReplicaSetName();
    }

    public String getReplicaSetName() {
        return this.replicaSetName;
    }

    public SailingAnalyticsProcessDTO getMaster() {
        return this.master;
    }

    public ArrayList<SailingAnalyticsProcessDTO> getReplicas() {
        return this.replicas;
    }

    public String getVersion() {
        return this.version;
    }

    public String getReleaseNotesLink() {
        return this.releaseNotesLink;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getDefaultRedirectPath() {
        return this.defaultRedirectPath;
    }

    public String getAutoScalingGroupAmiId() {
        return this.autoScalingGroupAmiId;
    }

    public RedirectDTO getDefaultRedirect() {
        return RedirectDTO.from((String)this.getDefaultRedirectPath());
    }

    public boolean isLocalReplicaSet(UserService userService) {
        return this.getName().equals(userService.getServerInfo().getName());
    }

    public boolean isArchive() {
        return this.getName().equals("ARCHIVE");
    }

    public String toString() {
        return "SailingApplicationReplicaSetDTO [replicaSetName=" + this.replicaSetName + ", master=" + this.master + ", replicas=" + this.replicas + ", version=" + this.version + ", hostname=" + this.hostname + ", defaultRedirectPath=" + this.defaultRedirectPath + ", autoScalingGroupAmiId=" + this.autoScalingGroupAmiId + "]";
    }
}

