/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.user.cellview.client.AbstractCellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SetSelectionModel;
import com.sap.sailing.landscape.ui.client.AddSshKeyDialog;
import com.sap.sailing.landscape.ui.client.AwsAccessKeyProvider;
import com.sap.sailing.landscape.ui.client.GenerateSshKeyDialog;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.SshKeyDisplayAndDownloadDialog;
import com.sap.sailing.landscape.ui.client.SshKeyPairImagesBarCell;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sailing.landscape.ui.shared.SSHKeyPairDTO;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.adminconsole.AdminConsoleTableResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.ImagesBarCell;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.celltable.TableWrapperWithSingleSelectionAndFilter;
import com.sap.sse.gwt.client.controls.busyindicator.BusyIndicator;
import com.sap.sse.gwt.client.controls.busyindicator.SimpleBusyIndicator;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.landscape.common.shared.SecuredLandscapeTypes;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.dto.SecuredDTO;
import com.sap.sse.security.ui.client.UserManagementWriteServiceAsync;
import com.sap.sse.security.ui.client.UserService;
import com.sap.sse.security.ui.client.component.AccessControlledActionsColumn;
import com.sap.sse.security.ui.client.component.AccessControlledButtonPanel;
import com.sap.sse.security.ui.client.component.EditOwnershipDialog;
import com.sap.sse.security.ui.client.component.SecuredDTOOwnerColumn;
import com.sap.sse.security.ui.client.component.editacl.EditACLDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;

public class SshKeyManagementPanel
extends VerticalPanel {
    private final LandscapeManagementWriteServiceAsync landscapeManagementService;
    private final TableWrapperWithSingleSelectionAndFilter<SSHKeyPairDTO, StringMessages, AdminConsoleTableResources> sshKeyTable;
    private final PasswordTextBox sshPrivateKeyPassphrase;
    private final BusyIndicator sshKeyLoadingBusy;
    private final ErrorReporter errorReporter;
    private final RefreshableSingleSelectionModel<String> regionSelectionModel;
    private final Label passphraseStatus;
    private final Label passphraseText;

    public SshKeyManagementPanel(final StringMessages stringMessages, UserService userService, final LandscapeManagementWriteServiceAsync landscapeManagementService, AdminConsoleTableResources tableResources, final ErrorReporter errorReporter, AwsAccessKeyProvider awsAccessKeyProvider, RefreshableSingleSelectionModel<String> regionSelectionModel, int countKeysPerPage) {
        this.regionSelectionModel = regionSelectionModel;
        this.landscapeManagementService = landscapeManagementService;
        this.errorReporter = errorReporter;
        this.sshPrivateKeyPassphrase = new PasswordTextBox();
        this.passphraseStatus = new Label();
        AccessControlledButtonPanel buttonPanel = new AccessControlledButtonPanel(userService, SecuredLandscapeTypes.SSH_KEY);
        this.add((Widget)buttonPanel);
        Button addButton = buttonPanel.addCreateAction(stringMessages.add(), () -> this.openAddSshKeyDialog(stringMessages, awsAccessKeyProvider));
        addButton.setEnabled(regionSelectionModel.getSelectedObject() != null && awsAccessKeyProvider.hasValidSessionCredentials());
        Button generateButton = buttonPanel.addCreateAction(stringMessages.generate(), () -> this.openGenerateSshKeyDialog(stringMessages, awsAccessKeyProvider));
        generateButton.setEnabled(regionSelectionModel.getSelectedObject() != null && awsAccessKeyProvider.hasValidSessionCredentials());
        this.sshKeyTable = new TableWrapperWithSingleSelectionAndFilter<SSHKeyPairDTO, StringMessages, AdminConsoleTableResources>(stringMessages, errorReporter, true, Optional.of(new EntityIdentityComparator<SSHKeyPairDTO>(){

            public boolean representSameEntity(SSHKeyPairDTO dto1, SSHKeyPairDTO dto2) {
                return Util.equalsWithNull((Object)dto1.getRegionId(), (Object)dto2.getRegionId()) && Util.equalsWithNull((Object)dto1.getName(), (Object)dto2.getName());
            }

            public int hashCode(SSHKeyPairDTO t) {
                return (t.getRegionId() == null ? 0 : t.getRegionId().hashCode()) ^ (t.getName() == null ? 0 : t.getName().hashCode());
            }
        }), tableResources, Optional.of(sshKey -> userService.hasPermission((SecuredDTO)sshKey, (HasPermissions.Action)HasPermissions.DefaultActions.UPDATE)), Optional.empty(), stringMessages.hideElementsWithoutUpdateRights()){

            protected Iterable<String> getSearchableStrings(SSHKeyPairDTO t) {
                return Arrays.asList(t.getName(), t.getRegionId(), t.getCreatorName());
            }
        };
        this.sshKeyTable.getTable().setPageSize(countKeysPerPage);
        this.sshKeyTable.addColumn(object -> object.getRegionId(), stringMessages.region());
        this.sshKeyTable.addColumn(object -> object.getName(), stringMessages.name());
        this.sshKeyTable.addColumn(object -> object.getCreatorName(), stringMessages.creator());
        this.sshKeyTable.addColumn(object -> object.getCreationTime().toString(), stringMessages.creationTime());
        SecuredDTOOwnerColumn.configureOwnerColumns((AbstractCellTable)this.sshKeyTable.getTable(), (ColumnSortEvent.ListHandler)this.sshKeyTable.getColumnSortHandler(), (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        AccessControlledActionsColumn sshKeyPairActionColumn = AccessControlledActionsColumn.create((ImagesBarCell)new SshKeyPairImagesBarCell(stringMessages), (UserService)userService);
        EditOwnershipDialog.DialogConfig editOwnerShipDialog = EditOwnershipDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)SecuredLandscapeTypes.SSH_KEY, competitorDTO -> this.sshKeyTable.refresh(), (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        sshKeyPairActionColumn.addAction(SshKeyPairImagesBarCell.ACTION_CHANGE_OWNERSHIP, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_OWNERSHIP, arg_0 -> ((EditOwnershipDialog.DialogConfig)editOwnerShipDialog).openOwnershipDialog(arg_0));
        EditACLDialog.DialogConfig configACL = EditACLDialog.create((UserManagementWriteServiceAsync)userService.getUserManagementWriteService(), (HasPermissions)SecuredLandscapeTypes.SSH_KEY, null, (com.sap.sse.security.ui.client.i18n.StringMessages)stringMessages);
        sshKeyPairActionColumn.addAction(SshKeyPairImagesBarCell.ACTION_CHANGE_ACL, (HasPermissions.Action)HasPermissions.DefaultActions.CHANGE_ACL, arg_0 -> ((EditACLDialog.DialogConfig)configACL).openDialog(arg_0));
        sshKeyPairActionColumn.addAction("ACTION_REMOVE", (HasPermissions.Action)HasPermissions.DefaultActions.DELETE, sshKeyPairDTO -> landscapeManagementService.removeSshKey((SSHKeyPairDTO)((Object)sshKeyPairDTO), new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(Void result) {
                SshKeyManagementPanel.this.sshKeyTable.remove((Object)sshKeyPairDTO);
            }
        }));
        sshKeyPairActionColumn.addAction(SshKeyPairImagesBarCell.ACTION_SHOW_KEYS, (HasPermissions.Action)HasPermissions.DefaultActions.READ, sshKeyPairDTO -> landscapeManagementService.getSshPublicKey(sshKeyPairDTO.getRegionId(), sshKeyPairDTO.getName(), new AsyncCallback<byte[]>(){

            public void onFailure(Throwable caught) {
                errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(final byte[] publicKey) {
                landscapeManagementService.getEncryptedSshPrivateKey(sshKeyPairDTO.getRegionId(), sshKeyPairDTO.getName(), new AsyncCallback<byte[]>(){

                    public void onFailure(Throwable caught) {
                        errorReporter.reportError(caught.getMessage());
                    }

                    public void onSuccess(byte[] encryptedPrivateKey) {
                        SshKeyManagementPanel.this.showKeys(sshKeyPairDTO.getName(), publicKey, encryptedPrivateKey, stringMessages);
                    }
                });
            }
        }));
        this.sshKeyTable.addColumn((Column)sshKeyPairActionColumn);
        this.add((IsWidget)this.sshKeyTable);
        this.passphraseText = new Label(stringMessages.sshPrivateKeyPassphraseForSelectedKeyPair());
        this.add((Widget)this.passphraseText);
        this.add((Widget)this.sshPrivateKeyPassphrase);
        this.add((Widget)this.passphraseStatus);
        this.sshKeyLoadingBusy = new SimpleBusyIndicator();
        this.add((Widget)this.sshKeyLoadingBusy);
        buttonPanel.addRemoveAction(stringMessages.remove(), (SetSelectionModel)this.sshKeyTable.getSelectionModel(), true, () -> landscapeManagementService.removeSshKey((SSHKeyPairDTO)((Object)((Object)((RefreshableSingleSelectionModel)this.sshKeyTable.getSelectionModel()).getSelectedObject())), new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(Void result) {
                SshKeyManagementPanel.this.sshKeyTable.remove((Object)((SSHKeyPairDTO)((Object)((RefreshableSingleSelectionModel)SshKeyManagementPanel.this.sshKeyTable.getSelectionModel()).getSelectedObject())));
            }
        }));
        regionSelectionModel.addSelectionChangeHandler(e -> {
            boolean validSessionCredentials = awsAccessKeyProvider.hasValidSessionCredentials();
            if (validSessionCredentials) {
                this.showKeysInRegion((String)regionSelectionModel.getSelectedObject());
            }
            addButton.setEnabled(regionSelectionModel.getSelectedObject() != null && validSessionCredentials);
            generateButton.setEnabled(regionSelectionModel.getSelectedObject() != null && validSessionCredentials);
        });
        this.addSshKeySelectionChangedHandler(event -> {
            boolean value = ((RefreshableSingleSelectionModel)this.sshKeyTable.getSelectionModel()).getSelectedObject() != null;
            this.sshPrivateKeyPassphrase.setVisible(value);
            this.passphraseText.setVisible(value);
            this.passphraseStatus.setVisible(value);
        });
        awsAccessKeyProvider.addListener(validSessionCredentials -> {
            if (validSessionCredentials) {
                this.showKeysInRegion((String)regionSelectionModel.getSelectedObject());
            }
            addButton.setEnabled(regionSelectionModel.getSelectedObject() != null && validSessionCredentials);
            generateButton.setEnabled(regionSelectionModel.getSelectedObject() != null && validSessionCredentials);
        });
    }

    public void addSshKeySelectionChangedHandler(SelectionChangeEvent.Handler handler) {
        ((RefreshableSingleSelectionModel)this.sshKeyTable.getSelectionModel()).addSelectionChangeHandler(handler);
    }

    public String getPassphraseForPrivateKeyDecryption() {
        return this.sshPrivateKeyPassphrase.getValue();
    }

    private void showKeys(String keyName, byte[] publicKey, byte[] encryptedPrivateKey, StringMessages stringMessages) {
        new SshKeyDisplayAndDownloadDialog(keyName, publicKey, encryptedPrivateKey, stringMessages).show();
    }

    private void openGenerateSshKeyDialog(StringMessages stringMessages, AwsAccessKeyProvider awsAccessKeyProvider) {
        new GenerateSshKeyDialog(stringMessages, new DataEntryDialog.DialogCallback<Util.Triple<String, String, String>>(){

            public void ok(Util.Triple<String, String, String> keyPairNameAndPassphrases) {
                SshKeyManagementPanel.this.landscapeManagementService.generateSshKeyPair((String)SshKeyManagementPanel.this.regionSelectionModel.getSelectedObject(), (String)keyPairNameAndPassphrases.getA(), (String)keyPairNameAndPassphrases.getB(), new AsyncCallback<SSHKeyPairDTO>(){

                    public void onFailure(Throwable caught) {
                        SshKeyManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    }

                    public void onSuccess(SSHKeyPairDTO result) {
                        SshKeyManagementPanel.this.sshKeyTable.add((Object)result);
                    }
                });
            }

            public void cancel() {
            }
        }).show();
    }

    private void openAddSshKeyDialog(StringMessages stringMessages, AwsAccessKeyProvider awsAccessKeyProvider) {
        new AddSshKeyDialog(stringMessages, new DataEntryDialog.DialogCallback<Util.Triple<String, String, String>>(){

            public void ok(Util.Triple<String, String, String> keyPairNameAndPublicAndPrivateKey) {
                SshKeyManagementPanel.this.landscapeManagementService.addSshKeyPair((String)SshKeyManagementPanel.this.regionSelectionModel.getSelectedObject(), (String)keyPairNameAndPublicAndPrivateKey.getA(), (String)keyPairNameAndPublicAndPrivateKey.getB(), (String)keyPairNameAndPublicAndPrivateKey.getC(), new AsyncCallback<SSHKeyPairDTO>(){

                    public void onFailure(Throwable caught) {
                        SshKeyManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    }

                    public void onSuccess(SSHKeyPairDTO result) {
                        SshKeyManagementPanel.this.sshKeyTable.add((Object)result);
                    }
                });
            }

            public void cancel() {
            }
        }).show();
    }

    public void showKeysInRegion(String regionId) {
        this.sshKeyTable.getFilterPanel().removeAll();
        if (regionId != null) {
            this.sshKeyLoadingBusy.setBusy(true);
            this.landscapeManagementService.getSshKeys(regionId, new AsyncCallback<ArrayList<SSHKeyPairDTO>>(){

                public void onFailure(Throwable caught) {
                    SshKeyManagementPanel.this.errorReporter.reportError(caught.getMessage());
                    SshKeyManagementPanel.this.sshKeyLoadingBusy.setBusy(false);
                }

                public void onSuccess(ArrayList<SSHKeyPairDTO> sshKeyPairDTOs) {
                    SshKeyManagementPanel.this.sshKeyTable.refresh(sshKeyPairDTOs);
                    SshKeyManagementPanel.this.sshKeyLoadingBusy.setBusy(false);
                }
            });
        }
    }

    public SSHKeyPairDTO getSelectedKeyPair() {
        return (SSHKeyPairDTO)((Object)((RefreshableSingleSelectionModel)this.sshKeyTable.getSelectionModel()).getSelectedObject());
    }

    public void addOnPassphraseChangedListener(ChangeHandler handler) {
        this.sshPrivateKeyPassphrase.addChangeHandler(handler);
    }

    public void setPassphraseValidation(boolean isValid, com.sap.sse.gwt.adminconsole.StringMessages stringMessages) {
        this.passphraseStatus.setText(isValid ? stringMessages.validPassphrase() : stringMessages.invalidPassphrase());
        this.passphraseStatus.getElement().getStyle().setColor(isValid ? "green" : "red");
    }
}

