/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ListBox;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.ArrayList;
import java.util.Collections;

public class LandscapeDialogUtil {
    public static ListBox createInstanceTypeListBox(DataEntryDialog<?> dialog, LandscapeManagementWriteServiceAsync landscapeManagementService, StringMessages stringMessages, String defaultInstanceTypeName, ErrorReporter errorReporter, boolean canBeDeployedInNlbInstanceBasedTargetGroup) {
        return LandscapeDialogUtil.createInstanceTypeListBoxWithAdditionalDefaultEntry(dialog, null, null, landscapeManagementService, stringMessages, defaultInstanceTypeName, errorReporter, canBeDeployedInNlbInstanceBasedTargetGroup);
    }

    public static ListBox createInstanceTypeListBoxWithAdditionalDefaultEntry(DataEntryDialog<?> dialog, final String additionalItem, String additionalValue, LandscapeManagementWriteServiceAsync landscapeManagementService, StringMessages stringMessages, final String defaultInstanceTypeName, final ErrorReporter errorReporter, boolean canBeDeployedInNlbInstanceBasedTargetGroup) {
        final ListBox instanceTypeBox = dialog.createListBox(false);
        if (additionalItem != null) {
            instanceTypeBox.addItem(additionalItem, additionalValue);
            instanceTypeBox.setSelectedIndex(0);
        }
        landscapeManagementService.getInstanceTypeNames(canBeDeployedInNlbInstanceBasedTargetGroup, new AsyncCallback<ArrayList<String>>(){

            public void onFailure(Throwable caught) {
                errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(ArrayList<String> result) {
                Collections.sort(result, new NaturalComparator());
                int i = 0;
                for (String instanceType : result) {
                    instanceTypeBox.addItem(instanceType, instanceType);
                    if (additionalItem == null && instanceType.equals(defaultInstanceTypeName)) {
                        instanceTypeBox.setSelectedIndex(i);
                    }
                    ++i;
                }
            }
        });
        return instanceTypeBox;
    }

    public static void selectInstanceType(ListBox instanceTypeListBox, String instanceTypeName) {
        int i = 0;
        while (i < instanceTypeListBox.getItemCount()) {
            if (instanceTypeListBox.getValue(i).equals(instanceTypeName)) {
                instanceTypeListBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }
}

