/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sailing.landscape.ui.shared.SailingApplicationReplicaSetDTO;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import com.sap.sse.landscape.aws.common.shared.EventRedirectDTO;
import com.sap.sse.landscape.aws.common.shared.EventSeriesRedirectDTO;
import com.sap.sse.landscape.aws.common.shared.HomeRedirectDTO;
import com.sap.sse.landscape.aws.common.shared.PlainRedirectDTO;
import com.sap.sse.landscape.aws.common.shared.RedirectDTO;
import com.sap.sse.landscape.aws.common.shared.RedirectWithIdDTO;
import java.util.UUID;

public class DefineRedirectDialog
extends DataEntryDialog<RedirectDTO> {
    private final String RADIO_BUTTON_GROUP_NAME = "redirect-choice";
    private final RadioButton plain;
    private final RadioButton home;
    private final RadioButton event;
    private final TextBox eventIdBox;
    private final RadioButton eventSeries;
    private final TextBox eventSeriesIdBox;

    public DefineRedirectDialog(SailingApplicationReplicaSetDTO<String> applicationReplicaSetToDefineLandingPageFor, StringMessages stringMessages, ErrorReporter errorReporter, LandscapeManagementWriteServiceAsync landscapeManagementService, DataEntryDialog.DialogCallback<RedirectDTO> dialogCallback) {
        super(stringMessages.defineDefaultRedirect(), stringMessages.defineDefaultRedirectMessage(), stringMessages.ok(), stringMessages.cancel(), (DataEntryDialog.Validator)new Validator(stringMessages), true, dialogCallback);
        ValueChangeHandler valueChangeHandler = e -> this.updateIdBoxEnabling();
        this.plain = new RadioButton("redirect-choice", stringMessages.redirectPlain());
        this.plain.addValueChangeHandler(valueChangeHandler);
        this.home = new RadioButton("redirect-choice", stringMessages.redirectHome());
        this.home.addValueChangeHandler(valueChangeHandler);
        this.event = new RadioButton("redirect-choice", stringMessages.redirectEvent());
        this.event.addValueChangeHandler(valueChangeHandler);
        this.eventIdBox = this.createTextBox("", 40);
        this.eventSeries = new RadioButton("redirect-choice", stringMessages.redirectEventSeries());
        this.eventSeries.addValueChangeHandler(valueChangeHandler);
        this.eventSeriesIdBox = this.createTextBox("", 40);
    }

    private void updateIdBoxEnabling() {
        this.eventIdBox.setEnabled(this.event.getValue().booleanValue());
        this.eventSeriesIdBox.setEnabled(this.eventSeries.getValue().booleanValue());
        this.validateAndUpdate();
    }

    protected Widget getAdditionalWidget() {
        Grid result = new Grid(4, 2);
        int row = 0;
        result.setWidget(row++, 0, (Widget)this.plain);
        result.setWidget(row++, 0, (Widget)this.home);
        result.setWidget(row, 0, (Widget)this.event);
        result.setWidget(row++, 1, (Widget)this.eventIdBox);
        result.setWidget(row, 0, (Widget)this.eventSeries);
        result.setWidget(row++, 1, (Widget)this.eventSeriesIdBox);
        this.plain.setValue(Boolean.valueOf(true), true);
        return result;
    }

    protected RedirectDTO getResult() {
        PlainRedirectDTO result;
        if (this.plain.getValue().booleanValue()) {
            result = new PlainRedirectDTO();
        } else if (this.home.getValue().booleanValue()) {
            result = new HomeRedirectDTO();
        } else if (this.event.getValue().booleanValue()) {
            UUID id;
            try {
                id = UUID.fromString(this.eventIdBox.getValue());
            }
            catch (Exception e) {
                id = null;
            }
            result = new EventRedirectDTO(id);
        } else if (this.eventSeries.getValue().booleanValue()) {
            UUID id;
            try {
                id = UUID.fromString(this.eventSeriesIdBox.getValue());
            }
            catch (Exception e) {
                id = null;
            }
            result = new EventSeriesRedirectDTO(id);
        } else {
            throw new IllegalStateException("Internal error; one of the radio buttons should have been selected");
        }
        return result;
    }

    private static class Validator
    implements DataEntryDialog.Validator<RedirectDTO> {
        final StringMessages stringMessages;

        public Validator(StringMessages stringMessages) {
            this.stringMessages = stringMessages;
        }

        public String getErrorMessage(RedirectDTO valueToValidate) {
            String error = valueToValidate instanceof RedirectWithIdDTO && ((RedirectWithIdDTO)valueToValidate).getId() == null ? this.stringMessages.pleaseProvideAValidId() : null;
            return error;
        }
    }
}

