/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.landscape.ui.client.AwsAccessKeyProvider;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.Notification;
import com.sap.sse.gwt.client.dialog.DialogUtils;
import com.sap.sse.security.ui.client.UserService;
import java.util.HashSet;
import java.util.Set;

public class AwsMfaLoginWidget
extends VerticalPanel
implements AwsAccessKeyProvider {
    private static final String AWS_ACCESS_KEY_USER_PREFERENCE = "aws.access.key";
    private final TextBox awsAccessKeyTextBox;
    private final PasswordTextBox awsSecretPasswordTextBox;
    private final TextBox mfaTokenCodeTextBox;
    private final TextBox sessionTokenTextBox;
    private final LandscapeManagementWriteServiceAsync landscapeManagementService;
    private final ErrorReporter errorReporter;
    private final Grid awsCredentialsGrid;
    private final Set<AwsMfaLoginListener> listeners = new HashSet<AwsMfaLoginListener>();
    private boolean hasValidSessionCredentials;

    public AwsMfaLoginWidget(LandscapeManagementWriteServiceAsync landscapeManagementService, final ErrorReporter errorReporter, UserService userService, final StringMessages stringMessages) {
        this.landscapeManagementService = landscapeManagementService;
        this.errorReporter = errorReporter;
        HorizontalPanel buttonPanel = new HorizontalPanel();
        this.add((Widget)buttonPanel);
        Button refreshButton = new Button(stringMessages.refresh());
        buttonPanel.add((Widget)refreshButton);
        Button logoutButton = new Button(stringMessages.logout());
        buttonPanel.add((Widget)logoutButton);
        this.awsCredentialsGrid = new Grid(5, 2);
        this.add((Widget)this.awsCredentialsGrid);
        this.awsCredentialsGrid.setWidget(0, 0, (Widget)new Label(stringMessages.awsAccessKey()));
        this.awsAccessKeyTextBox = new TextBox();
        userService.getPreference(AWS_ACCESS_KEY_USER_PREFERENCE, (AsyncCallback)new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
                errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(String result) {
                AwsMfaLoginWidget.this.awsAccessKeyTextBox.setValue((Object)result);
            }
        });
        this.awsAccessKeyTextBox.addValueChangeHandler(e -> userService.setPreference(AWS_ACCESS_KEY_USER_PREFERENCE, this.awsAccessKeyTextBox.getValue(), (AsyncCallback)new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(Void result) {
            }
        }));
        int row = 0;
        this.awsCredentialsGrid.setWidget(row++, 1, (Widget)this.awsAccessKeyTextBox);
        this.awsCredentialsGrid.setWidget(row, 0, (Widget)new Label(stringMessages.awsSecret()));
        this.awsSecretPasswordTextBox = new PasswordTextBox();
        this.awsCredentialsGrid.setWidget(row++, 1, (Widget)this.awsSecretPasswordTextBox);
        this.mfaTokenCodeTextBox = new TextBox();
        this.awsCredentialsGrid.setWidget(row, 0, (Widget)new Label(stringMessages.mfaTokenCode()));
        this.awsCredentialsGrid.setWidget(row++, 1, (Widget)this.mfaTokenCodeTextBox);
        this.sessionTokenTextBox = new TextBox();
        this.awsCredentialsGrid.setWidget(row, 0, (Widget)new Label(stringMessages.optionalSessionToken()));
        this.awsCredentialsGrid.setWidget(row++, 1, (Widget)this.sessionTokenTextBox);
        Button loginButton = new Button(stringMessages.login());
        this.awsCredentialsGrid.setWidget(row++, 0, (Widget)loginButton);
        this.awsCredentialsGrid.setVisible(false);
        refreshButton.addClickHandler(e -> this.checkSessionCredentials());
        AsyncCallback<Void> sessionCredentialsCallback = new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                errorReporter.reportError(stringMessages.invalidCredentialsNoSessionCreated(caught.getMessage()));
                AwsMfaLoginWidget.this.checkSessionCredentials();
            }

            public void onSuccess(Void result) {
                Notification.notify((String)stringMessages.loggedInSuccessfully(), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                AwsMfaLoginWidget.this.checkSessionCredentials();
            }
        };
        loginButton.addClickHandler(arg_0 -> this.lambda$2(landscapeManagementService, (AsyncCallback)sessionCredentialsCallback, arg_0));
        logoutButton.addClickHandler(e -> landscapeManagementService.clearSessionCredentials(new AsyncCallback<Void>(){

            public void onFailure(Throwable caught) {
                errorReporter.reportError(caught.getMessage());
                AwsMfaLoginWidget.this.checkSessionCredentials();
            }

            public void onSuccess(Void result) {
                Notification.notify((String)stringMessages.loggedOutSuccessfully(), (Notification.NotificationType)Notification.NotificationType.SUCCESS);
                AwsMfaLoginWidget.this.checkSessionCredentials();
            }
        }));
        DialogUtils.linkEnterToButton((Button)loginButton, (HasAllKeyHandlers[])new HasAllKeyHandlers[]{this.awsAccessKeyTextBox, this.awsSecretPasswordTextBox, this.mfaTokenCodeTextBox});
        this.checkSessionCredentials();
    }

    @Override
    public void addListener(AwsMfaLoginListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean hasValidSessionCredentials() {
        return this.hasValidSessionCredentials;
    }

    private void setHasValidSessionCredentials(boolean validSessionCredentials) {
        boolean oldHasValidSessionCredentials = this.hasValidSessionCredentials;
        this.hasValidSessionCredentials = validSessionCredentials;
        this.awsCredentialsGrid.setVisible(!validSessionCredentials);
        if (oldHasValidSessionCredentials != validSessionCredentials) {
            this.listeners.forEach(l -> l.awsSessionStatusChanged(validSessionCredentials));
        }
    }

    private void checkSessionCredentials() {
        this.landscapeManagementService.hasValidSessionCredentials(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
                AwsMfaLoginWidget.this.setHasValidSessionCredentials(false);
                AwsMfaLoginWidget.this.errorReporter.reportError(caught.getMessage());
            }

            public void onSuccess(Boolean hasValidCredentials) {
                AwsMfaLoginWidget.this.setHasValidSessionCredentials(hasValidCredentials);
            }
        });
    }

    private /* synthetic */ void lambda$2(LandscapeManagementWriteServiceAsync landscapeManagementWriteServiceAsync, AsyncCallback asyncCallback, ClickEvent e) {
        if (Util.hasLength((String)this.mfaTokenCodeTextBox.getValue())) {
            landscapeManagementWriteServiceAsync.createMfaSessionCredentials(this.awsAccessKeyTextBox.getValue(), this.awsSecretPasswordTextBox.getValue(), this.mfaTokenCodeTextBox.getValue(), (AsyncCallback<Void>)asyncCallback);
        } else {
            landscapeManagementWriteServiceAsync.createSessionCredentials(this.awsAccessKeyTextBox.getValue(), this.awsSecretPasswordTextBox.getValue(), this.sessionTokenTextBox.getValue(), (AsyncCallback<Void>)asyncCallback);
        }
    }

    @FunctionalInterface
    public static interface AwsMfaLoginListener {
        public void awsSessionStatusChanged(boolean var1);
    }
}

