/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.ui.client;

import com.google.gwt.user.client.ui.MultiWordSuggestOracle;
import com.google.gwt.user.client.ui.SuggestBox;
import com.google.gwt.user.client.ui.TextBox;
import com.sap.sailing.landscape.ui.client.LandscapeManagementWriteServiceAsync;
import com.sap.sailing.landscape.ui.client.i18n.StringMessages;
import com.sap.sse.common.Util;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.dialog.DataEntryDialog;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;

public abstract class AbstractApplicationReplicaSetDialog<I extends AbstractApplicationReplicaSetInstructions>
extends DataEntryDialog<I> {
    private final StringMessages stringMessages;
    private final SuggestBox releaseNameBox;
    private final TextBox masterReplicationBearerTokenBox;
    private final TextBox replicaReplicationBearerTokenBox;

    public AbstractApplicationReplicaSetDialog(String title, LandscapeManagementWriteServiceAsync landscapeManagementService, Iterable<String> releaseNames, StringMessages stringMessages, ErrorReporter errorReporter, DataEntryDialog.Validator<I> validator, DataEntryDialog.DialogCallback<I> callback) {
        super(title, null, stringMessages.ok(), stringMessages.cancel(), validator, callback);
        this.stringMessages = stringMessages;
        LinkedList<String> releaseNamesAndLatestMaster = new LinkedList<String>();
        Util.addAll(releaseNames, releaseNamesAndLatestMaster);
        Comparator newestFirstComaprator = (r1, r2) -> r2.compareTo((String)r1);
        Collections.sort(releaseNamesAndLatestMaster, newestFirstComaprator);
        releaseNamesAndLatestMaster.add(0, stringMessages.latestMasterRelease());
        this.releaseNameBox = this.createSuggestBox(releaseNamesAndLatestMaster);
        if (this.releaseNameBox.getSuggestOracle() instanceof MultiWordSuggestOracle) {
            ((MultiWordSuggestOracle)this.releaseNameBox.getSuggestOracle()).setComparator(newestFirstComaprator);
        }
        this.releaseNameBox.setValue(stringMessages.latestMasterRelease());
        this.masterReplicationBearerTokenBox = this.createTextBox("", 40);
        this.replicaReplicationBearerTokenBox = this.createTextBox("", 40);
    }

    protected StringMessages getStringMessages() {
        return this.stringMessages;
    }

    protected SuggestBox getReleaseNameBox() {
        return this.releaseNameBox;
    }

    protected String getReleaseNameBoxValue() {
        return !Util.hasLength((String)this.releaseNameBox.getValue()) || Util.equalsWithNull((Object)this.releaseNameBox.getValue(), (Object)this.stringMessages.latestMasterRelease()) ? null : this.releaseNameBox.getValue();
    }

    protected TextBox getMasterReplicationBearerTokenBox() {
        return this.masterReplicationBearerTokenBox;
    }

    protected TextBox getReplicaReplicationBearerTokenBox() {
        return this.replicaReplicationBearerTokenBox;
    }

    public static class AbstractApplicationReplicaSetInstructions {
        private final String masterReplicationBearerToken;
        private final String replicaReplicationBearerToken;
        private final String releaseNameOrNullForLatestMaster;

        public AbstractApplicationReplicaSetInstructions(String releaseNameOrNullForLatestMaster, String masterReplicationBearerToken, String replicaReplicationBearerToken) {
            this.masterReplicationBearerToken = masterReplicationBearerToken;
            this.replicaReplicationBearerToken = replicaReplicationBearerToken;
            this.releaseNameOrNullForLatestMaster = releaseNameOrNullForLatestMaster;
        }

        public String getReleaseNameOrNullForLatestMaster() {
            return this.releaseNameOrNullForLatestMaster;
        }

        public String getMasterReplicationBearerToken() {
            return this.masterReplicationBearerToken;
        }

        public String getReplicaReplicationBearerToken() {
            return this.replicaReplicationBearerToken;
        }
    }
}

