/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.mail.impl;

import com.sap.sse.common.IsManagedByCache;
import com.sap.sse.common.mail.MailException;
import com.sap.sse.mail.MailServiceResolver;
import com.sap.sse.mail.SerializableMultipartSupplier;
import com.sap.sse.mail.impl.ReplicableMailService;
import com.sap.sse.mail.operations.MailServiceOperation;
import com.sap.sse.mail.operations.SendMailOperation;
import com.sap.sse.mail.operations.SendMailWithMultipartSupplierOperation;
import com.sap.sse.replication.interfaces.impl.AbstractReplicableWithObjectInputStream;
import com.sap.sse.util.ObjectInputStreamResolvingAgainstCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

public class MailServiceImpl
extends AbstractReplicableWithObjectInputStream<ReplicableMailService, MailServiceOperation<?>>
implements ReplicableMailService {
    private static final Logger logger = Logger.getLogger(MailServiceImpl.class.getName());
    private Properties mailProperties;
    private final MailServiceResolver mailServiceResolver;

    public MailServiceImpl(Properties mailProperties, MailServiceResolver mailServiceResolver) {
        this.mailProperties = mailProperties;
        this.mailServiceResolver = mailServiceResolver;
    }

    private boolean canSendMail() {
        return this.mailProperties != null && this.mailProperties.containsKey("mail.transport.protocol");
    }

    private boolean isSendMailSetInactive() {
        boolean mailInactive = this.mailProperties != null && this.mailProperties.get("mail.enabled") != null ? "false".equals(String.valueOf(this.mailProperties.get("mail.enabled")).toLowerCase()) : false;
        return mailInactive;
    }

    protected void internalSendMail(String toAddress, String subject, ContentSetter contentSetter) throws MailException {
        if (this.canSendMail()) {
            if (toAddress != null) {
                Object[] toAddresses = toAddress.split(",");
                Session session = Session.getInstance((Properties)this.mailProperties, (Authenticator)new SMTPAuthenticator());
                MimeMessage msg = new MimeMessage(session);
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    try {
                        msg.setFrom((Address)new InternetAddress(this.mailProperties.getProperty("mail.from", "root@sapsailing.com")));
                        try {
                            msg.setSubject(MimeUtility.encodeText((String)subject, (String)"utf-8", (String)"B"));
                        }
                        catch (UnsupportedEncodingException e) {
                            msg.setSubject(subject);
                        }
                        Object[] objectArray = toAddresses;
                        int n = toAddresses.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object singleToAddress = objectArray[n2];
                            msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(((String)singleToAddress).trim()));
                            ++n2;
                        }
                        Thread.currentThread().setContextClassLoader(Session.class.getClassLoader());
                        contentSetter.setContent(msg);
                        Transport ts = session.getTransport();
                        ts.connect();
                        ts.sendMessage((Message)msg, msg.getRecipients(Message.RecipientType.TO));
                        ts.close();
                        logger.info("mail sent to " + Arrays.toString(toAddresses) + " with subject " + subject);
                    }
                    catch (MessagingException e) {
                        logger.severe("Error trying to send mail to " + Arrays.toString(toAddresses) + ": " + e.getMessage());
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
        } else {
            logger.warning("No mail properties provided. Cannot send e-mail about " + subject + " to " + toAddress + ". This could also mean that this is running on a replica server in which case this is perfectly fine. " + "The master " + this.getMasterDescriptor() + " will handle the mail sending operation in this case.");
        }
    }

    @Override
    public Void internalSendMail(String toAddress, String subject, final String body) throws MailException {
        this.internalSendMail(toAddress, subject, new ContentSetter(){

            @Override
            public void setContent(MimeMessage msg) throws MessagingException {
                msg.setContent((Object)body, "text/plain; charset=UTF-8");
            }
        });
        return null;
    }

    @Override
    public void sendMail(String toAddress, String subject, String body) throws MailException {
        if (this.isSendMailSetInactive()) {
            logger.warning("would send email, currently disabled.");
            logger.info("toAddress: " + toAddress);
            logger.info("subject: " + subject);
            logger.info("body: " + body);
        } else {
            this.apply(new SendMailOperation(toAddress, subject, body));
        }
    }

    @Override
    public Void internalSendMail(String toAddress, String subject, final SerializableMultipartSupplier multipartSupplier) throws MailException {
        this.internalSendMail(toAddress, subject, new ContentSetter(){

            @Override
            public void setContent(MimeMessage msg) throws MessagingException {
                msg.setContent(multipartSupplier.get());
            }
        });
        return null;
    }

    @Override
    public void sendMail(String toAddress, String subject, SerializableMultipartSupplier multipartSupplier) throws MailException {
        if (this.isSendMailSetInactive()) {
            logger.warning("would send email, currently disabled.");
            logger.info("toAddress: " + toAddress);
            logger.info("subject: " + subject);
            logger.info("multipartSupplier");
        } else {
            this.apply(new SendMailWithMultipartSupplierOperation(toAddress, subject, multipartSupplier));
        }
    }

    public void clearReplicaState() throws MalformedURLException, IOException, InterruptedException {
    }

    public ObjectInputStream createObjectInputStreamResolvingAgainstCache(InputStream is, Map<String, Class<?>> classLoaderCache) throws IOException {
        return new ObjectInputStreamResolvingAgainstCache<MailServiceResolver>(is, this.mailServiceResolver, null, classLoaderCache){};
    }

    public IsManagedByCache<MailServiceResolver> resolve(MailServiceResolver cache) {
        return cache.getMailService();
    }

    public void initiallyFillFromInternal(ObjectInputStream is) throws IOException, ClassNotFoundException, InterruptedException {
        this.mailProperties = null;
    }

    public void serializeForInitialReplicationInternal(ObjectOutputStream objectOutputStream) throws IOException {
    }

    protected static interface ContentSetter {
        public void setContent(MimeMessage var1) throws MessagingException;
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private SMTPAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            String username = MailServiceImpl.this.mailProperties.getProperty("mail.smtp.user");
            String password = MailServiceImpl.this.mailProperties.getProperty("mail.smtp.password");
            return new PasswordAuthentication(username, password);
        }
    }
}

