/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.yellowbrickadapter.impl;

import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.trackimport.GPSFixImporter;
import com.sap.sailing.domain.yellowbrickadapter.impl.GetPositionsParser;
import com.sap.sailing.domain.yellowbrickadapter.impl.PositionsDocument;
import com.sap.sailing.domain.yellowbrickadapter.impl.TeamPosition;
import com.sap.sailing.domain.yellowbrickadapter.impl.TeamPositions;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.json.simple.parser.ParseException;

public class YellowBrickGPSFixImporter
implements GPSFixImporter {
    private final ConcurrentMap<Util.Pair<Number, String>, TrackFileImportDeviceIdentifier> deviceIdentifiersBySerialAndSourceName = new ConcurrentHashMap<Util.Pair<Number, String>, TrackFileImportDeviceIdentifier>();

    public boolean importFixes(InputStream inputStream, Charset charset, GPSFixImporter.Callback callback, boolean inferSpeedAndBearing, String sourceName) throws FormatNotSupportedException, IOException, ParseException {
        GetPositionsParser parser = new GetPositionsParser();
        PositionsDocument positionsDocument = parser.parse(new InputStreamReader(inputStream, "UTF-8"), inferSpeedAndBearing);
        String raceName = positionsDocument.getRaceUrl();
        for (TeamPositions teamPositions : positionsDocument.getTeams()) {
            String boatName = teamPositions.getCompetitorName();
            int serialOfDevice = teamPositions.getDeviceSerialNumber();
            for (TeamPosition boatFixObject : teamPositions.getPositions()) {
                GPSFixMoving nextFix = boatFixObject.getGPSFixMoving();
                TrackFileImportDeviceIdentifier deviceIdentifier = this.getDeviceIdentifier(sourceName, raceName, boatName, serialOfDevice);
                callback.addFix((GPSFix)nextFix, deviceIdentifier);
            }
        }
        return true;
    }

    private TrackFileImportDeviceIdentifier getDeviceIdentifier(String sourceName, String raceName, String boatName, Number serialOfDevice) {
        Util.Pair key = new Util.Pair((Object)serialOfDevice, (Object)raceName);
        return this.deviceIdentifiersBySerialAndSourceName.computeIfAbsent((Util.Pair<Number, String>)key, k -> new TrackFileImportDeviceIdentifierImpl(UUID.randomUUID(), sourceName, String.valueOf(boatName) + "-" + raceName + "-" + serialOfDevice, TimePoint.now()));
    }

    public Iterable<String> getSupportedFileExtensions() {
        return Collections.singleton("json");
    }

    public String getType() {
        return "YellowBrick GPS Fix Importer";
    }
}

