/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.yellowbrickadapter.impl;

import com.sap.sailing.domain.yellowbrickadapter.impl.TeamPositions;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.Comparator;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PositionsDocument {
    private final String raceUrl;
    private final Iterable<TeamPositions> teams;

    public PositionsDocument(String raceUrl, Iterable<TeamPositions> teams) {
        this.raceUrl = raceUrl;
        this.teams = teams;
    }

    public String getRaceUrl() {
        return this.raceUrl;
    }

    public Iterable<TeamPositions> getTeams() {
        return this.teams;
    }

    public int getNumberOfFixes() {
        return Util.stream(this.teams).mapToInt(team -> Util.size(team.getPositions())).sum();
    }

    public TimePoint getTimePointOfLastFix() {
        Stream<TeamPositions> teams = StreamSupport.stream(this.getTeams().spliterator(), false);
        Function<TeamPositions, Stream> mapper = tp -> StreamSupport.stream(tp.getPositions().spliterator(), true);
        return teams.flatMap(mapper).map(p -> p.getTimePoint()).max(Comparator.naturalOrder()).orElse(null);
    }

    public String toString() {
        return "PositionsDocument [raceUrl=" + this.raceUrl + ", teams=" + this.teams + "]";
    }
}

