/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.kiworesultimport.impl;

import com.sap.sailing.kiworesultimport.Start;
import com.sap.sailing.kiworesultimport.impl.AbstractNodeWrapper;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class StartImpl
extends AbstractNodeWrapper
implements Start {
    private static final DateFormat df = new SimpleDateFormat("yyyy-MM-ddX");

    public StartImpl(Node node) {
        super(node);
    }

    @Override
    public String getBoatClass() {
        Node item = ((Element)this.getNode()).getElementsByTagName("bootsklasse").item(0);
        return item == null ? null : item.getFirstChild().getNodeValue();
    }

    @Override
    public Integer getRaceNumber() {
        return Integer.valueOf(((Element)this.getNode()).getElementsByTagName("wettfahrt").item(0).getFirstChild().getNodeValue());
    }

    @Override
    public String getFleetName() {
        return ((Element)this.getNode()).getElementsByTagName("startgruppe").item(0).getFirstChild().getNodeValue();
    }

    @Override
    public String getCourseName() {
        return ((Element)this.getNode()).getElementsByTagName("kurs").item(0).getFirstChild().getNodeValue();
    }

    @Override
    public String getStartTimeAsString() {
        return ((Element)this.getNode()).getElementsByTagName("startzeit").item(0).getFirstChild().getNodeValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimePoint getTimePoint() throws ParseException {
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            return new MillisecondsTimePoint(df.parse(this.getStartTimeAsString()));
        }
    }

    @Override
    public String getStartFlag() {
        return ((Element)this.getNode()).getElementsByTagName("startflagge").item(0).getFirstChild().getNodeValue();
    }

    @Override
    public String getComment() {
        return ((Element)this.getNode()).getElementsByTagName("bemerkung").item(0).getFirstChild().getNodeValue();
    }

    @Override
    public Boolean isDoubleScore() {
        return Boolean.valueOf(((Element)this.getNode()).getElementsByTagName("doppelte_Wertung").item(0).getFirstChild().getNodeValue());
    }

    @Override
    public Boolean isDiscardable() {
        return Boolean.valueOf(((Element)this.getNode()).getElementsByTagName("streichbar").item(0).getFirstChild().getNodeValue());
    }
}

