/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.expeditionadapter.impl;

import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.trackimport.GPSFixImporter;
import com.sap.sailing.server.trackfiles.impl.CompressedStreamsUtil;
import com.sap.sailing.server.trackfiles.impl.ExpeditionExtendedDataImporterImpl;
import com.sap.sailing.server.trackfiles.impl.ExpeditionImportFileHandler;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExpeditionGPSFixImporter
implements GPSFixImporter {
    private static final Logger logger = Logger.getLogger(ExpeditionGPSFixImporter.class.getName());
    private static final String LAT_COLUMN_HEADING = "lat";
    private static final String LON_COLUMN_HEADING = "lon";
    private static final String COG_COLUMN_HEADING = "cog";
    private static final String SOG_COLUMN_HEADING = "sog";
    private static final String HDT_COLUMN_HEADING = "hdt";

    public boolean importFixes(InputStream inputStream, Charset charset, GPSFixImporter.Callback callback, boolean inferSpeedAndBearing, String sourceName) throws FormatNotSupportedException, IOException {
        TrackFileImportDeviceIdentifierImpl device = new TrackFileImportDeviceIdentifierImpl(sourceName, String.valueOf(this.getType()) + "@" + new Date());
        AtomicBoolean importedFixes = new AtomicBoolean(false);
        CompressedStreamsUtil.handlePotentiallyCompressedFiles((String)sourceName, (InputStream)inputStream, (Charset)charset, (CompressedStreamsUtil.FileHandler)this.getExpeditionImportFileHandler(callback, (TrackFileImportDeviceIdentifier)device, importedFixes));
        return importedFixes.get();
    }

    protected ExpeditionImportFileHandler getExpeditionImportFileHandler(final GPSFixImporter.Callback callback, final TrackFileImportDeviceIdentifier device, final AtomicBoolean importedFixes) {
        return new ExpeditionImportFileHandler(){

            protected void handleExpeditionFile(String fileName, InputStream stream, Charset charset) throws IOException {
                BufferedReader br = new BufferedReader(new InputStreamReader(stream, charset));
                String headerLine = br.readLine();
                ExpeditionExtendedDataImporterImpl importer = new ExpeditionExtendedDataImporterImpl();
                Map columnDefinitions = importer.parseHeader(headerLine);
                AtomicInteger lineNr = new AtomicInteger(0);
                br.lines().forEach(line -> {
                    if (!line.trim().isEmpty()) {
                        importer.parseLine((long)lineNr.incrementAndGet(), fileName, line, columnDefinitions, (timePoint, columnValues, columns) -> {
                            Bearing optionalTrueHeading;
                            double latDeg = Double.parseDouble(columnValues[(Integer)columns.get(ExpeditionGPSFixImporter.LAT_COLUMN_HEADING)]);
                            double lonDeg = Double.parseDouble(columnValues[(Integer)columns.get(ExpeditionGPSFixImporter.LON_COLUMN_HEADING)]);
                            double cogDeg = Double.parseDouble(columnValues[(Integer)columns.get(ExpeditionGPSFixImporter.COG_COLUMN_HEADING)]);
                            double sogKnots = Double.parseDouble(columnValues[(Integer)columns.get(ExpeditionGPSFixImporter.SOG_COLUMN_HEADING)]);
                            DegreePosition position = new DegreePosition(latDeg, lonDeg);
                            if (columns.containsKey(ExpeditionGPSFixImporter.HDT_COLUMN_HEADING)) {
                                try {
                                    optionalTrueHeading = new DegreeBearingImpl(Double.parseDouble(columnValues[(Integer)columns.get(ExpeditionGPSFixImporter.HDT_COLUMN_HEADING)])).add(DeclinationService.INSTANCE.getDeclination(timePoint, (Position)position, 1000L).getBearingCorrectedTo(timePoint));
                                }
                                catch (IOException | NumberFormatException | ParseException e) {
                                    logger.log(Level.WARNING, "Problem obtaining declination for Expedition fix heading", e);
                                    optionalTrueHeading = null;
                                }
                            } else {
                                optionalTrueHeading = null;
                            }
                            GPSFixMovingImpl fix = new GPSFixMovingImpl((Position)position, timePoint, (SpeedWithBearing)new KnotSpeedWithBearingImpl(sogKnots, (Bearing)new DegreeBearingImpl(cogDeg)), optionalTrueHeading);
                            callback.addFix((GPSFix)fix, device);
                            importedFixes.set(true);
                        });
                    }
                });
            }
        };
    }

    public Iterable<String> getSupportedFileExtensions() {
        return this.getExpeditionImportFileHandler(null, null, null).getSupportedFileExtensions();
    }

    public String getType() {
        return "Expedition";
    }
}

