/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.shared.tracking.impl;

import com.sap.sailing.domain.shared.tracking.AddResult;
import com.sap.sailing.domain.shared.tracking.FixAcceptancePredicate;
import com.sap.sailing.domain.shared.tracking.Track;
import com.sap.sailing.domain.shared.tracking.impl.TimeRangeCache;
import com.sap.sailing.domain.shared.tracking.impl.TimedComparator;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.shared.util.impl.ArrayListNavigableSet;
import com.sap.sse.shared.util.impl.UnmodifiableNavigableSet;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.function.Function;

public class TrackImpl<FixType extends Timed>
implements Track<FixType> {
    private static final long serialVersionUID = -4075853657857657528L;
    private final ArrayListNavigableSet<Timed> fixes;
    private final NamedReentrantReadWriteLock readWriteLock;

    public TrackImpl(String nameForReadWriteLock) {
        this((ArrayListNavigableSet<Timed>)new ArrayListNavigableSet(TimedComparator.INSTANCE), nameForReadWriteLock);
    }

    protected TrackImpl(ArrayListNavigableSet<Timed> fixes, String nameForReadWriteLock) {
        this.readWriteLock = new NamedReentrantReadWriteLock(nameForReadWriteLock, false);
        this.fixes = fixes;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.lockForRead();
        try {
            s.defaultWriteObject();
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public void lockForRead() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.readWriteLock);
    }

    @Override
    public void unlockAfterRead() {
        LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.readWriteLock);
    }

    protected void lockForWrite() {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.readWriteLock);
    }

    protected void unlockAfterWrite() {
        LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.readWriteLock);
    }

    protected NavigableSet<FixType> getInternalRawFixes() {
        ArrayListNavigableSet<Timed> result = this.fixes;
        return result;
    }

    protected void assertReadLock() {
        if (this.readWriteLock.getReadHoldCount() < 1 && this.readWriteLock.getWriteHoldCount() < 1) {
            throw new IllegalStateException("Caller must obtain read lock using lockForRead() before calling this method");
        }
    }

    protected void assertWriteLock() {
        if (this.readWriteLock.getWriteHoldCount() < 1) {
            throw new IllegalStateException("Caller must obtain write lock using lockForWrite() before calling this method");
        }
    }

    protected NavigableSet<FixType> getInternalFixes() {
        NavigableSet<FixType> result = this.getInternalRawFixes();
        return result;
    }

    @Override
    public NavigableSet<FixType> getFixes() {
        this.assertReadLock();
        return new UnmodifiableNavigableSet(this.getInternalFixes());
    }

    @Override
    public Iterable<FixType> getFixes(TimePoint from, boolean fromInclusive, TimePoint to, boolean toInclusive) {
        return this.getFixes().subSet(this.getDummyFix(from), fromInclusive, this.getDummyFix(to), toInclusive);
    }

    @Override
    public NavigableSet<FixType> getRawFixes() {
        this.assertReadLock();
        return new UnmodifiableNavigableSet(this.getInternalRawFixes());
    }

    @Override
    public FixType getLastFixAtOrBefore(TimePoint timePoint) {
        return this.getLastFixAtOrBefore(timePoint, null);
    }

    private FixType getLastFixAtOrBefore(TimePoint timePoint, FixAcceptancePredicate<FixType> fixAcceptancePredicate) {
        this.lockForRead();
        try {
            NavigableSet<FixType> headSet = this.getInternalFixes().headSet(this.getDummyFix(timePoint), true);
            Iterator<FixType> i = headSet.descendingIterator();
            while (i.hasNext()) {
                Timed next = (Timed)i.next();
                if (fixAcceptancePredicate != null && !fixAcceptancePredicate.isAcceptFix(next)) continue;
                Timed timed = next;
                return (FixType)timed;
            }
            return null;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public FixType getLastFixBefore(TimePoint timePoint) {
        this.lockForRead();
        try {
            Timed timed = (Timed)this.getInternalFixes().lower(this.getDummyFix(timePoint));
            return (FixType)timed;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public FixType getLastRawFixAtOrBefore(TimePoint timePoint) {
        this.lockForRead();
        try {
            Timed timed = (Timed)this.getInternalRawFixes().floor(this.getDummyFix(timePoint));
            return (FixType)timed;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public FixType getFirstRawFixAtOrAfter(TimePoint timePoint) {
        this.lockForRead();
        try {
            Timed timed = (Timed)this.getInternalRawFixes().ceiling(this.getDummyFix(timePoint));
            return (FixType)timed;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public FixType getFirstFixAtOrAfter(TimePoint timePoint) {
        return this.getFirstFixAtOrAfter(timePoint, null);
    }

    private FixType getFirstFixAtOrAfter(TimePoint timePoint, FixAcceptancePredicate<FixType> fixAcceptancePredicate) {
        this.lockForRead();
        try {
            NavigableSet<FixType> tailSet = this.getInternalFixes().tailSet(this.getDummyFix(timePoint), true);
            for (Timed next : tailSet) {
                if (fixAcceptancePredicate != null && !fixAcceptancePredicate.isAcceptFix(next)) continue;
                Timed timed = next;
                return (FixType)timed;
            }
            return null;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public FixType getLastRawFixBefore(TimePoint timePoint) {
        this.lockForRead();
        try {
            Timed timed = (Timed)this.getInternalRawFixes().lower(this.getDummyFix(timePoint));
            return (FixType)timed;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public FixType getFirstFixAfter(TimePoint timePoint) {
        this.lockForRead();
        try {
            Timed timed = (Timed)this.getInternalFixes().higher(this.getDummyFix(timePoint));
            return (FixType)timed;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public FixType getFirstRawFixAfter(TimePoint timePoint) {
        this.lockForRead();
        try {
            Timed timed = (Timed)this.getInternalRawFixes().higher(this.getDummyFix(timePoint));
            return (FixType)timed;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public FixType getFirstRawFix() {
        this.lockForRead();
        try {
            if (this.getInternalFixes().isEmpty()) {
                return null;
            }
            Timed timed = (Timed)this.getInternalFixes().first();
            return (FixType)timed;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public FixType getLastRawFix() {
        this.lockForRead();
        try {
            if (this.getInternalRawFixes().isEmpty()) {
                return null;
            }
            Timed timed = (Timed)this.getInternalRawFixes().last();
            return (FixType)timed;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    private Util.Pair<FixType, FixType> getSurroundingFixes(TimePoint timePoint, FixAcceptancePredicate<FixType> fixAcceptancePredicate) {
        FixType left = this.getLastFixAtOrBefore(timePoint, fixAcceptancePredicate);
        FixType right = this.getFirstFixAtOrAfter(timePoint, fixAcceptancePredicate);
        Util.Pair result = new Util.Pair(left, right);
        return result;
    }

    private <V, T> T timeBasedAverage(TimePoint timePoint, ScalableValue<V, T> value1, TimePoint timePoint1, ScalableValue<V, T> value2, TimePoint timePoint2) {
        Object acc;
        if (timePoint1.equals(timePoint2)) {
            acc = value1.add(value2).divide(2.0);
        } else {
            long timeDiff1 = Math.abs(timePoint1.asMillis() - timePoint.asMillis());
            long timeDiff2 = Math.abs(timePoint2.asMillis() - timePoint.asMillis());
            acc = value1.multiply((double)timeDiff2).add(value2.multiply((double)timeDiff1)).divide((double)(timeDiff1 + timeDiff2));
        }
        return (T)acc;
    }

    @Override
    public <InternalType, ValueType> ValueType getInterpolatedValue(TimePoint timePoint, Function<FixType, ScalableValue<InternalType, ValueType>> converter) {
        return this.getInterpolatedValue(timePoint, converter, null);
    }

    protected <InternalType, ValueType> ValueType getInterpolatedValue(TimePoint timePoint, Function<FixType, ScalableValue<InternalType, ValueType>> converter, FixAcceptancePredicate<FixType> fixAcceptancePredicate) {
        Util.Pair<FixType, FixType> fixPair = this.getSurroundingFixes(timePoint, fixAcceptancePredicate);
        Object result = fixPair.getA() == null ? (fixPair.getB() == null ? null : converter.apply((Timed)fixPair.getB()).divide(1.0)) : (fixPair.getB() == null || fixPair.getA() == fixPair.getB() ? converter.apply((Timed)fixPair.getA()).divide(1.0) : this.timeBasedAverage(timePoint, converter.apply((Timed)fixPair.getA()), ((Timed)fixPair.getA()).getTimePoint(), converter.apply((Timed)fixPair.getB()), ((Timed)fixPair.getB()).getTimePoint()));
        return (ValueType)result;
    }

    @Override
    public Iterator<FixType> getFixesIterator(TimePoint startingAt, boolean inclusive) {
        this.assertReadLock();
        return this.getTimeConstrainedFixesIterator(this.getInternalFixes(), startingAt, inclusive, null, false);
    }

    @Override
    public Iterator<FixType> getFixesIterator(TimePoint startingAt, boolean startingAtInclusive, TimePoint endingAt, boolean endingAtInclusive) {
        this.assertReadLock();
        return this.getTimeConstrainedFixesIterator(this.getInternalFixes(), startingAt, startingAtInclusive, endingAt, endingAtInclusive);
    }

    @Override
    public Iterator<FixType> getFixesDescendingIterator(TimePoint startingAt, boolean inclusive) {
        this.assertReadLock();
        Iterator<FixType> result = this.getInternalFixes().headSet(this.getDummyFix(startingAt), inclusive).descendingIterator();
        return result;
    }

    protected FixType getDummyFix(TimePoint timePoint) {
        DummyTimed result = new DummyTimed(timePoint);
        return (FixType)result;
    }

    @Override
    public Iterator<FixType> getRawFixesIterator(TimePoint startingAt, boolean inclusive) {
        this.assertReadLock();
        return this.getTimeConstrainedFixesIterator(this.getInternalRawFixes(), startingAt, inclusive, null, false);
    }

    private Iterator<FixType> getTimeConstrainedFixesIterator(NavigableSet<FixType> set, TimePoint startingAt, boolean startingAtInclusive, TimePoint endingAt, boolean endingAtInclusive) {
        this.assertReadLock();
        if (startingAt != null && endingAt != null) {
            set = set.subSet(this.getDummyFix(startingAt), startingAtInclusive, this.getDummyFix(endingAt), endingAtInclusive);
        } else if (endingAt != null) {
            set = set.headSet(this.getDummyFix(endingAt), endingAtInclusive);
        } else if (startingAt != null) {
            set = set.tailSet(this.getDummyFix(startingAt), startingAtInclusive);
        }
        Iterator<FixType> result = set.iterator();
        return result;
    }

    @Override
    public Iterator<FixType> getRawFixesIterator(TimePoint startingAt, boolean startingAtInclusive, TimePoint endingAt, boolean endingAtInclusive) {
        this.assertReadLock();
        return this.getTimeConstrainedFixesIterator(this.getInternalRawFixes(), startingAt, startingAtInclusive, endingAt, endingAtInclusive);
    }

    @Override
    public Iterator<FixType> getRawFixesDescendingIterator(TimePoint startingAt, boolean inclusive) {
        this.assertReadLock();
        Iterator<FixType> result = this.getInternalRawFixes().headSet(this.getDummyFix(startingAt), inclusive).descendingIterator();
        return result;
    }

    protected boolean add(FixType fix) {
        return this.add(fix, false);
    }

    protected boolean add(FixType fix, boolean replace) {
        this.lockForWrite();
        try {
            AddResult addResult = this.addWithoutLocking(fix, replace);
            boolean bl = addResult == AddResult.ADDED || addResult == AddResult.REPLACED;
            return bl;
        }
        finally {
            this.unlockAfterWrite();
        }
    }

    protected AddResult addWithoutLocking(FixType fix, boolean replace) {
        AddResult result;
        boolean added = this.getInternalRawFixes().add(fix);
        if (!added && replace) {
            this.getInternalRawFixes().remove(fix);
            result = this.getInternalRawFixes().add(fix) ? AddResult.REPLACED : AddResult.NOT_ADDED;
        } else {
            result = added ? AddResult.ADDED : AddResult.NOT_ADDED;
        }
        return result;
    }

    @Override
    public Duration getAverageIntervalBetweenFixes() {
        this.lockForRead();
        try {
            int size = this.getRawFixes().size();
            Duration result = size > 1 ? ((Timed)this.getRawFixes().first()).getTimePoint().until(((Timed)this.getRawFixes().last()).getTimePoint()).divide((long)(size - 1)) : null;
            Duration duration = result;
            return duration;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public Duration getAverageIntervalBetweenRawFixes() {
        this.lockForRead();
        try {
            int size = this.getRawFixes().size();
            Duration result = size > 1 ? ((Timed)this.getRawFixes().first()).getTimePoint().until(((Timed)this.getRawFixes().last()).getTimePoint()).divide((long)(size - 1)) : null;
            Duration duration = result;
            return duration;
        }
        finally {
            this.unlockAfterRead();
        }
    }

    @Override
    public <T> T getValueSum(TimePoint from, TimePoint to, T nullElement, Track.Adder<T> adder, TimeRangeCache<T> cache, Track.TimeRangeValueCalculator<T> valueCalculator) {
        return this.getValueSumRecursively(from, to, 0, nullElement, adder, cache, valueCalculator);
    }

    private <T> T getValueSumRecursively(TimePoint from, TimePoint to, int recursionDepth, T nullElement, Track.Adder<T> adder, TimeRangeCache<T> cache, Track.TimeRangeValueCalculator<T> valueCalculator) {
        Object result;
        if (!from.before(to)) {
            result = nullElement;
        } else {
            boolean perfectCacheHit = false;
            this.lockForRead();
            try {
                Util.Pair<TimePoint, Util.Pair<TimePoint, T>> bestCacheEntry = cache.getEarliestFromAndResultAtOrAfterFrom(from, to);
                if (bestCacheEntry != null) {
                    perfectCacheHit = true;
                    T valueFromFromToBeginningOfCacheEntry = nullElement;
                    T valueFromEndOfCacheEntryToTo = nullElement;
                    if (!((TimePoint)((Util.Pair)bestCacheEntry.getB()).getA()).equals(from)) {
                        assert (((TimePoint)((Util.Pair)bestCacheEntry.getB()).getA()).after(from));
                        perfectCacheHit = false;
                        valueFromFromToBeginningOfCacheEntry = this.getValueSumRecursively(from, (TimePoint)((Util.Pair)bestCacheEntry.getB()).getA(), recursionDepth + 1, nullElement, adder, cache, valueCalculator);
                    }
                    if (!((TimePoint)bestCacheEntry.getA()).equals(to)) {
                        assert (((TimePoint)bestCacheEntry.getA()).before(to));
                        perfectCacheHit = false;
                        valueFromEndOfCacheEntryToTo = this.getValueSumRecursively((TimePoint)bestCacheEntry.getA(), to, recursionDepth + 1, nullElement, adder, cache, valueCalculator);
                    }
                    result = valueFromEndOfCacheEntryToTo == null || ((Util.Pair)bestCacheEntry.getB()).getB() == null ? null : adder.add(adder.add(valueFromFromToBeginningOfCacheEntry, ((Util.Pair)bestCacheEntry.getB()).getB()), valueFromEndOfCacheEntryToTo);
                } else {
                    result = from.compareTo((Object)to) < 0 ? valueCalculator.calculate(from, to) : nullElement;
                }
                if (!perfectCacheHit && recursionDepth == 0) {
                    cache.cache(from, to, result);
                }
            }
            finally {
                this.unlockAfterRead();
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.fixes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.fixes.isEmpty();
    }

    protected static class DummyTimed
    implements Timed {
        private static final long serialVersionUID = 6047311973718918856L;
        private final TimePoint timePoint;

        public DummyTimed(TimePoint timePoint) {
            this.timePoint = timePoint;
        }

        public TimePoint getTimePoint() {
            return this.timePoint;
        }

        public String toString() {
            return this.timePoint.toString();
        }
    }
}

