/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.racegroup.impl;

import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.racegroup.RaceRow;
import com.sap.sailing.domain.base.racegroup.SeriesWithRows;
import java.util.ArrayList;

public class SeriesWithRowsImpl
implements SeriesWithRows {
    private static final long serialVersionUID = 8825402393444809944L;
    private String name;
    private Iterable<RaceRow> raceRows;
    private boolean isMedal;
    private boolean isFleetsCanRunInParallel;

    public SeriesWithRowsImpl(String name, boolean isMedal, boolean isFleetsCanRunInParallel, Iterable<RaceRow> raceRows) {
        this.name = name;
        this.raceRows = raceRows;
        this.isMedal = isMedal;
        this.isFleetsCanRunInParallel = isFleetsCanRunInParallel;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isMedal() {
        return this.isMedal;
    }

    @Override
    public Iterable<RaceRow> getRaceRows() {
        return this.raceRows;
    }

    @Override
    public RaceRow getRaceRow(Fleet fleet) {
        for (RaceRow row : this.getRaceRows()) {
            if (row.getFleet() != fleet) continue;
            return row;
        }
        return null;
    }

    @Override
    public Iterable<? extends Fleet> getFleets() {
        ArrayList<Fleet> fleets = new ArrayList<Fleet>();
        for (RaceRow row : this.raceRows) {
            fleets.add(row.getFleet());
        }
        return fleets;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public boolean isFleetsCanRunInParallel() {
        return this.isFleetsCanRunInParallel;
    }

    public String toString() {
        return "SeriesWithRowsImpl [name=" + this.name + ", raceRows=" + this.raceRows + ", isMedal=" + this.isMedal + ", isFleetsCanRunInParallel=" + this.isFleetsCanRunInParallel + "]";
    }
}

