/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.racegroup.impl;

import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.racegroup.CurrentRaceFilter;
import com.sap.sailing.domain.base.racegroup.FilterableRace;
import com.sap.sailing.domain.base.racegroup.RaceCell;
import com.sap.sailing.domain.base.racegroup.RaceGroup;
import com.sap.sailing.domain.base.racegroup.RaceGroupSeries;
import com.sap.sailing.domain.base.racegroup.RaceGroupSeriesFleetRaceColumn;
import com.sap.sailing.domain.base.racegroup.RaceRow;
import com.sap.sailing.domain.base.racegroup.SeriesWithRows;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sse.common.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CurrentRaceFilterImpl<T extends FilterableRace>
implements CurrentRaceFilter<T> {
    private final Iterable<T> allRaces;
    private final Map<RaceGroupSeriesFleetRaceColumn, T> racesByRaceGroupSeriesFleet;
    private final Map<RaceGroupSeries, Set<T>> racesByRaceGroupSeries;

    public CurrentRaceFilterImpl(Iterable<T> allRaces) {
        HashSet<T> copyOfAllRaces = new HashSet<T>();
        Util.addAll(allRaces, copyOfAllRaces);
        this.allRaces = copyOfAllRaces;
        this.racesByRaceGroupSeriesFleet = new HashMap<RaceGroupSeriesFleetRaceColumn, T>();
        this.racesByRaceGroupSeries = new HashMap<RaceGroupSeries, Set<T>>();
        for (FilterableRace race : allRaces) {
            this.racesByRaceGroupSeriesFleet.put(new RaceGroupSeriesFleetRaceColumn(race), race);
            RaceGroupSeries key = new RaceGroupSeries(race);
            Set<T> racesForRaceGroupSeries = this.racesByRaceGroupSeries.get(key);
            if (racesForRaceGroupSeries == null) {
                racesForRaceGroupSeries = new HashSet<T>();
                this.racesByRaceGroupSeries.put(key, racesForRaceGroupSeries);
            }
            racesForRaceGroupSeries.add(race);
        }
    }

    @Override
    public Set<T> getCurrentRaces() {
        HashSet<FilterableRace> filteredRaces = new HashSet<FilterableRace>();
        for (FilterableRace race : this.allRaces) {
            if (race.getStatus().getOrderNumber() > RaceLogRaceStatus.FINISHING.getOrderNumber()) continue;
            if (race.getStatus().getOrderNumber() >= RaceLogRaceStatus.SCHEDULED.getOrderNumber()) {
                filteredRaces.add(race);
                continue;
            }
            assert (race.getStatus().getOrderNumber() < RaceLogRaceStatus.SCHEDULED.getOrderNumber());
            boolean hasNoPredecessor = this.hasNoPredecessor(race);
            if (this.raceScheduledInLaterSeries(race) || !hasNoPredecessor && !this.hasImmediatePredecessorThatIsAtLeastScheduled(race) && !this.isFirstInAlreadyScheduledSeries(race)) continue;
            filteredRaces.add(race);
        }
        return filteredRaces;
    }

    private boolean isFirstInAlreadyScheduledSeries(T race) {
        boolean result;
        if (race.getZeroBasedIndexInFleet() == 0 && (race.getSeries().isFleetsCanRunInParallel() || Util.indexOf(race.getSeries().getFleets(), (Object)race.getFleet()) == 0)) {
            boolean foundRaceAtLeastScheduledInSameSeries = false;
            for (FilterableRace raceInSameSeries : this.racesByRaceGroupSeries.get(new RaceGroupSeries((FilterableRace)race))) {
                if (raceInSameSeries.getStatus().getOrderNumber() < RaceLogRaceStatus.SCHEDULED.getOrderNumber()) continue;
                foundRaceAtLeastScheduledInSameSeries = true;
                break;
            }
            result = foundRaceAtLeastScheduledInSameSeries;
        } else {
            result = false;
        }
        return result;
    }

    private boolean raceScheduledInLaterSeries(T race) {
        for (Map.Entry<RaceGroupSeries, Set<T>> rgs : this.racesByRaceGroupSeries.entrySet()) {
            if (rgs.getKey().getRaceGroup() != race.getRaceGroup() || rgs.getKey().getSeriesOrder() <= race.getZeroBasedSeriesIndex()) continue;
            for (FilterableRace r : rgs.getValue()) {
                if (r.getStatus().getOrderNumber() < RaceLogRaceStatus.SCHEDULED.getOrderNumber()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNoPredecessor(FilterableRace race) {
        return race.getZeroBasedIndexInFleet() == 0 && this.isInFirstNonEmptySeries(race) && (race.getSeries().isFleetsCanRunInParallel() || Util.indexOf(race.getSeries().getFleets(), (Object)race.getFleet()) == 0);
    }

    private boolean isInFirstNonEmptySeries(FilterableRace race) {
        int seriesIndex = race.getZeroBasedSeriesIndex() - 1;
        while (seriesIndex >= 0) {
            SeriesWithRows seriesWithRows = (SeriesWithRows)Util.get(race.getRaceGroup().getSeries(), (int)seriesIndex);
            if (!this.isEmptySeries(seriesWithRows)) {
                return false;
            }
            --seriesIndex;
        }
        return true;
    }

    private boolean isEmptySeries(SeriesWithRows seriesWithRows) {
        Iterable<RaceRow> raceRows = seriesWithRows.getRaceRows();
        return !raceRows.iterator().hasNext() || !raceRows.iterator().next().getCells().iterator().hasNext();
    }

    private boolean hasImmediatePredecessorThatIsAtLeastScheduled(FilterableRace race) {
        HashSet<FilterableRace> immediatePredecessors = new HashSet<FilterableRace>();
        RaceGroup raceGroup = race.getRaceGroup();
        if (race.getSeries().isFleetsCanRunInParallel()) {
            if (race.getZeroBasedIndexInFleet() == 0) {
                Util.addAll(this.getLastRacesFromImmediatelyPrecedingSeries(race, raceGroup), immediatePredecessors);
            } else {
                RaceRow raceRow = ((SeriesWithRows)Util.get(raceGroup.getSeries(), (int)race.getZeroBasedSeriesIndex())).getRaceRow(race.getFleet());
                RaceCell previousCellInFleet = (RaceCell)Util.get(raceRow.getCells(), (int)(race.getZeroBasedIndexInFleet() - 1));
                immediatePredecessors.add((FilterableRace)this.racesByRaceGroupSeriesFleet.get(new RaceGroupSeriesFleetRaceColumn(raceGroup, race.getSeries(), race.getFleet(), previousCellInFleet.getName())));
            }
        } else {
            int zeroBasedIndexOfFleetInSeries = Util.indexOf(race.getSeries().getFleets(), (Object)race.getFleet());
            if (race.getZeroBasedIndexInFleet() == 0 && zeroBasedIndexOfFleetInSeries == 0) {
                Util.addAll(this.getLastRacesFromImmediatelyPrecedingSeries(race, raceGroup), immediatePredecessors);
            } else {
                int zeroBasedIndexOfImmediatelyPrecedingRaceInFleet;
                Fleet fleetOfImmediatelyPrecedingRace;
                if (zeroBasedIndexOfFleetInSeries == 0) {
                    fleetOfImmediatelyPrecedingRace = (Fleet)Util.last(race.getSeries().getFleets());
                    zeroBasedIndexOfImmediatelyPrecedingRaceInFleet = race.getZeroBasedIndexInFleet() - 1;
                } else {
                    fleetOfImmediatelyPrecedingRace = (Fleet)Util.get(race.getSeries().getFleets(), (int)(zeroBasedIndexOfFleetInSeries - 1));
                    zeroBasedIndexOfImmediatelyPrecedingRaceInFleet = race.getZeroBasedIndexInFleet();
                }
                RaceGroupSeriesFleetRaceColumn identifierOfImmediatelyPrecedingRace = new RaceGroupSeriesFleetRaceColumn(raceGroup, race.getSeries(), fleetOfImmediatelyPrecedingRace, ((RaceCell)Util.get(((SeriesWithRows)Util.get(raceGroup.getSeries(), (int)race.getZeroBasedSeriesIndex())).getRaceRow(fleetOfImmediatelyPrecedingRace).getCells(), (int)zeroBasedIndexOfImmediatelyPrecedingRaceInFleet)).getName());
                immediatePredecessors.add((FilterableRace)this.racesByRaceGroupSeriesFleet.get(identifierOfImmediatelyPrecedingRace));
            }
        }
        Iterator i = immediatePredecessors.iterator();
        boolean result = false;
        while (!result && i.hasNext()) {
            RaceLogRaceStatus nextStatus = ((FilterableRace)i.next()).getStatus();
            boolean bl = result = nextStatus.getOrderNumber() >= RaceLogRaceStatus.SCHEDULED.getOrderNumber();
        }
        return result;
    }

    private Iterable<T> getLastRacesFromImmediatelyPrecedingSeries(FilterableRace race, RaceGroup raceGroup) {
        HashSet<T> lastRacesInImmediatelyPrecedingSeries = new HashSet<T>();
        List immediatelyPrecedingSerieses = Util.asList(raceGroup.getSeries()).subList(0, race.getZeroBasedSeriesIndex());
        SeriesWithRows lastPrecedingNonEmptySeries = (SeriesWithRows)Util.last((Iterable)Util.filter(immediatelyPrecedingSerieses, series -> !this.isEmptySeries((SeriesWithRows)series)));
        if (lastPrecedingNonEmptySeries.isFleetsCanRunInParallel()) {
            for (RaceRow rowInImmediatelyPrecedingSeries : lastPrecedingNonEmptySeries.getRaceRows()) {
                T lastRaceInRow = this.getLastRaceInRow(raceGroup, lastPrecedingNonEmptySeries, rowInImmediatelyPrecedingSeries);
                lastRacesInImmediatelyPrecedingSeries.add(lastRaceInRow);
            }
        } else {
            RaceRow lastRowInImmediatelyPrecedingSeries = (RaceRow)Util.last(lastPrecedingNonEmptySeries.getRaceRows());
            lastRacesInImmediatelyPrecedingSeries.add(this.getLastRaceInRow(raceGroup, lastPrecedingNonEmptySeries, lastRowInImmediatelyPrecedingSeries));
        }
        return lastRacesInImmediatelyPrecedingSeries;
    }

    private T getLastRaceInRow(RaceGroup raceGroup, SeriesWithRows immediatelyPrecedingSeries, RaceRow rowInImmediatelyPrecedingSeries) {
        RaceCell lastCell = (RaceCell)Util.last(rowInImmediatelyPrecedingSeries.getCells());
        RaceGroupSeriesFleetRaceColumn identifierOfALastRaceInImmediatelyPrecedingSeries = new RaceGroupSeriesFleetRaceColumn(raceGroup, immediatelyPrecedingSeries, rowInImmediatelyPrecedingSeries.getFleet(), lastCell.getName());
        FilterableRace lastRaceInRow = (FilterableRace)this.racesByRaceGroupSeriesFleet.get(identifierOfALastRaceInImmediatelyPrecedingSeries);
        return (T)lastRaceInRow;
    }
}

