/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sse.common.Bearing;
import java.util.UUID;

public class WaypointImpl
implements Waypoint {
    private static final long serialVersionUID = 1600863368078653897L;
    private final ControlPoint controlPoint;
    private final UUID id;
    private final PassingInstruction passingInstructions;
    private final Bearing fixedBearing;

    public WaypointImpl(ControlPoint controlPoint) {
        this(controlPoint, PassingInstruction.None, null);
    }

    public WaypointImpl(ControlPoint controlPoint, PassingInstruction passingInstructions) {
        this(controlPoint, passingInstructions, null);
    }

    public WaypointImpl(ControlPoint controlPoint, PassingInstruction passingInstructions, Bearing fixedBearing) {
        if (passingInstructions == null) {
            throw new IllegalArgumentException("PassingInstructions cannot be null");
        }
        this.controlPoint = controlPoint;
        this.passingInstructions = passingInstructions;
        this.fixedBearing = fixedBearing;
        this.id = UUID.randomUUID();
    }

    @Override
    public ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public String getName() {
        return this.getControlPoint().getName();
    }

    public String toString() {
        return String.valueOf(this.getName() == null ? "" : this.getName()) + " (" + this.getPassingInstructions() + ")";
    }

    @Override
    public Iterable<Mark> getMarks() {
        return this.getControlPoint().getMarks();
    }

    public UUID getId() {
        return this.id;
    }

    public Waypoint resolve(SharedDomainFactory<?> domainFactory) {
        return domainFactory.getExistingWaypointByIdOrCache(this);
    }

    @Override
    public PassingInstruction getPassingInstructions() {
        return this.passingInstructions;
    }

    @Override
    public Bearing getFixedBearing() {
        return this.fixedBearing;
    }
}

