/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.impl.BoatImpl;
import com.sap.sailing.domain.base.impl.CompetitorImpl;
import com.sap.sailing.domain.base.impl.CompetitorWithBoatImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTOImpl;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorWithBoatDTOImpl;
import com.sap.sse.common.Color;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.Duration;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransientCompetitorAndBoatStoreImpl
implements CompetitorAndBoatStore,
Serializable {
    private static final Logger logger = Logger.getLogger(TransientCompetitorAndBoatStoreImpl.class.getName());
    private static final long serialVersionUID = -4198298775476586931L;
    private final Map<Serializable, DynamicCompetitor> competitorCache;
    private final Map<String, DynamicCompetitor> competitorsByIdAsString;
    private transient Set<CompetitorAndBoatStore.CompetitorUpdateListener> competitorUpdateListeners;
    private final Map<Serializable, DynamicBoat> boatCache;
    private final Map<String, DynamicBoat> boatsByIdAsString;
    private transient Set<CompetitorAndBoatStore.BoatUpdateListener> boatUpdateListeners;
    private final Set<Competitor> competitorsToUpdateDuringGetOrCreate;
    private transient WeakHashMap<Competitor, CompetitorDTO> weakCompetitorDTOCache;
    private final Set<DynamicBoat> boatsToUpdateDuringGetOrCreate;
    private transient WeakHashMap<Boat, BoatDTO> weakBoatDTOCache;
    private final NamedReentrantReadWriteLock lock = new NamedReentrantReadWriteLock("CompetitorStore", false);

    public TransientCompetitorAndBoatStoreImpl() {
        this.competitorCache = new HashMap<Serializable, DynamicCompetitor>();
        this.competitorsByIdAsString = new HashMap<String, DynamicCompetitor>();
        this.competitorsToUpdateDuringGetOrCreate = new HashSet<Competitor>();
        this.weakCompetitorDTOCache = new WeakHashMap();
        this.competitorUpdateListeners = Collections.synchronizedSet(new HashSet());
        this.boatCache = new HashMap<Serializable, DynamicBoat>();
        this.boatsByIdAsString = new HashMap<String, DynamicBoat>();
        this.boatsToUpdateDuringGetOrCreate = new HashSet<DynamicBoat>();
        this.weakBoatDTOCache = new WeakHashMap();
        this.boatUpdateListeners = Collections.synchronizedSet(new HashSet());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.weakCompetitorDTOCache = new WeakHashMap();
        this.competitorUpdateListeners = Collections.synchronizedSet(new HashSet());
        this.weakBoatDTOCache = new WeakHashMap();
        this.boatUpdateListeners = Collections.synchronizedSet(new HashSet());
    }

    @Override
    public void clear() {
        this.clearCompetitors();
        this.clearBoats();
    }

    @Override
    public void addCompetitorUpdateListener(CompetitorAndBoatStore.CompetitorUpdateListener listener) {
        this.competitorUpdateListeners.add(listener);
    }

    @Override
    public void removeCompetitorUpdateListener(CompetitorAndBoatStore.CompetitorUpdateListener listener) {
        this.competitorUpdateListeners.remove(listener);
    }

    private DynamicCompetitor createCompetitor(Serializable id, String name, String shortName, Color displayColor, String email, URI flagImage, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag, boolean storePersistently) {
        CompetitorImpl result = new CompetitorImpl(id, name, shortName, displayColor, email, flagImage, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag);
        this.addNewCompetitor(result, storePersistently);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Created competitor " + name + " with ID " + id, new Exception("Here is where it happened"));
        }
        return result;
    }

    @Override
    public synchronized Competitor migrateToCompetitorWithoutBoat(CompetitorWithBoat competitorWithBoat) {
        assert (competitorWithBoat.hasBoat());
        this.removeBoat(competitorWithBoat.getBoat());
        ((DynamicCompetitorWithBoat)competitorWithBoat).clearBoat();
        return competitorWithBoat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewCompetitor(DynamicCompetitor competitor, boolean storePersistently) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            Competitor existingCompetitorWithEqualId = this.competitorCache.put(competitor.getId(), competitor);
            if (existingCompetitorWithEqualId != null && existingCompetitorWithEqualId != competitor) {
                String msg = "Replaced competitor " + existingCompetitorWithEqualId + " with ID " + existingCompetitorWithEqualId.getId() + " of type " + existingCompetitorWithEqualId.getClass().getName() + " by another object " + competitor + " of type " + competitor.getClass().getName() + " that has an equal ID. This is a pretty bad thing because we expect each competitor to be represented by exactly one Java object.";
                logger.severe(msg);
                throw new IllegalArgumentException(msg);
            }
            this.competitorsByIdAsString.put(competitor.getId().toString(), competitor);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
        Set<CompetitorAndBoatStore.CompetitorUpdateListener> set = this.competitorUpdateListeners;
        synchronized (set) {
            for (CompetitorAndBoatStore.CompetitorUpdateListener listener : this.competitorUpdateListeners) {
                listener.competitorCreated(competitor);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DynamicCompetitor getOrCreateCompetitor(Serializable competitorId, String name, String shortName, Color displayColor, String email, URI flagImage, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag, boolean storePersistently) {
        DynamicCompetitor result = this.getExistingCompetitorById(competitorId);
        if (result == null) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
            try {
                result = this.getExistingCompetitorById(competitorId);
                if (result != null) return result;
                result = this.createCompetitor(competitorId, name, shortName, displayColor, email, flagImage, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, storePersistently);
                return result;
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
            }
        } else {
            if (!this.isCompetitorToUpdateDuringGetOrCreate(result)) return result;
            this.updateCompetitor(result.getId().toString(), name, shortName, displayColor, email, team.getNationality(), team.getImage(), flagImage, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, storePersistently);
            this.competitorNoLongerToUpdateDuringGetOrCreate(result);
        }
        return result;
    }

    private void competitorNoLongerToUpdateDuringGetOrCreate(Competitor competitor) {
        this.competitorsToUpdateDuringGetOrCreate.remove(competitor);
    }

    @Override
    public boolean isCompetitorToUpdateDuringGetOrCreate(Competitor competitor) {
        return this.competitorsToUpdateDuringGetOrCreate.contains(competitor);
    }

    @Override
    public DynamicCompetitor getExistingCompetitorById(Serializable competitorId) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            DynamicCompetitor competitor;
            DynamicCompetitor dynamicCompetitor = competitor = this.competitorCache.get(competitorId);
            return dynamicCompetitor;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public DynamicCompetitor getExistingCompetitorByIdAsString(String competitorIdAsString) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            DynamicCompetitor dynamicCompetitor = this.competitorsByIdAsString.get(competitorIdAsString);
            return dynamicCompetitor;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public DynamicCompetitorWithBoat getExistingCompetitorWithBoatById(Serializable competitorId) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            DynamicCompetitor competitor = this.competitorCache.get(competitorId);
            DynamicCompetitorWithBoat result = competitor != null && competitor.hasBoat() ? (DynamicCompetitorWithBoat)competitor : null;
            DynamicCompetitorWithBoat dynamicCompetitorWithBoat = result;
            return dynamicCompetitorWithBoat;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public CompetitorWithBoat getExistingCompetitorWithBoatByIdAsString(String competitorIdAsString) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            Competitor competitor = this.competitorsByIdAsString.get(competitorIdAsString);
            if (competitor != null && competitor.hasBoat()) {
                CompetitorWithBoat competitorWithBoat = (CompetitorWithBoat)competitor;
                return competitorWithBoat;
            }
            return null;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public int getCompetitorsCount() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            int n = this.competitorCache.size();
            return n;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public void clearCompetitors() {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            this.competitorCache.clear();
            this.competitorsByIdAsString.clear();
            this.competitorsToUpdateDuringGetOrCreate.clear();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Clearing competitor store " + this, new Exception("here is where it happened"));
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public Iterable<Competitor> getAllCompetitors() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            ArrayList<Competitor> arrayList = new ArrayList<Competitor>(this.competitorCache.values());
            return arrayList;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public Iterable<CompetitorWithBoat> getCompetitorsWithBoat() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            ArrayList<CompetitorWithBoat> competitors = new ArrayList<CompetitorWithBoat>();
            for (Competitor competitor : this.competitorCache.values()) {
                if (!competitor.hasBoat()) continue;
                competitors.add((CompetitorWithBoat)competitor);
            }
            ArrayList<CompetitorWithBoat> arrayList = competitors;
            return arrayList;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public Iterable<Competitor> getCompetitorsWithoutBoat() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            ArrayList<Competitor> competitors = new ArrayList<Competitor>();
            for (Competitor competitor : this.competitorCache.values()) {
                if (competitor.hasBoat()) continue;
                competitors.add(competitor);
            }
            ArrayList<Competitor> arrayList = competitors;
            return arrayList;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    protected void removeCompetitor(Competitor competitor) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            logger.fine("removing competitor " + competitor + " from competitor store " + this);
            this.competitorCache.remove(competitor.getId());
            this.competitorsByIdAsString.remove(competitor.getId().toString());
            this.weakCompetitorDTOCache.remove(competitor);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Competitor updateCompetitor(String idAsString, String newName, String newShortName, Color newDisplayColor, String newEmail, Nationality newNationality, URI newTeamImageUri, URI newFlagImageUri, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String newSearchTag, boolean storePersistently) {
        DynamicCompetitor competitor = this.getExistingCompetitorByIdAsString(idAsString);
        if (competitor != null) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
            try {
                competitor.setName(newName);
                competitor.setShortName(newShortName);
                competitor.setColor(newDisplayColor);
                competitor.setEmail(newEmail);
                competitor.setFlagImage(newFlagImageUri);
                competitor.getTeam().setNationality(newNationality);
                competitor.getTeam().setImage(newTeamImageUri);
                competitor.setTimeOnTimeFactor(timeOnTimeFactor);
                competitor.setTimeOnDistanceAllowancePerNauticalMile(timeOnDistanceAllowancePerNauticalMile);
                competitor.setSearchTag(newSearchTag);
                this.weakCompetitorDTOCache.remove(competitor);
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
            }
        }
        Set<CompetitorAndBoatStore.CompetitorUpdateListener> set = this.competitorUpdateListeners;
        synchronized (set) {
            for (CompetitorAndBoatStore.CompetitorUpdateListener listener : this.competitorUpdateListeners) {
                listener.competitorUpdated(competitor);
            }
        }
        return competitor;
    }

    @Override
    public CompetitorDTO convertToCompetitorDTO(Competitor c) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        boolean needToUnlockReadLock = true;
        try {
            CompetitorDTO competitorDTO = this.weakCompetitorDTOCache.get(c);
            if (competitorDTO == null) {
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
                needToUnlockReadLock = false;
                LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
                competitorDTO = this.weakCompetitorDTOCache.get(c);
                if (competitorDTO == null) {
                    Nationality nationality = c.getTeam().getNationality();
                    CountryCode countryCode = nationality == null ? null : nationality.getCountryCode();
                    competitorDTO = new CompetitorDTOImpl(c.getName(), c.getShortName(), c.getColor(), c.getEmail(), countryCode == null ? "" : countryCode.getTwoLetterISOCode(), countryCode == null ? "" : countryCode.getThreeLetterIOCCode(), countryCode == null ? "" : countryCode.getName(), c.getId().toString(), c.getTeam().getImage() == null ? null : c.getTeam().getImage().toString(), c.getFlagImage() == null ? null : c.getFlagImage().toString(), c.getTimeOnTimeFactor(), c.getTimeOnDistanceAllowancePerNauticalMile(), c.getSearchTag());
                    this.weakCompetitorDTOCache.put(c, competitorDTO);
                }
            }
            CompetitorDTO competitorDTO2 = competitorDTO;
            return competitorDTO2;
        }
        finally {
            if (needToUnlockReadLock) {
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
            } else {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
            }
        }
    }

    @Override
    public void allowCompetitorResetToDefaults(Competitor competitor) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            this.competitorsToUpdateDuringGetOrCreate.add(competitor);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public void addNewCompetitors(Iterable<DynamicCompetitor> competitors) {
        for (DynamicCompetitor competitor : competitors) {
            this.addNewCompetitor(competitor, true);
        }
    }

    @Override
    public void addNewCompetitorsWithBoat(Iterable<DynamicCompetitorWithBoat> competitors) {
        for (DynamicCompetitorWithBoat competitor : competitors) {
            this.addNewBoat(competitor.getBoat(), true);
            this.addNewCompetitor(competitor, true);
        }
    }

    private DynamicCompetitorWithBoat createCompetitorWithBoat(Serializable id, String name, String shortName, Color displayColor, String email, URI flagImage, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag, DynamicBoat boat, boolean storePersistently) {
        CompetitorWithBoatImpl competitor = new CompetitorWithBoatImpl(id, name, shortName, displayColor, email, flagImage, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, boat);
        this.addNewBoat(boat, storePersistently);
        this.addNewCompetitor(competitor, storePersistently);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Created competitor " + name + " with ID " + id, new Exception("Here is where it happened"));
        }
        return competitor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DynamicCompetitorWithBoat getOrCreateCompetitorWithBoat(Serializable competitorId, String name, String shortName, Color displayColor, String email, URI flagImage, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag, DynamicBoat boat, boolean storePersistently) {
        DynamicCompetitorWithBoat result = null;
        result = this.getExistingCompetitorWithBoatById(competitorId);
        if (result == null) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
            try {
                result = this.getExistingCompetitorWithBoatById(competitorId);
                if (result != null) return result;
                result = this.createCompetitorWithBoat(competitorId, name, shortName, displayColor, email, flagImage, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, boat, storePersistently);
                return result;
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
            }
        } else {
            if (!this.isCompetitorToUpdateDuringGetOrCreate(result)) return result;
            assert (result.getBoat() == boat);
            this.updateCompetitor(result.getId().toString(), name, shortName, displayColor, email, team.getNationality(), team.getImage(), flagImage, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, storePersistently);
            this.competitorNoLongerToUpdateDuringGetOrCreate(result);
        }
        return result;
    }

    @Override
    public void addBoatUpdateListener(CompetitorAndBoatStore.BoatUpdateListener listener) {
        this.boatUpdateListeners.add(listener);
    }

    @Override
    public void removeBoatUpdateListener(CompetitorAndBoatStore.BoatUpdateListener listener) {
        this.boatUpdateListeners.remove(listener);
    }

    private DynamicBoat createBoat(Serializable id, String name, BoatClass boatClass, String sailID, Color color, boolean storePersistently) {
        BoatImpl boat = new BoatImpl(id, name, boatClass, sailID, color);
        this.addNewBoat(boat, storePersistently);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Created boat " + name + " with ID " + id, new Exception("Here is where it happened"));
        }
        return boat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNewBoat(DynamicBoat boat, boolean storePersistently) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            Boat existingBoatWithEqualId = this.boatCache.put(boat.getId(), boat);
            if (existingBoatWithEqualId != null && existingBoatWithEqualId != boat) {
                logger.warning("Replaced existing boat " + existingBoatWithEqualId + " with ID " + existingBoatWithEqualId.getId() + " by another boat with equal ID: " + boat);
            }
            this.boatsByIdAsString.put(boat.getId().toString(), boat);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
        Set<CompetitorAndBoatStore.BoatUpdateListener> set = this.boatUpdateListeners;
        synchronized (set) {
            for (CompetitorAndBoatStore.BoatUpdateListener listener : this.boatUpdateListeners) {
                listener.boatCreated(boat);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DynamicBoat getOrCreateBoat(Serializable id, String name, BoatClass boatClass, String sailId, Color color, boolean storePersistently) {
        DynamicBoat result = this.getExistingBoatById(id);
        if (result == null) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
            try {
                result = this.getExistingBoatById(id);
                if (result != null) return result;
                result = this.createBoat(id, name, boatClass, sailId, color, storePersistently);
                return result;
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
            }
        } else {
            if (!this.isBoatToUpdateDuringGetOrCreate(result)) return result;
            this.updateBoat(result.getId().toString(), name, color, sailId);
            this.boatNoLongerToUpdateDuringGetOrCreate(result);
        }
        return result;
    }

    private void boatNoLongerToUpdateDuringGetOrCreate(Boat boat) {
        this.boatsToUpdateDuringGetOrCreate.remove(boat);
    }

    @Override
    public boolean isBoatToUpdateDuringGetOrCreate(Boat boat) {
        return this.boatsToUpdateDuringGetOrCreate.contains(boat);
    }

    @Override
    public DynamicBoat getExistingBoatById(Serializable boatId) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            DynamicBoat dynamicBoat = this.boatCache.get(boatId);
            return dynamicBoat;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public DynamicBoat getExistingBoatByIdAsString(String boatIdAsString) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            DynamicBoat dynamicBoat = this.boatsByIdAsString.get(boatIdAsString);
            return dynamicBoat;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public int getBoatsCount() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            int n = this.boatCache.size();
            return n;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public void clearBoats() {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            this.boatCache.clear();
            this.boatsByIdAsString.clear();
            this.boatsToUpdateDuringGetOrCreate.clear();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Clearing boat store " + this, new Exception("here is where it happened"));
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public Iterable<Boat> getBoats() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            ArrayList<Boat> arrayList = new ArrayList<Boat>(this.boatCache.values());
            return arrayList;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    public Iterable<DynamicBoat> getStandaloneBoats() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        try {
            HashSet<DynamicBoat> boats = new HashSet<DynamicBoat>(this.boatCache.values());
            HashSet<DynamicBoat> boatsEmbeddedInCompetitors = new HashSet<DynamicBoat>();
            for (Competitor competitor : this.competitorCache.values()) {
                if (!competitor.hasBoat()) continue;
                boatsEmbeddedInCompetitors.add(((DynamicCompetitorWithBoat)competitor).getBoat());
            }
            boats.removeAll(boatsEmbeddedInCompetitors);
            HashSet<DynamicBoat> hashSet = boats;
            return hashSet;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
        }
    }

    protected void removeBoat(Boat boat) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            logger.fine("Removing boat " + boat + " from boat store " + this);
            this.boatCache.remove(boat.getId());
            this.boatsByIdAsString.remove(boat.getId().toString());
            this.weakBoatDTOCache.remove(boat);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boat updateBoat(String idAsString, String newName, Color newColor, String newSailId) {
        DynamicBoat boat = this.getExistingBoatByIdAsString(idAsString);
        if (boat != null) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
            try {
                boat.setName(newName);
                boat.setSailId(newSailId);
                boat.setColor(newColor);
                this.weakBoatDTOCache.remove(boat);
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
            }
        }
        Set<CompetitorAndBoatStore.BoatUpdateListener> set = this.boatUpdateListeners;
        synchronized (set) {
            for (CompetitorAndBoatStore.BoatUpdateListener listener : this.boatUpdateListeners) {
                listener.boatUpdated(boat);
            }
        }
        return boat;
    }

    @Override
    public BoatDTO convertToBoatDTO(Boat b) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.lock);
        boolean needToUnlockReadLock = true;
        try {
            BoatDTO boatDTO = this.weakBoatDTOCache.get(b);
            if (boatDTO == null) {
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
                needToUnlockReadLock = false;
                LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
                boatDTO = this.weakBoatDTOCache.get(b);
                if (boatDTO == null) {
                    BoatClassDTO boatClassDTO = new BoatClassDTO(b.getBoatClass().getName(), b.getBoatClass().getHullLength(), b.getBoatClass().getHullBeam());
                    boatDTO = new BoatDTO(b.getId().toString(), b.getName(), boatClassDTO, b.getSailID(), b.getColor());
                    this.weakBoatDTOCache.put(b, boatDTO);
                }
            }
            BoatDTO boatDTO2 = boatDTO;
            return boatDTO2;
        }
        finally {
            if (needToUnlockReadLock) {
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.lock);
            } else {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
            }
        }
    }

    @Override
    public void allowBoatResetToDefaults(DynamicBoat boat) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            this.boatsToUpdateDuringGetOrCreate.add(boat);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public void addNewBoats(Iterable<DynamicBoat> boats) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.lock);
        try {
            for (DynamicBoat boat : boats) {
                this.boatCache.put(boat.getId(), boat);
                this.boatsByIdAsString.put(boat.getId().toString(), boat);
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.lock);
        }
    }

    @Override
    public CompetitorWithBoatDTO convertToCompetitorWithBoatDTO(CompetitorWithBoat competitor) {
        CompetitorDTO c = this.convertToCompetitorDTO(competitor);
        BoatDTO boatDTO = this.convertToBoatDTO(competitor.getBoat());
        CompetitorWithBoatDTOImpl competitorDTO = new CompetitorWithBoatDTOImpl(c, boatDTO);
        return competitorDTO;
    }

    @Override
    public CompetitorDTO convertToCompetitorWithOptionalBoatDTO(Competitor competitor) {
        if (competitor.hasBoat()) {
            return this.convertToCompetitorWithBoatDTO((CompetitorWithBoat)competitor);
        }
        return this.convertToCompetitorDTO(competitor);
    }

    @Override
    public Map<CompetitorDTO, BoatDTO> convertToCompetitorAndBoatDTOs(Map<Competitor, ? extends Boat> competitorsAndBoats) {
        HashMap<CompetitorDTO, BoatDTO> result = new HashMap<CompetitorDTO, BoatDTO>();
        for (Map.Entry<Competitor, ? extends Boat> entry : competitorsAndBoats.entrySet()) {
            CompetitorDTO competitorDTO = this.convertToCompetitorWithOptionalBoatDTO(entry.getKey());
            BoatDTO boatDTO = this.convertToBoatDTO(entry.getValue());
            result.put(competitorDTO, boatDTO);
        }
        return result;
    }
}

