/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.ControlPoint;
import com.sap.sailing.domain.base.ControlPointWithTwoMarks;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.BoatClassImpl;
import com.sap.sailing.domain.base.impl.ControlPointWithTwoMarksImpl;
import com.sap.sailing.domain.base.impl.CourseAreaImpl;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.base.impl.MarkImpl;
import com.sap.sailing.domain.base.impl.NationalityImpl;
import com.sap.sailing.domain.base.impl.TransientCompetitorAndBoatStoreImpl;
import com.sap.sailing.domain.base.impl.WaypointImpl;
import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sse.common.Color;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedDomainFactoryImpl<RLR extends RaceLogResolver>
implements SharedDomainFactory<RLR> {
    private static final Logger logger = Logger.getLogger(SharedDomainFactoryImpl.class.getName());
    private final Map<String, Nationality> nationalityCache;
    private final Map<Serializable, Mark> markCache;
    private final NamedReentrantReadWriteLock markCacheLock = new NamedReentrantReadWriteLock("SharedDomainFactoryImpl.markCacheLock", false);
    private final Map<Serializable, ControlPointWithTwoMarks> controlPointWithTwoMarksCache;
    private final Map<String, Serializable> markIdCache;
    private final Map<String, Serializable> controlPointWithTwoMarksIdCache;
    private final Map<String, BoatClass> boatClassCache;
    protected final CompetitorAndBoatStore competitorAndBoatStore;
    private final Map<Serializable, CourseArea> courseAreaCache;
    private final ConcurrentHashMap<Serializable, WeakWaypointReference> waypointCache;
    private final ReferenceQueue<Waypoint> waypointCacheReferenceQueue;
    private final Set<String> mayStartWithNoUpwindLeg;
    private final RLR raceLogResolver;

    public SharedDomainFactoryImpl(RLR raceLogResolver) {
        this(new TransientCompetitorAndBoatStoreImpl(), raceLogResolver);
    }

    public SharedDomainFactoryImpl(CompetitorAndBoatStore competitorStore, RLR raceLogResolver) {
        this.raceLogResolver = raceLogResolver;
        this.waypointCacheReferenceQueue = new ReferenceQueue();
        this.nationalityCache = new HashMap<String, Nationality>();
        this.markCache = new HashMap<Serializable, Mark>();
        this.markIdCache = new HashMap<String, Serializable>();
        this.controlPointWithTwoMarksCache = new HashMap<Serializable, ControlPointWithTwoMarks>();
        this.controlPointWithTwoMarksIdCache = new HashMap<String, Serializable>();
        this.boatClassCache = new HashMap<String, BoatClass>();
        this.competitorAndBoatStore = competitorStore;
        this.waypointCache = new ConcurrentHashMap();
        this.mayStartWithNoUpwindLeg = Collections.singleton(BoatClassMasterdata.unifyBoatClassName((String)BoatClassMasterdata.EXTREME_40.getDisplayName()));
        this.courseAreaCache = new HashMap<Serializable, CourseArea>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Nationality getOrCreateNationality(String threeLetterIOCCode) {
        if (threeLetterIOCCode == null) {
            threeLetterIOCCode = "   ";
        }
        Map<String, Nationality> map = this.nationalityCache;
        synchronized (map) {
            Nationality result = this.nationalityCache.get(threeLetterIOCCode);
            if (result == null) {
                result = new NationalityImpl(threeLetterIOCCode);
                this.nationalityCache.put(threeLetterIOCCode, result);
            }
            return result;
        }
    }

    @Override
    public Mark getOrCreateMark(String name) {
        return this.getOrCreateMark(name, name, name);
    }

    @Override
    public Mark getOrCreateMark(String name, MarkType markType) {
        return this.getOrCreateMark((Serializable)((Object)name), name, markType);
    }

    @Override
    public Mark getOrCreateMark(Serializable id, String name, MarkType markType) {
        return this.getOrCreateMark(id, name, name, markType, null, null, null);
    }

    @Override
    public Mark getOrCreateMark(Serializable id, String name, String shortName) {
        return this.getOrCreateMark(id, name, shortName, null, null);
    }

    @Override
    public Mark getOrCreateMark(Serializable id, String name, String shortName, UUID originatingMarkTemplateId, UUID originatingMarkPropertiesId) {
        return this.getOrCreateMark(id, name, shortName, null, null, null, null, originatingMarkTemplateId, originatingMarkPropertiesId);
    }

    @Override
    public Mark getOrCreateMark(String toStringRepresentationOfID, String name, String shortName) {
        return this.getOrCreateMark(toStringRepresentationOfID, name, shortName, null, null, null, null);
    }

    @Override
    public Mark getOrCreateMark(Serializable id, String name, String shortName, MarkType type, Color color, String shape, String pattern) {
        return this.getOrCreateMark(id, name, shortName, type, color, shape, pattern, null, null);
    }

    @Override
    public Mark getOrCreateMark(Serializable id, String name, String shortName, MarkType type, Color color, String shape, String pattern, UUID originatingMarkTemplateId, UUID originatingMarkPropertiesId) {
        Mark result;
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.markCacheLock);
        try {
            result = this.markCache.get(id);
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.markCacheLock);
        }
        if (result == null) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.markCacheLock);
            try {
                result = this.markCache.get(id);
                if (result == null) {
                    result = new MarkImpl(id, name, shortName, type, color, shape, pattern, originatingMarkTemplateId, originatingMarkPropertiesId);
                    this.cacheMark(id, result);
                }
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.markCacheLock);
            }
        }
        return result;
    }

    @Override
    public Mark getOrCreateMark(String toStringRepresentationOfID, String name, String shortName, MarkType type, Color color, String shape, String pattern) {
        Object id;
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.markCacheLock);
        try {
            id = toStringRepresentationOfID;
            if (this.markIdCache.containsKey(toStringRepresentationOfID)) {
                id = this.markIdCache.get(toStringRepresentationOfID);
            }
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.markCacheLock);
        }
        return this.getOrCreateMark((Serializable)id, name, shortName, type, color, shape, pattern);
    }

    @Override
    public ControlPointWithTwoMarks getOrCreateControlPointWithTwoMarks(Serializable id, String name, Mark left, Mark right, String shortName) {
        ControlPointWithTwoMarks fromCache = this.controlPointWithTwoMarksCache.get(id);
        ControlPointWithTwoMarks result = fromCache != null ? fromCache : this.createControlPointWithTwoMarks(id, left, right, name, shortName);
        return result;
    }

    @Override
    public ControlPointWithTwoMarks getOrCreateControlPointWithTwoMarks(String toStringRepresentationOfID, String name, Mark left, Mark right, String shortName) {
        Object id = toStringRepresentationOfID;
        if (this.controlPointWithTwoMarksIdCache.containsKey(toStringRepresentationOfID)) {
            id = this.controlPointWithTwoMarksIdCache.get(toStringRepresentationOfID);
        }
        return this.getOrCreateControlPointWithTwoMarks((Serializable)id, name, left, right, shortName);
    }

    private void cacheMark(Serializable id, Mark result) {
        assert (this.markCacheLock.isWriteLocked());
        this.markCache.put(id, result);
        this.markIdCache.put(id.toString(), id);
    }

    @Override
    public ControlPointWithTwoMarks createControlPointWithTwoMarks(Mark left, Mark right, String name, String shortName) {
        return this.createControlPointWithTwoMarks((Serializable)((Object)name), left, right, name, shortName);
    }

    @Override
    public ControlPointWithTwoMarks createControlPointWithTwoMarks(Serializable id, Mark left, Mark right, String name, String shortName) {
        if (shortName == null || shortName.isEmpty()) {
            shortName = name;
        }
        ControlPointWithTwoMarksImpl result = new ControlPointWithTwoMarksImpl(id, left, right, name, shortName);
        this.controlPointWithTwoMarksCache.put(id, result);
        this.controlPointWithTwoMarksIdCache.put(id.toString(), id);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Waypoint createWaypoint(ControlPoint controlPoint, PassingInstruction passingInstruction) {
        ConcurrentHashMap<Serializable, WeakWaypointReference> concurrentHashMap = this.waypointCache;
        synchronized (concurrentHashMap) {
            this.expungeStaleWaypointCacheEntries();
            WaypointImpl result = passingInstruction == null ? new WaypointImpl(controlPoint) : new WaypointImpl(controlPoint, passingInstruction);
            this.waypointCache.put(result.getId(), new WeakWaypointReference(result));
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Waypoint getExistingWaypointById(Serializable waypointId) {
        ConcurrentHashMap<Serializable, WeakWaypointReference> concurrentHashMap = this.waypointCache;
        synchronized (concurrentHashMap) {
            this.expungeStaleWaypointCacheEntries();
            Waypoint result = null;
            Reference ref = this.waypointCache.get(waypointId);
            if (ref != null && (result = (Waypoint)ref.get()) == null) {
                this.waypointCache.remove(waypointId);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Waypoint getExistingWaypointByIdOrCache(Waypoint waypoint) {
        ConcurrentHashMap<Serializable, WeakWaypointReference> concurrentHashMap = this.waypointCache;
        synchronized (concurrentHashMap) {
            this.expungeStaleWaypointCacheEntries();
            Waypoint result = null;
            Reference ref = this.waypointCache.get(waypoint.getId());
            if (ref != null) {
                result = (Waypoint)ref.get();
                if (result == null) {
                    result = waypoint;
                    this.waypointCache.put(waypoint.getId(), new WeakWaypointReference(waypoint));
                }
            } else {
                result = waypoint;
                this.waypointCache.put(waypoint.getId(), new WeakWaypointReference(waypoint));
            }
            return result;
        }
    }

    private void expungeStaleWaypointCacheEntries() {
        Reference<Waypoint> ref;
        while ((ref = this.waypointCacheReferenceQueue.poll()) != null) {
            WeakWaypointReference weakWaypointReference = (WeakWaypointReference)ref;
            weakWaypointReference.removeCacheEntry();
        }
    }

    @Override
    public BoatClass getBoatClass(String name) {
        return this.getBoatClassOrCreateIfMasterdataExists(name);
    }

    @Override
    public Iterable<BoatClass> getBoatClasses() {
        return Collections.unmodifiableCollection(this.boatClassCache.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BoatClass getOrCreateBoatClass(String name, boolean typicallyStartsUpwind) {
        Map<String, BoatClass> map = this.boatClassCache;
        synchronized (map) {
            BoatClass result = this.getBoatClassOrCreateIfMasterdataExists(name);
            if (result == null) {
                String unifiedBoatClassName = BoatClassMasterdata.unifyBoatClassNameBasedOnExistingMasterdata((String)name);
                result = new BoatClassImpl(unifiedBoatClassName, typicallyStartsUpwind);
                this.boatClassCache.put(unifiedBoatClassName, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BoatClass getBoatClassOrCreateIfMasterdataExists(String name) {
        BoatClassMasterdata boatClassMasterdata = BoatClassMasterdata.resolveBoatClass((String)name);
        String unifiedBoatClassName = BoatClassMasterdata.unifyBoatClassNameBasedOnExistingMasterdata((String)name);
        Map<String, BoatClass> map = this.boatClassCache;
        synchronized (map) {
            BoatClass result = this.boatClassCache.get(unifiedBoatClassName);
            if (result == null && unifiedBoatClassName != null && boatClassMasterdata != null) {
                result = new BoatClassImpl(boatClassMasterdata);
                this.boatClassCache.put(unifiedBoatClassName, result);
            }
            return result;
        }
    }

    @Override
    public BoatClass getOrCreateBoatClass(String name) {
        String unifiedBoatClassName = BoatClassMasterdata.unifyBoatClassNameBasedOnExistingMasterdata((String)name);
        return this.getOrCreateBoatClass(name, name == null || !this.mayStartWithNoUpwindLeg.contains(unifiedBoatClassName));
    }

    @Override
    public CourseArea getOrCreateCourseArea(UUID courseAreaId, String name, Position centerPosition, Distance radius) {
        CourseArea result = this.getExistingCourseAreaById(courseAreaId);
        if (result == null) {
            result = new CourseAreaImpl(name, courseAreaId, centerPosition, radius);
            this.courseAreaCache.put(courseAreaId, result);
        }
        return result;
    }

    @Override
    public CourseArea getExistingCourseAreaById(Serializable courseAreaId) {
        return courseAreaId == null ? null : this.courseAreaCache.get(courseAreaId);
    }

    @Override
    public CompetitorAndBoatStore getCompetitorAndBoatStore() {
        return this.competitorAndBoatStore;
    }

    @Override
    public Competitor getExistingCompetitorById(Serializable competitorId) {
        return this.getCompetitorAndBoatStore().getExistingCompetitorById(competitorId);
    }

    @Override
    public CompetitorWithBoat getExistingCompetitorWithBoatById(Serializable competitorId) {
        return this.getCompetitorAndBoatStore().getExistingCompetitorWithBoatById(competitorId);
    }

    @Override
    public boolean isCompetitorToUpdateDuringGetOrCreate(Competitor competitor) {
        return this.getCompetitorAndBoatStore().isCompetitorToUpdateDuringGetOrCreate(competitor);
    }

    @Override
    public DynamicCompetitor getOrCreateCompetitor(Serializable competitorId, String name, String shortname, Color displayColor, String email, URI flagImage, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag, boolean storePersistently) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "getting or creating competitor " + name + " with ID " + competitorId + " in domain factory " + this);
        }
        return this.getCompetitorAndBoatStore().getOrCreateCompetitor(competitorId, name, shortname, displayColor, email, flagImage, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, storePersistently);
    }

    @Override
    public DynamicCompetitorWithBoat getOrCreateCompetitorWithBoat(Serializable competitorId, String name, String shortName, Color displayColor, String email, URI flagImageURI, DynamicTeam team, Double timeOnTimeFactor, Duration timeOnDistanceAllowancePerNauticalMile, String searchTag, DynamicBoat boat, boolean storePersistently) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "getting or creating competitor " + name + " with ID " + competitorId + " in domain factory " + this);
        }
        return this.getCompetitorAndBoatStore().getOrCreateCompetitorWithBoat(competitorId, name, shortName, displayColor, email, flagImageURI, team, timeOnTimeFactor, timeOnDistanceAllowancePerNauticalMile, searchTag, boat, storePersistently);
    }

    @Override
    public DynamicBoat getExistingBoatById(Serializable boatId) {
        return this.getCompetitorAndBoatStore().getExistingBoatById(boatId);
    }

    @Override
    public boolean isBoatToUpdateDuringGetOrCreate(Boat boat) {
        return this.getCompetitorAndBoatStore().isBoatToUpdateDuringGetOrCreate(boat);
    }

    @Override
    public DynamicBoat getOrCreateBoat(Serializable id, String name, BoatClass boatClass, String sailId, Color color, boolean storePersistently) {
        return this.getCompetitorAndBoatStore().getOrCreateBoat(id, name, boatClass, sailId, color, storePersistently);
    }

    @Override
    public Mark getExistingMarkById(Serializable id) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.markCacheLock);
        try {
            Mark mark = this.markCache.get(id);
            return mark;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.markCacheLock);
        }
    }

    @Override
    public Mark getExistingMarkByIdAsString(String toStringRepresentationOfID) {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.markCacheLock);
        try {
            Mark mark = this.markCache.get(this.markIdCache.get(toStringRepresentationOfID));
            return mark;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.markCacheLock);
        }
    }

    @Override
    public Collection<Mark> getAllMarks() {
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.markCacheLock);
        try {
            Collection<Mark> collection = this.markCache.values();
            return collection;
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.markCacheLock);
        }
    }

    @Override
    public RLR getRaceLogResolver() {
        return this.raceLogResolver;
    }

    private class WeakWaypointReference
    extends WeakReference<Waypoint> {
        private final Serializable id;

        public WeakWaypointReference(Waypoint waypoint) {
            super(waypoint, SharedDomainFactoryImpl.this.waypointCacheReferenceQueue);
            this.id = waypoint.getId();
        }

        public void removeCacheEntry() {
            SharedDomainFactoryImpl.this.waypointCache.remove(this.id);
        }
    }
}

