/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.Venue;
import com.sap.sailing.domain.base.impl.VenueImpl;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.media.ImageSize;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.common.media.MimeType;
import com.sap.sse.concurrent.CopyOnWriteHashMap;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.MediaDescriptor;
import com.sap.sse.shared.media.MediaUtils;
import com.sap.sse.shared.media.VideoDescriptor;
import com.sap.sse.shared.media.impl.ImageDescriptorImpl;
import com.sap.sse.shared.media.impl.VideoDescriptorImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class EventBaseImpl
implements EventBase {
    private static final long serialVersionUID = -4055554853909324357L;
    private String name;
    private String description;
    private final Venue venue;
    private boolean isPublic;
    private final UUID id;
    private TimePoint startDate;
    private TimePoint endDate;
    private URL officialWebsiteURL;
    private URL baseURL;
    private CopyOnWriteHashMap<Locale, URL> sailorsInfoWebsiteURLs;
    private ConcurrentLinkedQueue<ImageDescriptor> images;
    private ConcurrentLinkedQueue<VideoDescriptor> videos;

    protected EventBaseImpl(String name, TimePoint startDate, TimePoint endDate, String venueName, boolean isPublic, UUID id) {
        this(name, startDate, endDate, new VenueImpl(venueName), isPublic, id);
    }

    protected EventBaseImpl(String name, TimePoint startDate, TimePoint endDate, Venue venue, boolean isPublic, UUID id) {
        assert (venue != null);
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            throw new IllegalArgumentException("Event " + name + " cannot start after it ends. Start: " + startDate + ", end: " + endDate);
        }
        this.id = id;
        this.name = name;
        this.startDate = startDate;
        this.endDate = endDate;
        this.venue = venue;
        this.isPublic = isPublic;
        this.images = new ConcurrentLinkedQueue();
        this.videos = new ConcurrentLinkedQueue();
        this.sailorsInfoWebsiteURLs = new CopyOnWriteHashMap("lock for sailorsInfoWebsiteURLs of event " + id.toString());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.images == null) {
            this.images = new ConcurrentLinkedQueue();
        }
        if (this.videos == null) {
            this.videos = new ConcurrentLinkedQueue();
        }
        if (this.sailorsInfoWebsiteURLs == null) {
            this.sailorsInfoWebsiteURLs = new CopyOnWriteHashMap("lock for sailorsInfoWebsiteURLs of event " + this.id.toString());
        }
    }

    public UUID getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Venue getVenue() {
        return this.venue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("An event name must not be null");
        }
        this.name = newName;
    }

    @Override
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Override
    public TimePoint getStartDate() {
        return this.startDate;
    }

    @Override
    public void setStartAndEndDate(TimePoint startDate, TimePoint endDate) {
        if (startDate != null && endDate != null && endDate.before(startDate)) {
            throw new IllegalArgumentException("Event start date (" + startDate + ") for event " + this + " must not be after end date " + endDate);
        }
        this.startDate = startDate;
        this.endDate = endDate;
    }

    @Override
    public void setStartDate(TimePoint startDate) {
        if (startDate != null && this.getEndDate() != null && this.getEndDate().before(startDate)) {
            throw new IllegalArgumentException("Event start date (" + startDate + ") for event " + this + " must not be after end date " + this.getEndDate());
        }
        this.startDate = startDate;
    }

    @Override
    public TimePoint getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(TimePoint endDate) {
        if (endDate != null && this.getStartDate() != null && this.getStartDate().after(endDate)) {
            throw new IllegalArgumentException("Event end date (" + endDate + ") for event " + this + " must not be before start date " + this.getStartDate());
        }
        this.endDate = endDate;
    }

    @Override
    public URL getOfficialWebsiteURL() {
        return this.officialWebsiteURL;
    }

    @Override
    public void setOfficialWebsiteURL(URL officialWebsiteURL) {
        this.officialWebsiteURL = officialWebsiteURL;
    }

    @Override
    public URL getBaseURL() {
        return this.baseURL;
    }

    @Override
    public void setBaseURL(URL baseURL) {
        this.baseURL = baseURL;
    }

    @Override
    public Map<Locale, URL> getSailorsInfoWebsiteURLs() {
        return Collections.unmodifiableMap(this.sailorsInfoWebsiteURLs);
    }

    @Override
    public void setSailorsInfoWebsiteURLs(Map<Locale, URL> sailorsInfoWebsiteURLs) {
        this.sailorsInfoWebsiteURLs.set(sailorsInfoWebsiteURLs);
    }

    @Override
    public void setSailorsInfoWebsiteURL(Locale locale, URL sailorsInfoWebsiteURL) {
        if (sailorsInfoWebsiteURL == null) {
            this.sailorsInfoWebsiteURLs.remove((Object)locale);
        } else {
            this.sailorsInfoWebsiteURLs.put((Object)locale, (Object)sailorsInfoWebsiteURL);
        }
    }

    @Override
    public boolean hasSailorsInfoWebsiteURL(Locale locale) {
        return this.sailorsInfoWebsiteURLs.containsKey((Object)locale);
    }

    @Override
    public URL getSailorsInfoWebsiteURL(Locale locale) {
        return (URL)this.sailorsInfoWebsiteURLs.get((Object)locale);
    }

    @Override
    public URL getSailorsInfoWebsiteURLOrFallback(Locale locale) {
        URL result = this.hasSailorsInfoWebsiteURL(locale) ? (URL)this.sailorsInfoWebsiteURLs.get((Object)locale) : (URL)this.sailorsInfoWebsiteURLs.get(null);
        return result;
    }

    public Iterable<ImageDescriptor> getImages() {
        return Collections.unmodifiableCollection(this.images);
    }

    public void addImage(ImageDescriptor image) {
        if (!this.images.contains(image)) {
            this.images.add(image);
        }
    }

    public void removeImage(ImageDescriptor image) {
        this.images.remove(image);
    }

    public void setImages(Iterable<ImageDescriptor> images) {
        this.images.clear();
        if (images != null) {
            Util.addAll(images, this.images);
        }
    }

    public Iterable<VideoDescriptor> getVideos() {
        return Collections.unmodifiableCollection(this.videos);
    }

    public void addVideo(VideoDescriptor video) {
        if (!this.videos.contains(video)) {
            this.videos.add(video);
        }
    }

    public void removeVideo(VideoDescriptor video) {
        this.videos.remove(video);
    }

    public void setVideos(Iterable<VideoDescriptor> videos) {
        this.videos.clear();
        if (videos != null) {
            Util.addAll(videos, this.videos);
        }
    }

    public ImageDescriptor findImageWithTag(String tagName) {
        ImageDescriptor result = null;
        List<ImageDescriptor> mediaWithTag = this.findMediaWithTag(this.images, tagName);
        if (mediaWithTag.size() > 0) {
            result = mediaWithTag.get(0);
        }
        return result;
    }

    public VideoDescriptor findVideoWithTag(String tagName) {
        VideoDescriptor result = null;
        List<VideoDescriptor> mediaWithTag = this.findMediaWithTag(this.videos, tagName);
        if (mediaWithTag.size() > 0) {
            result = mediaWithTag.get(0);
        }
        return result;
    }

    public boolean hasImageWithTag(String tagName) {
        List<ImageDescriptor> mediaWithTag = this.findMediaWithTag(this.images, tagName);
        return mediaWithTag.size() > 0;
    }

    public List<ImageDescriptor> findImagesWithTag(String tagName) {
        return this.findMediaWithTag(this.images, tagName);
    }

    public List<VideoDescriptor> findVideosWithTag(String tagName) {
        return this.findMediaWithTag(this.videos, tagName);
    }

    private <T extends MediaDescriptor> List<T> findMediaWithTag(Iterable<T> media, String tagName) {
        ArrayList<MediaDescriptor> result = new ArrayList<MediaDescriptor>();
        for (MediaDescriptor mediaEntry : media) {
            if (!mediaEntry.hasTag(tagName)) continue;
            result.add(mediaEntry);
        }
        return result;
    }

    @Override
    public boolean setMediaURLs(Iterable<URL> imageURLs, Iterable<URL> sponsorImageURLs, Iterable<URL> videoURLs, URL logoImageURL, Map<URL, ImageSize> imageSizes) {
        ImageDescriptor image;
        boolean changed = false;
        for (URL url : imageURLs) {
            if (this.hasMedia(this.images, url)) continue;
            image = this.migrateImageURLtoImage(url, this.getStartDate(), imageSizes.get(url));
            String urlAsString = url.toString();
            if (urlAsString.toLowerCase().indexOf("stage") > 0) {
                image.addTag(MediaTagConstants.STAGE.getName());
            } else if (urlAsString.toLowerCase().indexOf("eventteaser") > 0) {
                image.addTag(MediaTagConstants.TEASER.getName());
            } else {
                image.addTag(MediaTagConstants.GALLERY.getName());
            }
            this.addImage(image);
            changed = true;
        }
        for (URL url : sponsorImageURLs) {
            if (this.hasMedia(this.images, url)) continue;
            image = this.migrateImageURLtoImage(url, this.getStartDate(), imageSizes.get(url));
            image.addTag(MediaTagConstants.SPONSOR.getName());
            this.addImage(image);
            changed = true;
        }
        if (logoImageURL != null && !this.hasMedia(this.images, logoImageURL)) {
            ImageDescriptor image2 = this.migrateImageURLtoImage(logoImageURL, this.getStartDate(), imageSizes.get(logoImageURL));
            image2.addTag(MediaTagConstants.LOGO.getName());
            this.addImage(image2);
            changed = true;
        }
        for (URL url : videoURLs) {
            if (this.hasMedia(this.videos, url)) continue;
            MimeType mimeType = MediaUtils.detectMimeTypeFromUrl((String)url.toString());
            VideoDescriptorImpl video = new VideoDescriptorImpl(url, mimeType, this.getStartDate());
            this.addVideo((VideoDescriptor)video);
            changed = true;
        }
        return changed;
    }

    private ImageDescriptor migrateImageURLtoImage(URL url, TimePoint createdAt, ImageSize imageSize) {
        ImageDescriptorImpl image = new ImageDescriptorImpl(url, createdAt);
        if (imageSize != null) {
            image.setSize(Integer.valueOf(imageSize.getWidth()), Integer.valueOf(imageSize.getHeight()));
        } else {
            Util.Pair imageDimensions = MediaUtils.getImageDimensions((URL)url);
            if (imageDimensions != null) {
                image.setSize(imageDimensions);
            }
        }
        return image;
    }

    private boolean hasMedia(Iterable<? extends MediaDescriptor> media, URL url) {
        for (MediaDescriptor mediaDescriptor : media) {
            if (!url.equals(mediaDescriptor.getURL())) continue;
            return true;
        }
        return false;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.EVENT;
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return EventBaseImpl.getTypeRelativeObjectIdentifier(this.getId());
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(UUID id) {
        return new TypeRelativeObjectIdentifier(new String[]{id.toString()});
    }
}

