/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatChangeListener;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.Color;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.RenamableImpl;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class BoatImpl
extends RenamableImpl
implements DynamicBoat {
    private static final long serialVersionUID = 3489730487528955788L;
    private final BoatClass boatClass;
    private final Serializable id;
    private String sailID;
    private Color color;
    private transient Set<BoatChangeListener> listeners;

    public BoatImpl(Serializable id, String name, BoatClass boatClass, String sailId) {
        this(id, name, boatClass, sailId, null);
    }

    public BoatImpl(Serializable id, String name, BoatClass boatClass, String sailID, Color color) {
        super(name);
        this.id = id;
        this.boatClass = boatClass;
        this.sailID = sailID;
        this.color = color;
        this.listeners = new HashSet<BoatChangeListener>();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.listeners = new HashSet<BoatChangeListener>();
    }

    public Serializable getId() {
        return this.id;
    }

    @Override
    public BoatClass getBoatClass() {
        return this.boatClass;
    }

    @Override
    public String getSailID() {
        return this.sailID;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.getName();
        if (!Util.equalsWithNull((Object)oldName, (Object)newName)) {
            super.setName(newName);
            for (BoatChangeListener listener : this.getListeners()) {
                listener.nameChanged(oldName, newName);
            }
        }
    }

    @Override
    public void setSailId(String newSailId) {
        String oldSailId = this.sailID;
        if (!Util.equalsWithNull((Object)oldSailId, (Object)newSailId)) {
            this.sailID = newSailId;
            for (BoatChangeListener listener : this.getListeners()) {
                listener.sailIdChanged(oldSailId, newSailId);
            }
        }
    }

    @Override
    public void setColor(Color newColor) {
        Color oldColor = this.color;
        if (!Util.equalsWithNull((Object)oldColor, (Object)newColor)) {
            this.color = newColor;
            for (BoatChangeListener listener : this.getListeners()) {
                listener.colorChanged(oldColor, newColor);
            }
        }
    }

    public Boat resolve(SharedDomainFactory<?> domainFactory) {
        return domainFactory.getOrCreateBoat(this.getId(), this.getName(), this.getBoatClass(), this.getSailID(), this.getColor(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBoatChangeListener(BoatChangeListener listener) {
        Set<BoatChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBoatChangeListener(BoatChangeListener listener) {
        Set<BoatChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<BoatChangeListener> getListeners() {
        Set<BoatChangeListener> set = this.listeners;
        synchronized (set) {
            return new HashSet<BoatChangeListener>(this.listeners);
        }
    }

    public String toString() {
        return this.getName() == null ? this.getSailID() : this.getName();
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.BOAT;
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return BoatImpl.getTypeRelativeObjectIdentifier(this.getId());
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(Serializable id) {
        return new TypeRelativeObjectIdentifier(new String[]{id.toString()});
    }
}

