/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sailing.domain.common.BoatHullType;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.NamedImpl;

public class BoatClassImpl
extends NamedImpl
implements BoatClass {
    private static final long serialVersionUID = 7194912853476256420L;
    private static final double MINIMUM_ANGLE_BETWEEN_DIFFERENT_TACKS_UPWIND = 60.0;
    private static final double MINIMUM_ANGLE_BETWEEN_DIFFERENT_TACKS_DOWNWIND = 15.0;
    private static final double MANEUVER_DEGREE_ANGLE_THRESHOLD = Math.min(15.0, 60.0);
    private static final Distance MAXIMUM_DISTANCE_FOR_COURSE_APPROXIMATION = new MeterDistance(3.0);
    private static final double UPWIND_WIND_ESTIMATION_CONFIDENCE = 0.9;
    private static final double DOWNWIND_WIND_ESTIMATION_CONFIDENCE = 0.2;
    private final boolean typicallyStartsUpwind;
    private final Distance hullLength;
    private final Distance hullBeam;
    private final BoatHullType hullType;

    public BoatClassImpl(String name, boolean typicallyStartsUpwind) {
        this(name, typicallyStartsUpwind, (Distance)new MeterDistance(5.0), (Distance)new MeterDistance(1.8), BoatHullType.MONOHULL);
    }

    public BoatClassImpl(BoatClassMasterdata masterData) {
        this(masterData.getDisplayName(), masterData.isTypicallyStartsUpwind(), masterData.getHullLength(), masterData.getHullBeam(), masterData.getHullType());
    }

    public BoatClassImpl(String name, boolean typicallyStartsUpwind, Distance hullLength, Distance hullBeam, BoatHullType hullType) {
        super(name);
        this.typicallyStartsUpwind = typicallyStartsUpwind;
        this.hullLength = hullLength;
        this.hullBeam = hullBeam;
        this.hullType = hullType;
    }

    @Override
    public Duration getApproximateManeuverDuration() {
        return APPROXIMATE_AVERAGE_MANEUVER_DURATION;
    }

    @Override
    public long getApproximateManeuverDurationInMilliseconds() {
        return this.getApproximateManeuverDuration().asMillis();
    }

    @Override
    public double getManeuverDegreeAngleThreshold() {
        return MANEUVER_DEGREE_ANGLE_THRESHOLD;
    }

    @Override
    public double getMinimumAngleBetweenDifferentTacksUpwind() {
        return 60.0;
    }

    @Override
    public double getMinimumAngleBetweenDifferentTacksDownwind() {
        return 15.0;
    }

    @Override
    public Distance getMaximumDistanceForCourseApproximation() {
        return MAXIMUM_DISTANCE_FOR_COURSE_APPROXIMATION;
    }

    @Override
    public boolean typicallyStartsUpwind() {
        return this.typicallyStartsUpwind;
    }

    @Override
    public Distance getHullLength() {
        return this.hullLength;
    }

    @Override
    public double getDownwindWindEstimationConfidence() {
        return 0.2;
    }

    @Override
    public double getUpwindWindEstimationConfidence() {
        return 0.9;
    }

    public BoatClass resolve(SharedDomainFactory<?> domainFactory) {
        return domainFactory.getOrCreateBoatClass(this.getName(), this.typicallyStartsUpwind());
    }

    @Override
    public Distance getHullBeam() {
        return this.hullBeam;
    }

    @Override
    public BoatHullType getHullType() {
        return this.hullType;
    }
}

