/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.configuration.impl;

import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.impl.NamedImpl;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

public class DeviceConfigurationImpl
extends NamedImpl
implements DeviceConfiguration {
    private static final long serialVersionUID = 6084215932610324314L;
    private RegattaConfiguration regattaConfiguration;
    private List<String> allowedCourseAreaNames;
    private String resultsMailRecipient;
    private List<String> byNameDesignerCourseNames;
    private final UUID id;
    private UUID eventId;
    private UUID courseAreaId;
    private Integer priority;

    public DeviceConfigurationImpl(DeviceConfiguration other) {
        super(other.getName());
        this.id = other.getId();
        this.regattaConfiguration = other.getRegattaConfiguration();
        this.allowedCourseAreaNames = other.getAllowedCourseAreaNames() == null ? null : new ArrayList<String>(other.getAllowedCourseAreaNames());
        this.resultsMailRecipient = other.getResultsMailRecipient();
        this.byNameDesignerCourseNames = other.getByNameCourseDesignerCourseNames() == null ? null : new ArrayList<String>(other.getByNameCourseDesignerCourseNames());
        this.eventId = other.getEventId().orElse(null);
        this.courseAreaId = other.getCourseAreaId().orElse(null);
        this.priority = other.getPriority().orElse(null);
    }

    public DeviceConfigurationImpl(RegattaConfiguration regattaConfiguration, UUID id, String name) {
        super(name);
        this.regattaConfiguration = regattaConfiguration;
        this.id = id;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public void setRegattaConfiguration(RegattaConfiguration proceduresConfiguration) {
        this.regattaConfiguration = proceduresConfiguration;
    }

    @Override
    public Optional<UUID> getEventId() {
        return Optional.ofNullable(this.eventId);
    }

    @Override
    public void setEventId(UUID eventId) {
        this.eventId = eventId;
    }

    @Override
    public Optional<UUID> getCourseAreaId() {
        return Optional.ofNullable(this.courseAreaId);
    }

    @Override
    public void setCourseAreaId(UUID courseAreaId) {
        this.courseAreaId = courseAreaId;
    }

    @Override
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(this.priority);
    }

    @Override
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Override
    public RegattaConfiguration getRegattaConfiguration() {
        return this.regattaConfiguration;
    }

    @Override
    public List<String> getAllowedCourseAreaNames() {
        return this.allowedCourseAreaNames;
    }

    public void setAllowedCourseAreaNames(List<String> newAllowedCourseAreaNames) {
        this.allowedCourseAreaNames = newAllowedCourseAreaNames;
    }

    @Override
    public String getResultsMailRecipient() {
        return this.resultsMailRecipient;
    }

    public void setResultsMailRecipient(String resultsMailRecipient) {
        this.resultsMailRecipient = resultsMailRecipient;
    }

    @Override
    public List<String> getByNameCourseDesignerCourseNames() {
        return this.byNameDesignerCourseNames;
    }

    public void setByNameDesignerCourseNames(List<String> byNameDesignerCourseNames) {
        this.byNameDesignerCourseNames = byNameDesignerCourseNames;
    }

    @Override
    public DeviceConfiguration copy() {
        DeviceConfigurationImpl copyConfiguration = new DeviceConfigurationImpl(this.regattaConfiguration.clone(), this.getId(), this.getName());
        copyConfiguration.setAllowedCourseAreaNames(this.allowedCourseAreaNames);
        copyConfiguration.setByNameDesignerCourseNames(this.byNameDesignerCourseNames);
        copyConfiguration.setResultsMailRecipient(this.resultsMailRecipient);
        return copyConfiguration;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.RACE_MANAGER_APP_DEVICE_CONFIGURATION;
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return DeviceConfigurationImpl.getTypeRelativeObjectIdentifier(this.getId());
    }

    public static TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier(UUID id) {
        return new TypeRelativeObjectIdentifier(new String[]{id.toString()});
    }
}

