/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogCloseOpenEndedDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDeviceMappingEvent;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogDeviceMappingFinder;
import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.WithID;
import com.sap.sse.common.impl.TimeRangeImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

public abstract class BaseRegattaLogDeviceMappingFinder<ItemT extends WithID>
extends RegattaLogDeviceMappingFinder<ItemT> {
    public BaseRegattaLogDeviceMappingFinder(RegattaLog log) {
        super(log);
    }

    public void removeTimePointFromMapping(ItemT item, TimePoint fixTimePoint) throws NotRevokableException {
        HashMap events = new HashMap();
        HashMap<Serializable, RegattaLogCloseOpenEndedDeviceMappingEvent> closingEvents = new HashMap<Serializable, RegattaLogCloseOpenEndedDeviceMappingEvent>();
        this.findUnrevokedMappingAndClosingEvents(events, closingEvents);
        for (RegattaLogDeviceMappingEvent event : (List)events.get(item)) {
            RegattaLogCloseOpenEndedDeviceMappingEvent closingEvent;
            TimePoint toInclusive;
            TimePoint from = event.getFrom();
            TimeRangeImpl mappingTimeRange = new TimeRangeImpl(from, toInclusive = (closingEvent = (RegattaLogCloseOpenEndedDeviceMappingEvent)closingEvents.get(event.getId())) != null ? closingEvent.getClosingTimePointInclusive() : event.getToInclusive(), true);
            if (!mappingTimeRange.includes(fixTimePoint)) continue;
            if (closingEvent != null) {
                ((RegattaLog)this.log).revokeEvent(closingEvent.getAuthor(), closingEvent, "removing single time point " + fixTimePoint + " from mapping for " + item);
            }
            ((RegattaLog)this.log).revokeEvent(event.getAuthor(), event, "removing single time point " + fixTimePoint + " from mapping for " + item);
            TimePoint endOfFirstHalf = fixTimePoint.minus(1L);
            TimePoint startOfSecondHalf = fixTimePoint.plus(1L);
            if (!endOfFirstHalf.before(from)) {
                ((RegattaLog)this.log).add(this.createDeviceMappingEvent(item, event.getAuthor(), from, endOfFirstHalf, event.getDevice()));
            }
            if (toInclusive != null && toInclusive.before(startOfSecondHalf)) continue;
            ((RegattaLog)this.log).add(this.createDeviceMappingEvent(item, event.getAuthor(), startOfSecondHalf, toInclusive, event.getDevice()));
        }
    }

    public boolean hasMappingFor(ItemT item, TimePoint fixTimePoint) {
        boolean result = false;
        HashMap events = new HashMap();
        HashMap<Serializable, RegattaLogCloseOpenEndedDeviceMappingEvent> closingEvents = new HashMap<Serializable, RegattaLogCloseOpenEndedDeviceMappingEvent>();
        this.findUnrevokedMappingAndClosingEvents(events, closingEvents);
        List mappingsList = (List)events.get(item);
        if (mappingsList != null) {
            for (RegattaLogDeviceMappingEvent event : mappingsList) {
                RegattaLogCloseOpenEndedDeviceMappingEvent closingEvent;
                TimePoint toInclusive;
                TimePoint from = event.getFrom();
                TimeRangeImpl mappingTimeRange = new TimeRangeImpl(from, toInclusive = (closingEvent = (RegattaLogCloseOpenEndedDeviceMappingEvent)closingEvents.get(event.getId())) != null ? closingEvent.getClosingTimePointInclusive() : event.getToInclusive(), true);
                if (!mappingTimeRange.includes(fixTimePoint)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected abstract RegattaLogDeviceMappingEvent<ItemT> createDeviceMappingEvent(ItemT var1, AbstractLogEventAuthor var2, TimePoint var3, TimePoint var4, DeviceIdentifier var5);
}

