/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.regatta.events.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEventVisitor;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogSetCompetitorTimeOnTimeFactorEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogSetCompetitorHandicapInfoEventImpl;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sse.common.TimePoint;
import java.io.Serializable;

public class RegattaLogSetCompetitorTimeOnTimeFactorEventImpl
extends RegattaLogSetCompetitorHandicapInfoEventImpl
implements RegattaLogSetCompetitorTimeOnTimeFactorEvent {
    private static final long serialVersionUID = -7891407213804859604L;
    private final Double timeOnTimeFactor;

    public RegattaLogSetCompetitorTimeOnTimeFactorEventImpl(TimePoint createdAt, TimePoint logicalTimePoint, AbstractLogEventAuthor author, Serializable pId, Competitor competitor, Double timeOnTimeFactor) {
        super(createdAt, logicalTimePoint, author, pId, competitor);
        if (!Double.isFinite(timeOnTimeFactor)) {
            throw new IllegalArgumentException("A competitor's time-on-time factor must be a finite number. " + timeOnTimeFactor + " is not.");
        }
        this.timeOnTimeFactor = timeOnTimeFactor;
    }

    @Override
    public void accept(RegattaLogEventVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Double getTimeOnTimeFactor() {
        return this.timeOnTimeFactor;
    }

    @Override
    public String getShortInfo() {
        return String.valueOf(super.getShortInfo()) + ", timeOnTimeFactor: " + this.timeOnTimeFactor;
    }
}

