/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.state.racingprocedure.line.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RacingProcedureTypeAnalyzer;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartModeFlagFinder;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFlagEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedureChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedurePrerequisite;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.BaseRacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.NoMorePrerequisite;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.RacingProcedureChangedListeners;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.line.ConfigurableStartModeFlagRacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.line.LineStartChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.line.impl.LineStartChangedListeners;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.line.impl.StartModePrerequisite;
import com.sap.sailing.domain.base.configuration.procedures.ConfigurableStartModeFlagRacingProcedureConfiguration;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import java.util.List;

public abstract class ConfigurableStartModeFlagRacingProcedureImpl
extends BaseRacingProcedure
implements ConfigurableStartModeFlagRacingProcedure {
    Flags cachedStartmodeFlag;
    boolean startmodeFlagHasBeenSet;
    private StartModeFlagFinder startModeFlagAnalyzer;

    ConfigurableStartModeFlagRacingProcedureImpl(RaceLog raceLog, AbstractLogEventAuthor author, ConfigurableStartModeFlagRacingProcedureConfiguration configuration, RaceLogResolver raceLogResolver) {
        super(raceLog, author, configuration, raceLogResolver);
        RacingProcedureTypeAnalyzer procedureAnalyzer = new RacingProcedureTypeAnalyzer(raceLog);
        List<Flags> startModeFlags = this.getConfiguration().getStartModeFlags();
        if (startModeFlags == null) {
            this.startModeFlagAnalyzer = new StartModeFlagFinder(procedureAnalyzer, raceLog, this.getDefaultStartModeFlags());
        } else {
            Flags defaultStartMode = this.getDefaultStartMode();
            this.cachedStartmodeFlag = startModeFlags.isEmpty() || startModeFlags.contains(defaultStartMode) ? defaultStartMode : startModeFlags.get(0);
            this.startModeFlagAnalyzer = new StartModeFlagFinder(procedureAnalyzer, raceLog, startModeFlags);
        }
        this.startmodeFlagHasBeenSet = false;
        this.update();
    }

    protected abstract Duration getStartPhaseStartModeUpInterval();

    @Override
    public boolean isStartphaseActive(TimePoint startTime, TimePoint now) {
        return now.before(startTime) && !now.before(startTime.minus(this.getStartPhaseStartModeUpInterval()));
    }

    @Override
    public RacingProcedurePrerequisite checkPrerequisitesForStart(TimePoint now, TimePoint startTime, RacingProcedurePrerequisite.FulfillmentFunction function) {
        if (startTime.minus(this.getStartPhaseStartModeUpInterval()).before(now) && !this.startmodeFlagHasBeenSet) {
            return new StartModePrerequisite(function, this, now, startTime);
        }
        return new NoMorePrerequisite(function);
    }

    @Override
    public void setStartModeFlag(TimePoint timePoint, Flags startMode) {
        this.raceLog.add(new RaceLogFlagEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), startMode, Flags.NONE, true));
    }

    @Override
    public Flags getStartModeFlag() {
        return this.cachedStartmodeFlag;
    }

    @Override
    protected void update() {
        Flags startModeFlag = (Flags)this.startModeFlagAnalyzer.analyze();
        if (!(startModeFlag == null || startModeFlag.equals((Object)this.cachedStartmodeFlag) && this.startmodeFlagHasBeenSet)) {
            this.startmodeFlagHasBeenSet = true;
            this.cachedStartmodeFlag = startModeFlag;
            this.getChangedListeners().onStartModeChanged(this);
        }
        super.update();
    }

    @Override
    protected RacingProcedureChangedListeners<? extends RacingProcedureChangedListener> createChangedListenerContainer() {
        return new LineStartChangedListeners();
    }

    protected LineStartChangedListeners getChangedListeners() {
        return (LineStartChangedListeners)super.getChangedListeners();
    }

    @Override
    public void addChangedListener(LineStartChangedListener listener) {
        this.getChangedListeners().add(listener);
    }

    @Override
    public ConfigurableStartModeFlagRacingProcedureConfiguration getConfiguration() {
        return (ConfigurableStartModeFlagRacingProcedureConfiguration)super.getConfiguration();
    }
}

