/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.state.racingprocedure.league.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.state.RaceStateEvent;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateEvents;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.FlagPoleState;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedureChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedurePrerequisite;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.BaseRacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.NoMorePrerequisite;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.RacingProcedureChangedListeners;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.league.LeagueRacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.league.impl.LeagueRacingProcedureChangedListeners;
import com.sap.sailing.domain.base.configuration.procedures.LeagueConfiguration;
import com.sap.sailing.domain.common.racelog.FlagPole;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sse.common.TimePoint;
import java.util.Arrays;
import java.util.Collections;

public class LeagueRacingProcedureImpl
extends BaseRacingProcedure
implements LeagueRacingProcedure {
    private static final long startPhaseClassUpInterval = 180000L;
    private static final long startPhaseStartModeUpInterval = 120000L;
    private static final long startPhaseStartModeDownInterval = 60000L;
    private static final Flags startmodeFlag = Flags.PAPA;

    public LeagueRacingProcedureImpl(RaceLog raceLog, AbstractLogEventAuthor author, LeagueConfiguration configuration, RaceLogResolver raceLogResolver) {
        super(raceLog, author, configuration, raceLogResolver);
        this.update();
    }

    @Override
    public RacingProcedureType getType() {
        return RacingProcedureType.LEAGUE;
    }

    @Override
    protected boolean hasIndividualRecallByDefault() {
        return true;
    }

    @Override
    protected Boolean isResultEntryEnabledByDefault() {
        return true;
    }

    @Override
    public RacingProcedurePrerequisite checkPrerequisitesForStart(TimePoint now, TimePoint startTime, RacingProcedurePrerequisite.FulfillmentFunction function) {
        return new NoMorePrerequisite(function);
    }

    @Override
    public boolean isStartphaseActive(TimePoint startTime, TimePoint now) {
        if (now.before(startTime)) {
            long timeTillStart = startTime.minus(now.asMillis()).asMillis();
            return timeTillStart < 180000L;
        }
        return false;
    }

    @Override
    public boolean processStateEvent(RaceStateEvent event) {
        switch (event.getEventName()) {
            case RRS26_CLASS_UP: 
            case RRS26_STARTMODE_UP: 
            case RRS26_STARTMODE_DOWN: {
                this.getChangedListeners().onActiveFlagsChanged(this);
                return true;
            }
        }
        return super.processStateEvent(event);
    }

    @Override
    public Iterable<RaceStateEvent> createStartStateEvents(TimePoint startTime) {
        return Arrays.asList(new RaceStateEventImpl(startTime.minus(180000L), RaceStateEvents.RRS26_CLASS_UP), new RaceStateEventImpl(startTime.minus(120000L), RaceStateEvents.RRS26_STARTMODE_UP), new RaceStateEventImpl(startTime.minus(60000L), RaceStateEvents.RRS26_STARTMODE_DOWN), new RaceStateEventImpl(startTime, RaceStateEvents.START));
    }

    @Override
    public FlagPoleState getActiveFlags(TimePoint startTime, TimePoint now) {
        Flags classFlag;
        Flags flags = classFlag = this.getConfiguration().getClassFlag() != null ? this.getConfiguration().getClassFlag() : Flags.CLASS;
        if (now.before(startTime.minus(180000L))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, false), new FlagPole(startmodeFlag, false)), null, Arrays.asList(new FlagPole(classFlag, true), new FlagPole(startmodeFlag, false)), startTime.minus(180000L));
        }
        if (now.before(startTime.minus(120000L))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, true), new FlagPole(startmodeFlag, false)), startTime.minus(180000L), Arrays.asList(new FlagPole(classFlag, true), new FlagPole(startmodeFlag, true)), startTime.minus(120000L));
        }
        if (now.before(startTime.minus(60000L))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, true), new FlagPole(startmodeFlag, true)), startTime.minus(120000L), Arrays.asList(new FlagPole(classFlag, true), new FlagPole(startmodeFlag, false)), startTime.minus(60000L));
        }
        if (now.before(startTime)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, true), new FlagPole(startmodeFlag, false)), startTime.minus(60000L), Arrays.asList(new FlagPole(classFlag, false), new FlagPole(startmodeFlag, false)), startTime);
        }
        if (this.isIndividualRecallDisplayed(now)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.XRAY, true)), this.getIndividualRecallDisplayedTime(), Arrays.asList(new FlagPole(Flags.XRAY, false)), this.getIndividualRecallRemovalTime());
        }
        if (this.isFinished(now)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.BLUE, false)), this.getFinishedTime());
        }
        if (this.isInFinishingPhase(now)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.BLUE, true)), this.getFinishingTime(), Arrays.asList(new FlagPole(Flags.BLUE, false)), null);
        }
        TimePoint recallRemoved = this.getIndividualRecallRemovalTime();
        return new FlagPoleState(Collections.emptyList(), recallRemoved == null ? startTime : recallRemoved);
    }

    @Override
    protected RacingProcedureChangedListeners<? extends RacingProcedureChangedListener> createChangedListenerContainer() {
        return new LeagueRacingProcedureChangedListeners();
    }
}

