/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogChangedListener;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishedTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishingTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.IndividualRecallDisplayedFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.IndividualRecallRemovedFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.IsFinishedAnalyzer;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.IsInFinishingPhaseAnalyzer;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.IsIndividualRecallDisplayedAnalyzer;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.StartTimeFinderResult;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogFlagEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.WeakRaceLogChangedVisitor;
import com.sap.sailing.domain.abstractlog.race.state.RaceStateEvent;
import com.sap.sailing.domain.abstractlog.race.state.RaceStateEventScheduler;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.BaseRaceStateChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateEvents;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedureChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.RacingProcedureChangedListeners;
import com.sap.sailing.domain.base.configuration.RacingProcedureConfiguration;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Logger;

public abstract class BaseRacingProcedure
extends BaseRaceStateChangedListener
implements RacingProcedure,
RaceLogChangedListener {
    private static final Logger logger = Logger.getLogger(BaseRacingProcedure.class.getName());
    private static final Duration individualRecallRemovalTimeout = Duration.ONE_MINUTE.times(4L);
    private RaceStateEventScheduler scheduler;
    protected final RaceLog raceLog;
    protected final AbstractLogEventAuthor author;
    private final RacingProcedureConfiguration configuration;
    private final RacingProcedureChangedListeners<? extends RacingProcedureChangedListener> changedListeners;
    private final IsIndividualRecallDisplayedAnalyzer isRecallDisplayedAnalyzer;
    private final IndividualRecallDisplayedFinder recallDisplayedFinder;
    private final IndividualRecallRemovedFinder recallRemovedFinder;
    private final FinishingTimeFinder finishingTimeFinder;
    private final FinishedTimeFinder finishedTimeFinder;
    private final RaceLogEventVisitor raceLogListener;
    private final StartTimeFinder startTimeFinder;
    private boolean cachedIsIndividualRecallDisplayed;

    public BaseRacingProcedure(RaceLog raceLog, AbstractLogEventAuthor author, RacingProcedureConfiguration configuration, RaceLogResolver raceLogResolver) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        this.raceLog = raceLog;
        this.author = author;
        this.configuration = configuration;
        this.changedListeners = this.createChangedListenerContainer();
        this.isRecallDisplayedAnalyzer = new IsIndividualRecallDisplayedAnalyzer(raceLog);
        this.recallDisplayedFinder = new IndividualRecallDisplayedFinder(raceLog);
        this.recallRemovedFinder = new IndividualRecallRemovedFinder(raceLog);
        this.finishingTimeFinder = new FinishingTimeFinder(raceLog);
        this.finishedTimeFinder = new FinishedTimeFinder(raceLog);
        this.startTimeFinder = new StartTimeFinder(raceLogResolver, raceLog);
        this.raceLogListener = new WeakRaceLogChangedVisitor(this.raceLog, this);
        this.raceLog.addListener(this.raceLogListener);
        this.cachedIsIndividualRecallDisplayed = false;
    }

    @Override
    public void detach() {
        this.raceLog.removeListener(this.raceLogListener);
        this.changedListeners.removeAll();
    }

    @Override
    public void addChangedListener(RacingProcedureChangedListener listener) {
        this.changedListeners.addBaseListener(listener);
    }

    @Override
    public void removeChangedListener(RacingProcedureChangedListener listener) {
        this.changedListeners.remove(listener);
    }

    protected RacingProcedureChangedListeners<? extends RacingProcedureChangedListener> getChangedListeners() {
        return this.changedListeners;
    }

    protected abstract RacingProcedureChangedListeners<? extends RacingProcedureChangedListener> createChangedListenerContainer();

    @Override
    public RaceLog getRaceLog() {
        return this.raceLog;
    }

    @Override
    public void setStateEventScheduler(RaceStateEventScheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void triggerStateEventScheduling(ReadonlyRaceState state) {
        switch (state.getStatus()) {
            case SCHEDULED: 
            case STARTPHASE: {
                this.onStartTimeChanged(state);
                break;
            }
            case RUNNING: {
                if (!this.isIndividualRecallDisplayed()) break;
                this.rescheduleIndividualRecallTimeout(this.getIndividualRecallRemovalTime());
                break;
            }
        }
    }

    @Override
    public boolean isIndividualRecallDisplayed() {
        return this.cachedIsIndividualRecallDisplayed;
    }

    @Override
    public boolean isIndividualRecallDisplayed(TimePoint at) {
        if (this.hasIndividualRecall()) {
            return (Boolean)new IsIndividualRecallDisplayedAnalyzer(this.getRaceLog(), at).analyze();
        }
        return false;
    }

    @Override
    public TimePoint getIndividualRecallDisplayedTime() {
        if (this.hasIndividualRecall()) {
            return (TimePoint)this.recallDisplayedFinder.analyze();
        }
        return null;
    }

    @Override
    public TimePoint getIndividualRecallRemovalTime() {
        TimePoint removedEvent;
        TimePoint displayed = this.getIndividualRecallDisplayedTime();
        if (this.hasIndividualRecall() && (removedEvent = (TimePoint)this.recallRemovedFinder.analyze()) != null && (displayed == null || removedEvent.after(displayed))) {
            return removedEvent;
        }
        if (displayed != null) {
            TimePoint referenceTimePoint;
            TimePoint raceStartTime = ((StartTimeFinderResult)this.startTimeFinder.analyze()).getStartTime();
            if (raceStartTime != null) {
                referenceTimePoint = raceStartTime;
            } else {
                logger.warning("An individual recall was set but we don't have a start time set for the race; using individual recall set time " + displayed + " + timeout (" + individualRecallRemovalTimeout + ") for implicit termination of individual recall");
                referenceTimePoint = displayed;
            }
            return referenceTimePoint.plus(individualRecallRemovalTimeout);
        }
        return null;
    }

    @Override
    public void displayIndividualRecall(TimePoint displayTime) {
        this.raceLog.add(new RaceLogFlagEventImpl(displayTime, this.author, this.raceLog.getCurrentPassId(), Flags.XRAY, Flags.NONE, true));
    }

    @Override
    public void removeIndividualRecall(TimePoint timePoint) {
        this.raceLog.add(new RaceLogFlagEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), Flags.XRAY, Flags.NONE, false));
    }

    @Override
    public boolean processStateEvent(RaceStateEvent event) {
        switch (event.getEventName()) {
            case INDIVIDUAL_RECALL_TIMEOUT: {
                this.removeIndividualRecall(event.getTimePoint());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasIndividualRecall() {
        return this.configuration.hasIndividualRecall() == null ? this.hasIndividualRecallByDefault() : this.configuration.hasIndividualRecall().booleanValue();
    }

    @Override
    public boolean isResultEntryEnabled() {
        return this.configuration.isResultEntryEnabled() == null ? this.isResultEntryEnabledByDefault() : this.configuration.isResultEntryEnabled();
    }

    protected abstract Boolean isResultEntryEnabledByDefault();

    protected abstract boolean hasIndividualRecallByDefault();

    @Override
    public void eventAdded(RaceLogEvent event) {
        this.update();
    }

    protected void update() {
        boolean isRecallDisplayed = (Boolean)this.isRecallDisplayedAnalyzer.analyze();
        if (this.cachedIsIndividualRecallDisplayed != isRecallDisplayed) {
            this.cachedIsIndividualRecallDisplayed = isRecallDisplayed;
            if (this.cachedIsIndividualRecallDisplayed) {
                this.changedListeners.onIndividualRecallDisplayed(this);
                this.rescheduleIndividualRecallTimeout(this.getIndividualRecallRemovalTime());
            } else {
                this.changedListeners.onIndividualRecallRemoved(this);
                this.unscheduleStateEvent(RaceStateEvents.INDIVIDUAL_RECALL_TIMEOUT);
            }
        }
        this.changedListeners.onActiveFlagsChanged(this);
    }

    private void rescheduleIndividualRecallTimeout(TimePoint removalTime) {
        this.unscheduleStateEvent(RaceStateEvents.INDIVIDUAL_RECALL_TIMEOUT);
        this.scheduleStateEvents(new RaceStateEventImpl(removalTime, RaceStateEvents.INDIVIDUAL_RECALL_TIMEOUT));
    }

    protected void scheduleStateEvents(RaceStateEvent stateEvent) {
        this.scheduleStateEvents(Arrays.asList(stateEvent));
    }

    protected void scheduleStateEvents(Collection<RaceStateEvent> stateEvents) {
        if (this.scheduler != null) {
            this.scheduler.scheduleStateEvents(stateEvents);
        }
    }

    protected void unscheduleStateEvent(RaceStateEvents raceStateEventName) {
        if (this.scheduler != null) {
            this.scheduler.unscheduleStateEvent(raceStateEventName);
        }
    }

    @Override
    public RacingProcedureConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void onStartTimeChanged(ReadonlyRaceState state) {
        this.getChangedListeners().onActiveFlagsChanged(this);
        if (this.scheduler != null && state.getStartTime() != null) {
            this.scheduler.unscheduleAllEvents();
            this.scheduler.scheduleStateEvents(this.createStartStateEvents(state.getStartTime()));
        }
    }

    @Override
    public void onAdvancePass(ReadonlyRaceState state) {
        this.unscheduleAllEvents();
        this.update();
    }

    private void unscheduleAllEvents() {
        if (this.scheduler != null) {
            this.scheduler.unscheduleAllEvents();
        }
    }

    protected boolean isFinished(TimePoint at) {
        IsFinishedAnalyzer analyzer = new IsFinishedAnalyzer(this.raceLog, this.finishedTimeFinder, at);
        return (Boolean)analyzer.analyze();
    }

    protected boolean isInFinishingPhase(TimePoint at) {
        IsInFinishingPhaseAnalyzer analyzer = new IsInFinishingPhaseAnalyzer(this.raceLog, this.finishingTimeFinder, at);
        return (Boolean)analyzer.analyze();
    }

    protected TimePoint getFinishingTime() {
        return (TimePoint)this.finishingTimeFinder.analyze();
    }

    protected TimePoint getFinishedTime() {
        return (TimePoint)this.finishedTimeFinder.analyze();
    }
}

