/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.state.racingprocedure.gate.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogGateLineOpeningTimeEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.GateLineOpeningTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.PathfinderFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogGateLineOpeningTimeEventImpl;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogPathfinderEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.RaceStateEvent;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateEvents;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.FlagPoleState;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedureChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.RacingProcedurePrerequisite;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.gate.GateStartChangedListener;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.gate.GateStartRacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.gate.impl.GateLaunchTimePrerequisite;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.gate.impl.GateStartChangedListeners;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.gate.impl.PathfinderPrerequisite;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.BaseRacingProcedure;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.NoMorePrerequisite;
import com.sap.sailing.domain.abstractlog.race.state.racingprocedure.impl.RacingProcedureChangedListeners;
import com.sap.sailing.domain.base.configuration.procedures.GateStartConfiguration;
import com.sap.sailing.domain.common.racelog.FlagPole;
import com.sap.sailing.domain.common.racelog.Flags;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.Arrays;

public class GateStartRacingProcedureImpl
extends BaseRacingProcedure
implements GateStartRacingProcedure {
    private static final long startPhaseClassOverGolfUpInterval = 480000L;
    private static final long startPhasePapaUpInterval = 240000L;
    private static final long startPhasePapaDownInterval = 60000L;
    private final GateLineOpeningTimeFinder gateLineOpeningTimeAnalyzer;
    private final PathfinderFinder pathfinderAnalyzer;
    private RaceLogGateLineOpeningTimeEvent.GateLineOpeningTimes cachedGateLineOpeningTimes;
    private boolean gateLineOpeningTimesHasBeenSet;
    private String cachedPathfinder;

    public GateStartRacingProcedureImpl(RaceLog raceLog, AbstractLogEventAuthor author, GateStartConfiguration configuration, RaceLogResolver raceLogResolver) {
        super(raceLog, author, configuration, raceLogResolver);
        this.gateLineOpeningTimeAnalyzer = new GateLineOpeningTimeFinder(raceLog);
        this.pathfinderAnalyzer = new PathfinderFinder(raceLog);
        long defaultGolfDownTime = this.getDefaultGolfDownTime();
        this.cachedGateLineOpeningTimes = new RaceLogGateLineOpeningTimeEvent.GateLineOpeningTimes(240000L, defaultGolfDownTime);
        this.gateLineOpeningTimesHasBeenSet = false;
        this.update();
    }

    protected long getDefaultGolfDownTime() {
        Boolean flag = this.getConfiguration().hasAdditionalGolfDownTime();
        if (flag != null) {
            return flag != false ? 180000L : 0L;
        }
        return 0L;
    }

    @Override
    public RacingProcedureType getType() {
        return RacingProcedureType.GateStart;
    }

    @Override
    protected boolean hasIndividualRecallByDefault() {
        return false;
    }

    @Override
    protected Boolean isResultEntryEnabledByDefault() {
        return false;
    }

    @Override
    public RacingProcedurePrerequisite checkPrerequisitesForStart(TimePoint now, TimePoint startTime, RacingProcedurePrerequisite.FulfillmentFunction function) {
        if (startTime.before(now)) {
            if (this.getConfiguration().hasPathfinder() != null && this.getConfiguration().hasPathfinder().booleanValue() && this.getPathfinder() == null) {
                return new PathfinderPrerequisite(function, this, now, startTime);
            }
            if (!this.gateLineOpeningTimesHasBeenSet) {
                return new GateLaunchTimePrerequisite(function, this, now, startTime, this.getDefaultGolfDownTime());
            }
        }
        return new NoMorePrerequisite(function);
    }

    @Override
    public boolean isStartphaseActive(TimePoint startTime, TimePoint now) {
        if (now.before(startTime)) {
            long timeTillStart = startTime.minus(now.asMillis()).asMillis();
            return timeTillStart < 480000L;
        }
        return false;
    }

    @Override
    public void triggerStateEventScheduling(ReadonlyRaceState state) {
        switch (state.getStatus()) {
            case SCHEDULED: 
            case STARTPHASE: 
            case RUNNING: {
                this.rescheduleGateShutdownTime(state.getStartTime());
                break;
            }
        }
        super.triggerStateEventScheduling(state);
    }

    @Override
    public Iterable<RaceStateEvent> createStartStateEvents(TimePoint startTime) {
        return Arrays.asList(new RaceStateEventImpl(startTime.minus(480000L), RaceStateEvents.GATE_CLASS_OVER_GOLF_UP), new RaceStateEventImpl(startTime.minus(240000L), RaceStateEvents.GATE_PAPA_UP), new RaceStateEventImpl(startTime.minus(60000L), RaceStateEvents.GATE_PAPA_DOWN), new RaceStateEventImpl(startTime, RaceStateEvents.START));
    }

    @Override
    public boolean processStateEvent(RaceStateEvent event) {
        switch (event.getEventName()) {
            case START: {
                if (!this.gateLineOpeningTimesHasBeenSet) {
                    this.setGateLineOpeningTimes(event.getTimePoint(), this.cachedGateLineOpeningTimes.getGateLaunchStopTime(), this.cachedGateLineOpeningTimes.getGolfDownTime());
                }
                this.rescheduleGateShutdownTime(event.getTimePoint());
                return true;
            }
            case GATE_CLASS_OVER_GOLF_UP: 
            case GATE_PAPA_UP: 
            case GATE_PAPA_DOWN: 
            case GATE_SHUTDOWN: {
                this.getChangedListeners().onActiveFlagsChanged(this);
                return true;
            }
        }
        return super.processStateEvent(event);
    }

    @Override
    public FlagPoleState getActiveFlags(TimePoint startTime, TimePoint now) {
        Flags classFlag = this.getConfiguration().getClassFlag() != null ? this.getConfiguration().getClassFlag() : Flags.CLASS;
        TimePoint gateShutdownTime = this.getGateShutdownTimePoint(startTime);
        if (now.before(startTime.minus(480000L))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, Flags.GOLF, false), new FlagPole(Flags.PAPA, false)), null, Arrays.asList(new FlagPole(classFlag, Flags.GOLF, true), new FlagPole(Flags.PAPA, false)), startTime.minus(480000L));
        }
        if (now.before(startTime.minus(240000L))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, Flags.GOLF, true), new FlagPole(Flags.PAPA, false)), startTime.minus(480000L), Arrays.asList(new FlagPole(classFlag, Flags.GOLF, true), new FlagPole(Flags.PAPA, true)), startTime.minus(240000L));
        }
        if (now.before(startTime.minus(60000L))) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, Flags.GOLF, true), new FlagPole(Flags.PAPA, true)), startTime.minus(240000L), Arrays.asList(new FlagPole(classFlag, Flags.GOLF, true), new FlagPole(Flags.PAPA, false)), startTime.minus(60000L));
        }
        if (now.before(startTime)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(classFlag, Flags.GOLF, true), new FlagPole(Flags.PAPA, false)), startTime.minus(60000L), Arrays.asList(new FlagPole(classFlag, false), new FlagPole(Flags.GOLF, true)), startTime);
        }
        if (now.before(gateShutdownTime)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.GOLF, true)), startTime, Arrays.asList(new FlagPole(Flags.GOLF, false)), gateShutdownTime);
        }
        if (this.isFinished(now)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.BLUE, false)), this.getFinishedTime());
        }
        if (this.isInFinishingPhase(now)) {
            return new FlagPoleState(Arrays.asList(new FlagPole(Flags.BLUE, true)), this.getFinishingTime(), Arrays.asList(new FlagPole(Flags.BLUE, false)), null);
        }
        return new FlagPoleState(Arrays.asList(new FlagPole(Flags.GOLF, false)), gateShutdownTime);
    }

    @Override
    public TimePoint getGateLaunchStopTimePoint(TimePoint startTime) {
        return startTime.plus(this.getGateLaunchStopTime());
    }

    @Override
    public TimePoint getGateShutdownTimePoint(TimePoint startTime) {
        return this.getGateLaunchStopTimePoint(startTime).plus(this.getGolfDownTime());
    }

    @Override
    public long getGateLaunchStopTime() {
        return this.cachedGateLineOpeningTimes.getGateLaunchStopTime();
    }

    @Override
    public long getGolfDownTime() {
        return this.cachedGateLineOpeningTimes.getGolfDownTime();
    }

    @Override
    public void setGateLineOpeningTimes(TimePoint now, long gateLaunchStopTime, long golfDownTime) {
        this.raceLog.add(new RaceLogGateLineOpeningTimeEventImpl(now, this.author, this.raceLog.getCurrentPassId(), gateLaunchStopTime, golfDownTime));
    }

    @Override
    public String getPathfinder() {
        return this.cachedPathfinder;
    }

    @Override
    public void setPathfinder(TimePoint timePoint, String sailingId) {
        this.raceLog.add(new RaceLogPathfinderEventImpl(timePoint, this.author, this.raceLog.getCurrentPassId(), sailingId));
    }

    @Override
    protected RacingProcedureChangedListeners<? extends RacingProcedureChangedListener> createChangedListenerContainer() {
        return new GateStartChangedListeners();
    }

    protected GateStartChangedListeners getChangedListeners() {
        return (GateStartChangedListeners)super.getChangedListeners();
    }

    @Override
    public void addChangedListener(GateStartChangedListener listener) {
        this.getChangedListeners().add(listener);
    }

    @Override
    protected void update() {
        String pathfinder;
        RaceLogGateLineOpeningTimeEvent.GateLineOpeningTimes gateLineOpeningTimes = (RaceLogGateLineOpeningTimeEvent.GateLineOpeningTimes)((Object)this.gateLineOpeningTimeAnalyzer.analyze());
        if (!(gateLineOpeningTimes == null || gateLineOpeningTimes.equals((Object)this.cachedGateLineOpeningTimes) && this.gateLineOpeningTimesHasBeenSet)) {
            this.cachedGateLineOpeningTimes = gateLineOpeningTimes;
            this.gateLineOpeningTimesHasBeenSet = true;
            this.getChangedListeners().onGateLaunchTimeChanged(this);
        }
        if (!Util.equalsWithNull((Object)this.cachedPathfinder, (Object)(pathfinder = (String)this.pathfinderAnalyzer.analyze()))) {
            this.cachedPathfinder = pathfinder;
            this.getChangedListeners().onPathfinderChanged(this);
        }
        super.update();
    }

    @Override
    public GateStartConfiguration getConfiguration() {
        return (GateStartConfiguration)super.getConfiguration();
    }

    private void rescheduleGateShutdownTime(TimePoint startTime) {
        this.unscheduleStateEvent(RaceStateEvents.GATE_SHUTDOWN);
        if (startTime != null) {
            this.scheduleStateEvents(new RaceStateEventImpl(this.getGateShutdownTimePoint(startTime), RaceStateEvents.GATE_SHUTDOWN));
        }
    }
}

