/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.race.analyzing.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogCourseDesignChangedEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogAnalyzer;
import com.sap.sailing.domain.base.CourseBase;

public class LastPublishedCourseDesignFinder
extends RaceLogAnalyzer<CourseBase> {
    private final boolean onlyCoursesWithValidWaypointList;

    public LastPublishedCourseDesignFinder(RaceLog raceLog, boolean onlyCoursesWithValidWaypointList) {
        super(raceLog);
        this.onlyCoursesWithValidWaypointList = onlyCoursesWithValidWaypointList;
    }

    @Override
    protected CourseBase performAnalysis() {
        for (RaceLogEvent event : this.getAllEventsDescending()) {
            if (!(event instanceof RaceLogCourseDesignChangedEvent)) continue;
            RaceLogCourseDesignChangedEvent courseDesignEvent = (RaceLogCourseDesignChangedEvent)event;
            if (this.onlyCoursesWithValidWaypointList && courseDesignEvent.getCourseDesignerMode() != null && !courseDesignEvent.getCourseDesignerMode().isWaypointSequenceValid()) continue;
            return courseDesignEvent.getCourseDesign();
        }
        return null;
    }
}

