/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.orc;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.BaseLogAnalyzer;
import com.sap.sailing.domain.abstractlog.orc.BaseORCCertificateAssignmentAnalyzer;
import com.sap.sailing.domain.abstractlog.orc.ORCCertificateAssignmentEvent;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class BaseORCCertificateAssignmentFinder<LogT extends AbstractLog<EventT, VisitorT>, VisitorT, EventT extends AbstractLogEvent<VisitorT>>
extends BaseLogAnalyzer<LogT, EventT, VisitorT, Map<Boat, ORCCertificate>> {
    private static final Logger logger = Logger.getLogger(BaseORCCertificateAssignmentFinder.class.getName());
    private final Map<Serializable, Boat> boatsById;

    public BaseORCCertificateAssignmentFinder(LogT log, Map<Serializable, Boat> boatsById) {
        super(log);
        this.boatsById = boatsById;
    }

    @Override
    protected Map<Boat, ORCCertificate> performAnalysis() {
        HashMap<Boat, ORCCertificate> result = new HashMap<Boat, ORCCertificate>();
        for (ORCCertificateAssignmentEvent e : ((Map)new BaseORCCertificateAssignmentAnalyzer(this.log).analyze()).values()) {
            Boat boat = this.boatsById.get(e.getBoatId());
            if (boat != null) {
                ORCCertificate certificate = e.getCertificate();
                result.put(boat, certificate);
                continue;
            }
            logger.warning("Unable to find boat with ID " + e.getBoatId() + " for which an ORC certificate with sail number " + e.getCertificate() + " is defined. Certificate is ignored.");
        }
        return result;
    }
}

