/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.impl;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.RevokeEvent;
import com.sap.sailing.domain.abstractlog.impl.AbstractLogEventImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.Serializable;
import java.util.UUID;

public abstract class RevokeEventImpl<VisitorT>
extends AbstractLogEventImpl<VisitorT>
implements RevokeEvent<VisitorT> {
    private static final long serialVersionUID = -30864810737555657L;
    private final Serializable revokedEventId;
    private final String reason;
    private final String revokedEventType;
    private final String revokedEventShortInfo;

    public RevokeEventImpl(AbstractLogEventAuthor author, AbstractLogEvent<?> toRevoke, String reason) {
        this(MillisecondsTimePoint.now(), MillisecondsTimePoint.now(), author, UUID.randomUUID(), toRevoke.getId(), toRevoke.getClass().getName(), toRevoke.getShortInfo(), reason);
    }

    public RevokeEventImpl(TimePoint createdAt, TimePoint logicalTimePoint, AbstractLogEventAuthor author, Serializable pId, Serializable revokedEventId, String revokedEventType, String revokedEventShortInfo, String reason) {
        super(createdAt, logicalTimePoint, author, pId);
        this.revokedEventId = revokedEventId;
        this.reason = reason;
        this.revokedEventType = revokedEventType;
        this.revokedEventShortInfo = revokedEventShortInfo;
    }

    @Override
    public Serializable getRevokedEventId() {
        return this.revokedEventId;
    }

    @Override
    public String getShortInfo() {
        if (this.revokedEventShortInfo == null) {
            return "No event revoked";
        }
        return "Revoked " + this.revokedEventType + "(" + this.revokedEventShortInfo + ")" + this.reason == null ? "" : " due to " + this.reason;
    }

    @Override
    public String getRevokedEventType() {
        return this.revokedEventType;
    }

    @Override
    public String getRevokedEventShortInfo() {
        return this.revokedEventShortInfo;
    }

    @Override
    public String getReason() {
        return this.reason;
    }
}

