/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.abstractlog.impl;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.Revokable;
import com.sap.sailing.domain.abstractlog.RevokeEvent;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogEventComparator;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sailing.domain.shared.tracking.impl.PartialNavigableSetView;
import com.sap.sailing.domain.shared.tracking.impl.TrackImpl;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.shared.util.impl.ArrayListNavigableSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractLogImpl<EventT extends AbstractLogEvent<VisitorT>, VisitorT>
extends TrackImpl<EventT>
implements AbstractLog<EventT, VisitorT> {
    private static final long serialVersionUID = -176745401321893502L;
    private static final String DefaultLockName = String.valueOf(AbstractLogImpl.class.getName()) + ".lock";
    private static final Logger logger = Logger.getLogger(AbstractLogImpl.class.getName());
    private Set<Serializable> revokedEventIds = new HashSet<Serializable>();
    private transient Map<UUID, Set<EventT>> eventsDeliveredToClient = new HashMap<UUID, Set<EventT>>();
    private Map<Serializable, EventT> eventsById = new HashMap<Serializable, EventT>();
    private final Serializable id;
    private transient Set<VisitorT> listeners = new HashSet<VisitorT>();

    public AbstractLogImpl(Serializable identifier, Comparator<Timed> comparator) {
        this(DefaultLockName, identifier, comparator);
    }

    public AbstractLogImpl(String nameForReadWriteLock, Serializable identifier, Comparator<Timed> comparator) {
        super((ArrayListNavigableSet<Timed>)new ArrayListNavigableSet(comparator), nameForReadWriteLock);
        this.id = identifier;
    }

    public Serializable getId() {
        return this.id;
    }

    protected void onSuccessfulAdd(EventT event, boolean notifyListeners) {
        this.revokeIfNecessary(event);
        this.eventsById.put(event.getId(), event);
        if (notifyListeners) {
            this.notifyListenersAboutReceive(event);
        }
    }

    @Override
    protected boolean add(EventT event, boolean notifyListeners) {
        boolean isAdded = false;
        this.lockForWrite();
        try {
            isAdded = this.getInternalRawFixes().add(event);
        }
        finally {
            this.unlockAfterWrite();
        }
        if (isAdded) {
            logger.finer(String.format("%s (%s) was added to log %s.", event, event.getClass().getName(), this.getId()));
            this.onSuccessfulAdd(event, notifyListeners);
        } else {
            logger.finer(String.format("%s (%s) was not added to race log %s because it already existed there.", event, event.getClass().getName(), this.getId()));
        }
        return isAdded;
    }

    @Override
    public boolean add(EventT event) {
        return this.add(event, true);
    }

    @Override
    public boolean load(EventT event) {
        return this.add(event, false);
    }

    private void revokeIfNecessary(EventT newEvent) {
        if (newEvent instanceof RevokeEvent) {
            RevokeEvent revokeEvent = (RevokeEvent)newEvent;
            try {
                this.checkIfSuccessfullyRevokes(revokeEvent);
                this.lockForWrite();
                try {
                    this.revokedEventIds.add(revokeEvent.getRevokedEventId());
                }
                finally {
                    this.unlockAfterWrite();
                }
            }
            catch (NotRevokableException e) {
                logger.log(Level.WARNING, e.getMessage());
            }
        }
    }

    private void checkIfSuccessfullyRevokes(RevokeEvent<?> revokeEvent) throws NotRevokableException {
        EventT revokedEvent;
        this.lockForRead();
        try {
            revokedEvent = this.getEventById(revokeEvent.getRevokedEventId());
        }
        finally {
            this.unlockAfterRead();
        }
        if (revokedEvent == null) {
            logger.warning("RevokeEvent for " + revokeEvent.getShortInfo() + " added, that refers to non-existent event to be revoked. Could also happen that the revoke event is before the event to be revoked.");
        } else {
            if (!(revokedEvent instanceof Revokable)) {
                throw new NotRevokableException("RevokeEvent trying to revoke non-revokable event");
            }
            if (revokeEvent.getAuthor().getPriority() > revokedEvent.getAuthor().getPriority()) {
                throw new NotRevokableException("RevokeEvent does not have sufficient priority");
            }
        }
    }

    @Override
    public Iterable<EventT> add(EventT event, UUID clientId) {
        this.add(event);
        return this.getEventsToDeliver(clientId, event);
    }

    @Override
    public Iterable<EventT> getEventsToDeliver(UUID clientId) {
        return this.getEventsToDeliver(clientId, null);
    }

    protected Iterable<EventT> getEventsToDeliver(UUID clientId, EventT suppressedEvent) {
        LinkedHashSet stillToDeliverToClient;
        this.lockForRead();
        try {
            stillToDeliverToClient = new LinkedHashSet(this.getInternalRawFixes());
        }
        finally {
            this.unlockAfterRead();
        }
        stillToDeliverToClient.remove(suppressedEvent);
        Set<EventT> deliveredToClient = this.eventsDeliveredToClient.get(clientId);
        if (deliveredToClient != null) {
            stillToDeliverToClient.removeAll(deliveredToClient);
        } else {
            deliveredToClient = new HashSet<EventT>();
            this.eventsDeliveredToClient.put(clientId, deliveredToClient);
        }
        deliveredToClient.addAll(stillToDeliverToClient);
        deliveredToClient.add(suppressedEvent);
        return stillToDeliverToClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListenersAboutReceive(EventT event) {
        HashSet<VisitorT> workingListeners = new HashSet<VisitorT>();
        Set<VisitorT> set = this.listeners;
        synchronized (set) {
            workingListeners.addAll(this.listeners);
        }
        for (Object listener : workingListeners) {
            try {
                event.accept(listener);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "RaceLogEventVisitor " + listener + " threw exception " + t.getMessage(), t);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getFirstRawFix() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(VisitorT listener) {
        Set<VisitorT> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Object listener) {
        Set<VisitorT> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.listeners = new HashSet<VisitorT>();
        this.eventsDeliveredToClient = new HashMap<UUID, Set<EventT>>();
        if (this.eventsById == null) {
            this.eventsById = new HashMap<Serializable, EventT>();
            this.lockForRead();
            try {
                for (AbstractLogEvent event : this.getRawFixes()) {
                    this.eventsById.put(event.getId(), event);
                }
            }
            finally {
                this.unlockAfterRead();
            }
        }
        if (this.revokedEventIds == null) {
            this.revokedEventIds = new HashSet<Serializable>();
            this.lockForRead();
            try {
                for (AbstractLogEvent event : this.getRawFixes()) {
                    if (!(event instanceof RevokeEvent)) continue;
                    this.revokedEventIds.add(((RevokeEvent)event).getRevokedEventId());
                }
            }
            finally {
                this.unlockAfterRead();
            }
        }
    }

    @Override
    public Iterable<EventT> getRawFixesDescending() {
        return this.getRawFixes().descendingSet();
    }

    @Override
    public Iterable<EventT> getFixesDescending() {
        return this.getFixes().descendingSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashSet<VisitorT> removeAllListeners() {
        Set<VisitorT> set = this.listeners;
        synchronized (set) {
            HashSet<VisitorT> clonedListeners = new HashSet<VisitorT>(this.listeners);
            this.listeners = new HashSet<VisitorT>();
            return clonedListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAllListeners(Iterable<VisitorT> listeners) {
        Iterable<VisitorT> iterable = listeners;
        synchronized (iterable) {
            Util.addAll(listeners, this.listeners);
        }
    }

    @Override
    public Iterable<VisitorT> getAllListeners() {
        return this.listeners;
    }

    @Override
    public Iterable<EventT> getRawFixes(UUID clientId) {
        this.assertReadLock();
        Iterable result = this.getRawFixes();
        Set<EventT> edtc = this.eventsDeliveredToClient.get(clientId);
        if (edtc == null) {
            edtc = new HashSet<EventT>();
            this.eventsDeliveredToClient.put(clientId, edtc);
        }
        edtc.addAll((Collection<EventT>)result);
        return result;
    }

    @Override
    public EventT getEventById(Serializable id) {
        this.assertReadLock();
        return (EventT)((AbstractLogEvent)this.eventsById.get(id));
    }

    @Override
    public NavigableSet<EventT> getUnrevokedEvents() {
        return new FilteredPartialNavigableSetView(super.getInternalFixes(), new RevokedValidator(this.revokedEventIds));
    }

    @Override
    public NavigableSet<EventT> getUnrevokedEventsDescending() {
        return new FilteredPartialNavigableSetView(super.getInternalFixes().descendingSet(), new RevokedValidator(this.revokedEventIds));
    }

    @Override
    public void merge(AbstractLog<EventT, VisitorT> other) {
        this.lockForWrite();
        other.lockForRead();
        try {
            RaceLogEventComparator comparator = new RaceLogEventComparator();
            Iterator thisIter = this.getRawFixes().iterator();
            Iterator otherIter = other.getRawFixes().iterator();
            AbstractLogEvent thisEvent = null;
            AbstractLogEvent otherEvent = null;
            while (otherIter.hasNext() || otherEvent != null) {
                if (thisEvent == null && thisIter.hasNext()) {
                    thisEvent = (AbstractLogEvent)thisIter.next();
                }
                if (otherEvent == null) {
                    otherEvent = (AbstractLogEvent)otherIter.next();
                }
                if (thisEvent == null) {
                    this.add((EventT)otherEvent);
                    otherEvent = null;
                    continue;
                }
                int comparison = comparator.compare(thisEvent, otherEvent);
                if (comparison < 0) {
                    thisEvent = null;
                    continue;
                }
                if (comparison == 0) {
                    thisEvent = null;
                    otherEvent = null;
                    continue;
                }
                this.add((EventT)otherEvent);
                otherEvent = null;
            }
        }
        finally {
            other.unlockAfterRead();
            this.unlockAfterWrite();
        }
    }

    @Override
    public void revokeEvent(AbstractLogEventAuthor author, EventT toRevoke) throws NotRevokableException {
        this.revokeEvent(author, toRevoke, null);
    }

    protected abstract EventT createRevokeEvent(AbstractLogEventAuthor var1, EventT var2, String var3);

    @Override
    public void revokeEvent(AbstractLogEventAuthor author, EventT toRevoke, String reason) throws NotRevokableException {
        if (toRevoke == null) {
            throw new NotRevokableException("Received null as event to revoke");
        }
        EventT revokeEvent = this.createRevokeEvent(author, toRevoke, reason);
        this.checkIfSuccessfullyRevokes((RevokeEvent)revokeEvent);
        this.add(revokeEvent);
    }

    public static class FilteredPartialNavigableSetView<T>
    extends PartialNavigableSetView<T> {
        private final NavigableSetViewValidator<T> validator;

        public FilteredPartialNavigableSetView(NavigableSet<T> set, NavigableSetViewValidator<T> validator) {
            super(set);
            if (validator == null) {
                throw new NullPointerException();
            }
            this.validator = validator;
        }

        @Override
        protected boolean isValid(T t) {
            return this.validator.isValid(t);
        }
    }

    @FunctionalInterface
    public static interface NavigableSetViewValidator<T> {
        public boolean isValid(T var1);
    }

    public static class RevokedValidator<EventT extends AbstractLogEvent<VisitorT>, VisitorT>
    implements NavigableSetViewValidator<EventT> {
        final Set<Serializable> revokedEventIds;

        public RevokedValidator(Set<Serializable> revokedEventIds) {
            this.revokedEventIds = revokedEventIds;
        }

        @Override
        public boolean isValid(EventT item) {
            return !(item instanceof RevokeEvent) && !this.revokedEventIds.contains(item.getId());
        }
    }
}

