/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.shared.server.impl;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.coursetemplate.CourseTemplate;
import com.sap.sailing.domain.coursetemplate.MarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.shared.persistence.PersistenceFactory;
import com.sap.sailing.shared.server.SharedSailingData;
import com.sap.sailing.shared.server.impl.ReplicatingSharedSailingData;
import com.sap.sailing.shared.server.impl.SharedSailingDataImpl;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.osgi.CachedOsgiTypeBasedServiceFinderFactory;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.replication.Replicable;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.util.ClearStateTestSupport;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static BundleContext context;
    private CachedOsgiTypeBasedServiceFinderFactory serviceFinderFactory;
    private Set<ServiceRegistration<?>> registrations = new HashSet();
    private FullyInitializedReplicableTracker<SecurityService> securityServiceTracker;
    private SharedSailingDataImpl sharedSailingData;

    public void start(BundleContext context) throws Exception {
        Activator.context = context;
        this.securityServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
        this.serviceFinderFactory = new CachedOsgiTypeBasedServiceFinderFactory(context);
        this.sharedSailingData = new SharedSailingDataImpl(PersistenceFactory.INSTANCE.getDefaultDomainObjectFactory((TypeBasedServiceFinderFactory)this.serviceFinderFactory), PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory((TypeBasedServiceFinderFactory)this.serviceFinderFactory), (TypeBasedServiceFinderFactory)this.serviceFinderFactory, this.securityServiceTracker);
        this.registrations.add(context.registerService(SharedSailingData.class, (Object)this.sharedSailingData, null));
        this.registrations.add(context.registerService(ReplicatingSharedSailingData.class, (Object)this.sharedSailingData, null));
        this.registrations.add(context.registerService(ClearStateTestSupport.class, (Object)this.sharedSailingData, null));
        Hashtable<String, String> replicableServiceProperties = new Hashtable<String, String>();
        ((Dictionary)replicableServiceProperties).put("ID", this.sharedSailingData.getId().toString());
        this.registrations.add(context.registerService(Replicable.class, (Object)this.sharedSailingData, replicableServiceProperties));
        new Thread(() -> this.migrateOwnerships()).start();
    }

    private void migrateOwnerships() {
        try {
            SecurityService securityService = (SecurityService)this.securityServiceTracker.getInitializedService(0L);
            for (CourseTemplate courseTemplate : this.sharedSailingData.getAllCourseTemplates()) {
                securityService.migrateOwnership((WithQualifiedObjectIdentifier)courseTemplate);
            }
            securityService.assumeOwnershipMigrated(SecuredDomainType.COURSE_TEMPLATE.getName());
            for (MarkProperties markProperties : this.sharedSailingData.getAllMarkProperties()) {
                securityService.migrateOwnership((WithQualifiedObjectIdentifier)markProperties);
            }
            securityService.assumeOwnershipMigrated(SecuredDomainType.MARK_PROPERTIES.getName());
            for (MarkRole markRole : this.sharedSailingData.getAllMarkRoles()) {
                securityService.migrateOwnership((WithQualifiedObjectIdentifier)markRole);
            }
            securityService.assumeOwnershipMigrated(SecuredDomainType.MARK_ROLE.getName());
            for (MarkTemplate markTemplate : this.sharedSailingData.getAllMarkTemplates()) {
                securityService.migrateOwnership((WithQualifiedObjectIdentifier)markTemplate);
            }
            securityService.assumeOwnershipMigrated(SecuredDomainType.MARK_TEMPLATE.getName());
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, "Interrupted while trying to migrate ownership of shared sailing objects", e);
        }
    }

    public static BundleContext getContext() {
        return context;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serviceFinderFactory != null) {
            this.serviceFinderFactory.close();
            this.serviceFinderFactory = null;
        }
        for (ServiceRegistration<?> reg : this.registrations) {
            reg.unregister();
        }
        this.registrations.clear();
        this.sharedSailingData = null;
        this.securityServiceTracker.close();
        this.securityServiceTracker = null;
    }
}

