/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.racelogtracking.impl.TrackFileImportDeviceIdentifierJsonHandler;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.shared.persistence.device.DeviceIdentifierMongoHandler;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TransformationException;
import com.sap.sse.common.Util;
import java.util.UUID;
import org.bson.Document;

public class TrackFileImportDeviceIdentifierMongoHandler
implements DeviceIdentifierMongoHandler {
    public DeviceIdentifier deserialize(Object serialized, String type, String stringRepresentation) throws TransformationException {
        Document dbObject = (Document)serialized;
        UUID uuid = UUID.fromString((String)dbObject.get((Object)Fields.UUID.name()));
        String fileName = (String)dbObject.get((Object)Fields.FILE_NAME.name());
        String trackName = (String)dbObject.get((Object)Fields.TRACK_NAME.name());
        TimePoint uploaded = TrackFileImportDeviceIdentifierJsonHandler.loadTimePoint(dbObject.get((Object)Fields.UPLOADED_MILLIS.name()));
        return new TrackFileImportDeviceIdentifierImpl(uuid, stringRepresentation, fileName, trackName, uploaded);
    }

    public Util.Pair<String, Document> serialize(DeviceIdentifier deviceIdentifier) throws TransformationException {
        TrackFileImportDeviceIdentifier id = TrackFileImportDeviceIdentifierImpl.cast((DeviceIdentifier)deviceIdentifier);
        Document result = new Document();
        result.put(Fields.UUID.name(), (Object)id.getId().toString());
        result.put(Fields.FILE_NAME.name(), (Object)id.getFileName());
        result.put(Fields.TRACK_NAME.name(), (Object)id.getTrackName());
        result.put(Fields.UPLOADED_MILLIS.name(), (Object)TrackFileImportDeviceIdentifierJsonHandler.storeTimePoint(id.getUploadedAt()));
        return new Util.Pair((Object)"FILE", (Object)result);
    }

    private static enum Fields {
        UUID,
        FILE_NAME,
        TRACK_NAME,
        UPLOADED_MILLIS;

    }
}

