/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl;

import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogRaceTracker;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceTracker;

public class RaceLogRacesHandle
implements RaceHandle {
    private final RaceLogRaceTracker tracker;

    public RaceLogRacesHandle(RaceLogRaceTracker tracker) {
        this.tracker = tracker;
    }

    public Regatta getRegatta() {
        return this.tracker.getRegatta();
    }

    public RaceDefinition getRace() {
        return this.getRace(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RaceDefinition getRace(long timeoutInMilliseconds) {
        long start = System.currentTimeMillis();
        RaceDefinition result = this.tracker.getRace();
        boolean interrupted = false;
        RaceLogRaceTracker raceLogRaceTracker = this.tracker;
        synchronized (raceLogRaceTracker) {
            while (true) {
                if (timeoutInMilliseconds != -1L) {
                    if (System.currentTimeMillis() - start >= timeoutInMilliseconds) return result;
                }
                if (interrupted) return result;
                if (result != null) {
                    return result;
                }
                try {
                    if (timeoutInMilliseconds == -1L) {
                        ((Object)((Object)this.tracker)).wait();
                    } else {
                        long timeToWait = timeoutInMilliseconds - (System.currentTimeMillis() - start);
                        if (timeToWait > 0L) {
                            ((Object)((Object)this.tracker)).wait(timeToWait);
                        }
                    }
                    result = this.tracker.getRace();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
    }

    public DynamicTrackedRegatta getTrackedRegatta() {
        return this.tracker.getTrackedRegatta();
    }

    public RaceTracker getRaceTracker() {
        return this.tracker;
    }
}

