/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.racelogtracking.impl;

import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.common.MailInvitationType;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogTrackingI18n;
import com.sap.sailing.domain.racelogtracking.impl.RaceLogTrackingInvitationMailBuilder;
import com.sap.sse.common.media.MediaTagConstants;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.util.impl.NonGwtUrlHelper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class BranchIORaceLogTrackingInvitationMailBuilder
extends RaceLogTrackingInvitationMailBuilder {
    private static final Logger LOG = Logger.getLogger(BranchIORaceLogTrackingInvitationMailBuilder.class.getName());
    private final MailInvitationType invitationType;

    BranchIORaceLogTrackingInvitationMailBuilder(Locale locale, MailInvitationType invitationType) {
        super(locale);
        this.invitationType = invitationType;
    }

    @Override
    BranchIORaceLogTrackingInvitationMailBuilder addEventLogo(Event event) {
        List imagesWithTag = event.findImagesWithTag(MediaTagConstants.LOGO.getName());
        if (imagesWithTag != null && !imagesWithTag.isEmpty()) {
            ImageDescriptor imageDescriptor = (ImageDescriptor)imagesWithTag.get(0);
            String logoUrl = imageDescriptor.getURL().toString();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream is = new URL(logoUrl).openStream();){
                    BufferedImage image = ImageIO.read(is);
                    ImageIO.write((RenderedImage)image, "png", baos);
                    this.insertImage(baos.toByteArray(), "logo", logoUrl);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error while getting event image for invitation mail", e);
            }
        }
        return this;
    }

    @Override
    public RaceLogTrackingInvitationMailBuilder addSailInsightDeeplink(String checkinUrl, String legacy1, String legacy2) {
        String deeplink = String.format("%s?%s=%s", this.getSailInsightBranchIO(), "checkinUrl", NonGwtUrlHelper.INSTANCE.encodeQueryString(checkinUrl));
        this.addDeeplink(deeplink, RaceLogTrackingI18n::register);
        return this;
    }

    @Override
    public RaceLogTrackingInvitationMailBuilder addBuoyPingerDeeplink(String checkinUrl, String legacy1, String legacy2) {
        String deeplink = String.format("%s?%s=%s", this.getBouyPingerBranchIO(), "checkinUrl", NonGwtUrlHelper.INSTANCE.encodeQueryString(checkinUrl));
        this.addDeeplink(deeplink, RaceLogTrackingI18n::register);
        return this;
    }

    private void addDeeplink(String url, Function<Locale, String> textFactory) {
        this.html.append("<table border=\"0\" cellspacing=\"20px\" cellpadding=\"0px\">");
        this.html.append("<tr>");
        this.html.append("<td>");
        this.addHtmlLink(url, textFactory);
        this.html.append("</td>");
        this.addTextLink(url, textFactory);
        this.html.append("</tr>");
        this.html.append("</table>");
    }

    @Override
    protected void addIntroductoryText(String appName, String invitee) {
        String introText = RaceLogTrackingI18n.followBranchDeeplink(this.locale, appName, invitee);
        this.html.append("<p>").append(introText).append("</p>");
        this.text.append(introText).append(" ").append(invitee).append("\r\n").append("\r\n");
    }

    private void addHtmlLink(String url, Function<Locale, String> textFactory) {
        String anchor = "<a href=\"" + url + "\" style=\"color:#fff; text-decoration:none;\">";
        this.html.append(anchor);
        this.html.append("<table width=\"100%\" style=\"background-color: #337ab7; color:#fff;\"><tr>");
        this.html.append("<td style=\"padding: 15px; text-align: center; color:#fff;\">");
        this.html.append(anchor);
        this.html.append(textFactory.apply(this.locale));
        this.html.append("</a>");
        this.html.append("</td>");
        this.html.append("</tr></table>");
        this.html.append("</a>");
    }

    protected String getSailInsightBranchIO() {
        return this.invitationType.getBranchIOinviteURL();
    }

    protected String getBouyPingerBranchIO() {
        return "https://buoypinger-app.sapsailing.com/invite";
    }
}

