/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.interfaces.impl;

import com.sap.sse.replication.OperationExecutionListener;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.OperationWithResultWithIdWrapper;
import com.sap.sse.replication.OperationsToMasterSender;
import com.sap.sse.replication.OperationsToMasterSendingQueue;
import com.sap.sse.replication.ReplicableWithObjectInputStream;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.util.ClearStateTestSupport;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractReplicableWithObjectInputStream<S, O extends OperationWithResult<S, ?>>
implements ReplicableWithObjectInputStream<S, O>,
ClearStateTestSupport {
    private OperationsToMasterSendingQueue unsentOperationsToMasterSender;
    private ReplicationMasterDescriptor replicatingFromMaster;
    private final Set<OperationWithResult<S, ?>> operationsSentToMasterForReplication;
    private volatile boolean currentlyFillingFromInitialLoad = false;
    private ThreadLocal<Boolean> currentlyApplyingOperationReceivedFromMaster = ThreadLocal.withInitial(() -> false);
    private final ConcurrentMap<OperationExecutionListener<S>, OperationExecutionListener<S>> operationExecutionListeners;

    public AbstractReplicableWithObjectInputStream() {
        this.operationsSentToMasterForReplication = new HashSet();
        this.operationExecutionListeners = new ConcurrentHashMap<OperationExecutionListener<S>, OperationExecutionListener<S>>();
    }

    @Override
    public void setUnsentOperationToMasterSender(OperationsToMasterSendingQueue service) {
        this.unsentOperationsToMasterSender = service;
    }

    public <S1, O1 extends OperationWithResult<S1, ?>, T1> void scheduleForSending(O1 operationWithResult, OperationsToMasterSender<S1, O1> sender) {
        if (this.unsentOperationsToMasterSender != null) {
            this.unsentOperationsToMasterSender.scheduleForSending(operationWithResult, sender);
        }
    }

    public void clearState() throws Exception {
        this.clearReplicaState();
    }

    public Serializable getId() {
        String result = this.getClass().getName();
        assert (!result.equals("***"));
        return result;
    }

    @Override
    public void addOperationExecutionListener(OperationExecutionListener<S> listener) {
        this.operationExecutionListeners.put(listener, listener);
    }

    @Override
    public void removeOperationExecutionListener(OperationExecutionListener<S> listener) {
        this.operationExecutionListeners.remove(listener);
    }

    @Override
    public boolean isCurrentlyFillingFromInitialLoad() {
        return this.currentlyFillingFromInitialLoad;
    }

    @Override
    public void setCurrentlyFillingFromInitialLoad(boolean currentlyFillingFromInitialLoad) {
        this.currentlyFillingFromInitialLoad = currentlyFillingFromInitialLoad;
    }

    @Override
    public boolean isCurrentlyApplyingOperationReceivedFromMaster() {
        return this.currentlyApplyingOperationReceivedFromMaster.get();
    }

    @Override
    public void setCurrentlyApplyingOperationReceivedFromMaster(boolean currentlyApplyingOperationReceivedFromMaster) {
        this.currentlyApplyingOperationReceivedFromMaster.set(currentlyApplyingOperationReceivedFromMaster);
    }

    @Override
    public Iterable<OperationExecutionListener<S>> getOperationExecutionListeners() {
        return this.operationExecutionListeners.keySet();
    }

    @Override
    public ReplicationMasterDescriptor getMasterDescriptor() {
        return this.replicatingFromMaster;
    }

    @Override
    public void startedReplicatingFrom(ReplicationMasterDescriptor master) {
        this.replicatingFromMaster = master;
    }

    @Override
    public void stoppedReplicatingFrom(ReplicationMasterDescriptor master) {
        this.replicatingFromMaster = null;
    }

    @Override
    public boolean hasSentOperationToMaster(OperationWithResult<S, ?> operation) {
        return this.operationsSentToMasterForReplication.remove(operation);
    }

    @Override
    public void addOperationSentToMasterForReplication(OperationWithResultWithIdWrapper<S, ?> operation) {
        this.operationsSentToMasterForReplication.add(operation);
    }
}

