/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication;

import com.sap.sse.replication.OperationExecutionListener;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.OperationWithResultWithIdWrapper;
import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface ReplicableWithObjectInputStream<S, O extends OperationWithResult<S, ?>>
extends Replicable<S, O> {
    public static final Logger logger = Logger.getLogger(ReplicableWithObjectInputStream.class.getName());
    public static final ThreadLocal<Serializable> idOfOperationBeingExecuted = new ThreadLocal();
    public static final AtomicInteger operationCounter = new AtomicInteger(0);
    public static final /* synthetic */ boolean $assertionsDisabled;

    public void initiallyFillFromInternal(ObjectInputStream var1) throws IOException, ClassNotFoundException, InterruptedException;

    public void serializeForInitialReplicationInternal(ObjectOutputStream var1) throws IOException;

    @Override
    default public void initiallyFillFrom(InputStream is) throws IOException, ClassNotFoundException, InterruptedException {
        assert (!this.isCurrentlyFillingFromInitialLoadOrApplyingOperationReceivedFromMaster());
        this.setCurrentlyFillingFromInitialLoad(true);
        try {
            ObjectInputStream objectInputStream = this.createObjectInputStreamResolvingAgainstCache(is, new HashMap());
            ClassLoader oldContextClassloader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getDeserializationClassLoader());
            try {
                this.initiallyFillFromInternal(objectInputStream);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextClassloader);
            }
        }
        finally {
            this.setCurrentlyFillingFromInitialLoad(false);
        }
    }

    @Override
    default public void serializeForInitialReplication(OutputStream os) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
        this.serializeForInitialReplicationInternal(objectOutputStream);
        objectOutputStream.flush();
    }

    @Override
    default public O readOperation(InputStream inputStream, Map<String, Class<?>> classLoaderCache) throws IOException, ClassNotFoundException {
        return this.readOperationFromObjectInputStream(this.createObjectInputStreamResolvingAgainstCache(inputStream, classLoaderCache));
    }

    @Override
    default public void writeOperation(OperationWithResult<?, ?> operation, OutputStream outputStream, boolean closeStream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        oos.writeObject(operation);
        oos.flush();
        if (closeStream) {
            oos.close();
        }
    }

    @Override
    default public <T> void replicate(O operation) {
        if (this.getMasterDescriptor() != null && !this.isCurrentlyFillingFromInitialLoadOrApplyingOperationReceivedFromMaster()) {
            this.scheduleForSending(operation, this);
        }
        this.replicateReplicated(operation);
    }

    default public <T> void replicateReplicated(O operation) {
        Object owr = operation;
        Serializable idOfCurrentlyExecutingOperation = idOfOperationBeingExecuted.get();
        Object operationToNotify = !(owr instanceof OperationWithResultWithIdWrapper) && idOfCurrentlyExecutingOperation != null ? new OperationWithResultWithIdWrapper(owr, idOfCurrentlyExecutingOperation) : owr;
        for (OperationExecutionListener<S> listener : this.getOperationExecutionListeners()) {
            int operationCount = operationCounter.incrementAndGet();
            logger.fine(() -> operationCount + ": Replicating " + operation);
            try {
                listener.executed(operationToNotify);
            }
            catch (Exception e) {
                logger.severe("Error replicating operation " + operationToNotify + " to replication listener " + listener);
                logger.log(Level.SEVERE, "replicate", e);
            }
        }
    }

    public Iterable<OperationExecutionListener<S>> getOperationExecutionListeners();

    @Override
    default public <T> T apply(O operation) {
        boolean needToRemoveThreadLocal = false;
        if (operation instanceof OperationWithResultWithIdWrapper) {
            idOfOperationBeingExecuted.set(((OperationWithResultWithIdWrapper)operation).getId());
            needToRemoveThreadLocal = true;
        }
        T result = this.applyReplicated(operation);
        ReplicationMasterDescriptor masterDescriptor = this.getMasterDescriptor();
        if (masterDescriptor != null) {
            this.scheduleForSending(operation, this);
        }
        if (needToRemoveThreadLocal) {
            idOfOperationBeingExecuted.remove();
        }
        return result;
    }

    @Override
    default public <T> T applyReplicated(O operation) {
        O reso = operation;
        try {
            this.setCurrentlyApplyingOperationReceivedFromMaster(true);
            ReplicableWithObjectInputStream replicable = this;
            Object result = reso.internalApplyTo((ReplicableWithObjectInputStream)replicable);
            if (operation.isRequiresExplicitTransitiveReplication()) {
                this.replicateReplicated(operation);
            }
            Object r = result;
            return (T)r;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "apply", e);
            throw new RuntimeException(e);
        }
        finally {
            this.setCurrentlyApplyingOperationReceivedFromMaster(false);
        }
    }
}

