/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.manage2sail.resultimport;

import com.sap.sailing.competitorimport.CompetitorProvider;
import com.sap.sailing.domain.common.CompetitorDescriptor;
import com.sap.sailing.manage2sail.resultimport.AbstractManage2SailProvider;
import com.sap.sailing.manage2sail.resultimport.CompetitorDocumentProvider;
import com.sap.sailing.resultimport.ResultDocumentProvider;
import com.sap.sailing.resultimport.ResultUrlRegistry;
import com.sap.sailing.xrr.resultimport.ParserFactory;
import com.sap.sailing.xrr.resultimport.impl.CompetitorResolver;
import com.sap.sse.i18n.ResourceBundleStringMessages;
import com.sap.sse.i18n.impl.ResourceBundleStringMessagesImpl;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Manage2SailCompetitorProvider
extends AbstractManage2SailProvider
implements CompetitorProvider {
    private static final long serialVersionUID = 7389956404604333931L;
    private static final String STRING_MESSAGES_BASE_NAME = "stringmessages/StringMessages";
    private static final String ID_PREFIX = "Manage2Sail";
    private final CompetitorDocumentProvider documentProvider = new CompetitorDocumentProvider(this);
    private final ResourceBundleStringMessages stringMessages;
    private final CompetitorResolver competitorResolver;

    public Manage2SailCompetitorProvider(ParserFactory parserFactory, ResultUrlRegistry resultUrlRegistry) {
        super(parserFactory, resultUrlRegistry);
        this.competitorResolver = new CompetitorResolver((ResultDocumentProvider)this.documentProvider, parserFactory, ID_PREFIX);
        this.stringMessages = new ResourceBundleStringMessagesImpl(STRING_MESSAGES_BASE_NAME, ((Object)((Object)this)).getClass().getClassLoader());
    }

    public Map<String, Set<String>> getHasCompetitorsForRegattasInEvent() throws IOException, URISyntaxException, SAXException, ParserConfigurationException {
        return this.competitorResolver.getHasCompetitorsForRegattasInEvent();
    }

    public String getName() {
        return "Manage2Sail XRR Result Importer";
    }

    public Iterable<CompetitorDescriptor> getCompetitorDescriptors(String eventName, String regattaName) throws JAXBException, IOException, URISyntaxException, SAXException, ParserConfigurationException {
        return this.competitorResolver.getCompetitorDescriptors(eventName, regattaName);
    }

    protected CompetitorDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    public String getHint(Locale locale) {
        return this.stringMessages.get(locale, "CompetitorImporterHint");
    }
}

