/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.manage2sail.resultimport;

import com.sap.sailing.domain.resultimport.ResultUrlProvider;
import com.sap.sailing.manage2sail.EventResultDescriptor;
import com.sap.sailing.manage2sail.Manage2SailEventResultsParserImpl;
import com.sap.sailing.manage2sail.RegattaResultDescriptor;
import com.sap.sailing.resultimport.ResultDocumentDescriptor;
import com.sap.sailing.resultimport.ResultDocumentProvider;
import com.sap.sailing.resultimport.impl.ResultDocumentDescriptorImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractManage2SailResultDocumentProvider
implements ResultDocumentProvider {
    private final ResultUrlProvider resultUrlProvider;

    public AbstractManage2SailResultDocumentProvider(ResultUrlProvider resultUrlProvider) {
        this.resultUrlProvider = resultUrlProvider;
    }

    public Iterable<ResultDocumentDescriptor> getResultDocumentDescriptors() throws IOException, URISyntaxException {
        ArrayList<ResultDocumentDescriptor> result = new ArrayList<ResultDocumentDescriptor>();
        Manage2SailEventResultsParserImpl parser = new Manage2SailEventResultsParserImpl();
        for (URL url : this.resultUrlProvider.getReadableUrls()) {
            EventResultDescriptor eventResult = parser.getEventResult(url);
            this.addResultsForEvent(result, eventResult);
        }
        return result;
    }

    private void addResultsForEvent(List<ResultDocumentDescriptor> result, EventResultDescriptor eventResult) throws IOException {
        if (eventResult != null) {
            for (RegattaResultDescriptor regattaResult : eventResult.getRegattaResults()) {
                URL resultUrl;
                String boatClass;
                String string = boatClass = regattaResult.getIsafId() != null && !regattaResult.getIsafId().isEmpty() ? regattaResult.getIsafId() : regattaResult.getName();
                if (!this.acceptRegatta(regattaResult) || (resultUrl = this.getDocumentUrlForRegatta(regattaResult)) == null) continue;
                URLConnection regattaResultConn = HttpUrlConnectionHelper.redirectConnection((URL)resultUrl);
                result.add((ResultDocumentDescriptor)new ResultDocumentDescriptorImpl((InputStream)regattaResultConn.getContent(), resultUrl.toString(), (TimePoint)(regattaResult.getPublishedAt() == null ? null : new MillisecondsTimePoint(regattaResult.getPublishedAt())), eventResult.getName(), regattaResult.getName(), boatClass, regattaResult.getCompetitorGenderType()));
            }
        }
    }

    protected abstract boolean acceptRegatta(RegattaResultDescriptor var1);

    protected abstract URL getDocumentUrlForRegatta(RegattaResultDescriptor var1);
}

