/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.yellowbrickadapter.persistence.impl;

import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickConfiguration;
import com.sap.sailing.domain.yellowbrickadapter.persistence.MongoObjectFactory;
import com.sap.sailing.domain.yellowbrickadapter.persistence.impl.CollectionNames;
import com.sap.sailing.domain.yellowbrickadapter.persistence.impl.FieldNames;
import java.util.ArrayList;
import java.util.Base64;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoObjectFactoryImpl
implements MongoObjectFactory {
    private final MongoDatabase database;

    public MongoObjectFactoryImpl(MongoDatabase database) {
        this.database = database;
    }

    @Override
    public void clear() {
        this.database.getCollection(CollectionNames.YELLOWBRICK_CONFIGURATIONS.name()).withWriteConcern(WriteConcern.ACKNOWLEDGED).drop();
    }

    @Override
    public void createYellowBrickConfiguration(YellowBrickConfiguration yellowBrickConfiguration) {
        MongoCollection ybConfigCollection = this.database.getCollection(CollectionNames.YELLOWBRICK_CONFIGURATIONS.name());
        Bson update = this.getUpdateForYellowBrickConfiguration(yellowBrickConfiguration);
        Document query = this.getQueryForConfiguration(yellowBrickConfiguration);
        ybConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).updateOne((Bson)query, update, new UpdateOptions().upsert(true));
    }

    @Override
    public void updateYellowBrickConfiguration(YellowBrickConfiguration yellowBrickConfiguration) {
        MongoCollection ybConfigCollection = this.database.getCollection(CollectionNames.YELLOWBRICK_CONFIGURATIONS.name());
        Bson update = this.getUpdateForYellowBrickConfiguration(yellowBrickConfiguration);
        Document updateQuery = this.getQueryForConfiguration(yellowBrickConfiguration);
        ybConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).updateOne((Bson)updateQuery, update, new UpdateOptions().upsert(true));
    }

    private Document getQueryForConfiguration(YellowBrickConfiguration yellowBrickConfiguration) {
        String raceUrl = yellowBrickConfiguration.getRaceUrl();
        String creatorName = yellowBrickConfiguration.getCreatorName();
        return this.getQueryForRaceUrlAndCreatorName(raceUrl, creatorName);
    }

    private Document getQueryForRaceUrlAndCreatorName(String raceUrl, String creatorName) {
        Document query = new Document(FieldNames.YB_CONFIG_RACE_URL.name(), (Object)raceUrl);
        query.put(FieldNames.YB_CONFIG_CREATOR_NAME.name(), (Object)creatorName);
        return query;
    }

    private Bson getUpdateForYellowBrickConfiguration(YellowBrickConfiguration yellowBrickConfiguration) {
        ArrayList<Bson> updates = new ArrayList<Bson>();
        updates.add(Updates.set((String)FieldNames.YB_CONFIG_CREATOR_NAME.name(), (Object)yellowBrickConfiguration.getCreatorName()));
        updates.add(Updates.set((String)FieldNames.YB_CONFIG_NAME.name(), (Object)yellowBrickConfiguration.getName()));
        updates.add(Updates.set((String)FieldNames.YB_CONFIG_RACE_URL.name(), (Object)yellowBrickConfiguration.getRaceUrl()));
        updates.add(Updates.set((String)FieldNames.YB_CONFIG_USERNAME.name(), (Object)yellowBrickConfiguration.getUsername()));
        updates.add(Updates.set((String)FieldNames.YB_CONFIG_CREATOR_NAME.name(), (Object)yellowBrickConfiguration.getCreatorName()));
        if (yellowBrickConfiguration.getPassword() != null) {
            updates.add(Updates.set((String)FieldNames.YB_CONFIG_PASSWORD.name(), (Object)Base64.getEncoder().encode(yellowBrickConfiguration.getPassword().getBytes())));
        }
        return Updates.combine((Bson[])updates.toArray(new Bson[updates.size()]));
    }

    @Override
    public void deleteYellowBrickConfiguration(String creatorName, String raceUrl) {
        MongoCollection ybConfigCollection = this.database.getCollection(CollectionNames.YELLOWBRICK_CONFIGURATIONS.name());
        Document deleteQuery = new Document(FieldNames.YB_CONFIG_RACE_URL.name(), (Object)raceUrl);
        deleteQuery.put(FieldNames.YB_CONFIG_CREATOR_NAME.name(), (Object)creatorName);
        ybConfigCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED).deleteOne((Bson)deleteQuery);
    }
}

