/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.yellowbrickadapter.persistence.impl;

import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.persistence.MongoRaceLogStoreFactory;
import com.sap.sailing.domain.persistence.MongoRegattaLogStoreFactory;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParametersHandler;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickConfiguration;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickConfigurationListener;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickTrackingAdapter;
import com.sap.sailing.domain.yellowbrickadapter.YellowBrickTrackingAdapterFactory;
import com.sap.sailing.domain.yellowbrickadapter.persistence.DomainObjectFactory;
import com.sap.sailing.domain.yellowbrickadapter.persistence.MongoObjectFactory;
import com.sap.sailing.domain.yellowbrickadapter.persistence.PersistenceFactory;
import com.sap.sailing.domain.yellowbrickadapter.persistence.impl.CollectionNames;
import com.sap.sailing.domain.yellowbrickadapter.persistence.impl.YellowBrickConnectivityParamsHandler;
import com.sap.sse.mongodb.MongoDBService;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.util.ClearStateTestSupport;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static BundleContext context;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        CollectionNames[] collectionNamesArray = CollectionNames.values();
        int n = collectionNamesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CollectionNames name = collectionNamesArray[n2];
            MongoDBService.INSTANCE.registerExclusively(CollectionNames.class, name.name());
            ++n2;
        }
        new Thread(() -> {
            ServiceTracker mongoObjectFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, com.sap.sailing.domain.persistence.MongoObjectFactory.class);
            ServiceTracker domainObjectFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, com.sap.sailing.domain.persistence.DomainObjectFactory.class);
            ServiceTracker yellowBrickTrackingAdapterFactoryServiceTracker = ServiceTrackerFactory.createAndOpen((BundleContext)context, YellowBrickTrackingAdapterFactory.class);
            FullyInitializedReplicableTracker securityServiceServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
            try {
                com.sap.sailing.domain.persistence.MongoObjectFactory mongoObjectFactory = (com.sap.sailing.domain.persistence.MongoObjectFactory)mongoObjectFactoryServiceTracker.waitForService(0L);
                com.sap.sailing.domain.persistence.DomainObjectFactory domainObjectFactory = (com.sap.sailing.domain.persistence.DomainObjectFactory)domainObjectFactoryServiceTracker.waitForService(0L);
                SecurityService securityService = (SecurityService)securityServiceServiceTracker.getInitializedService(0L);
                DomainFactory baseDomainFactory = domainObjectFactory.getBaseDomainFactory();
                YellowBrickTrackingAdapterFactory yellowBrickTrackingAdapterFactory = (YellowBrickTrackingAdapterFactory)yellowBrickTrackingAdapterFactoryServiceTracker.waitForService(0L);
                Hashtable<String, String> properties = new Hashtable<String, String>();
                DomainObjectFactory yellowBrickDomainObjectFactory = PersistenceFactory.INSTANCE.createDomainObjectFactory(mongoObjectFactory.getDatabase());
                final MongoObjectFactory yellowBrickMongoObjectFactory = PersistenceFactory.INSTANCE.createMongoObjectFactory(mongoObjectFactory.getDatabase());
                YellowBrickTrackingAdapter yellowBrickTrackingAdapter = yellowBrickTrackingAdapterFactory.getYellowBrickTrackingAdapter(baseDomainFactory);
                YellowBrickConnectivityParamsHandler paramsHandler = new YellowBrickConnectivityParamsHandler(MongoRaceLogStoreFactory.INSTANCE.getMongoRaceLogStore(mongoObjectFactory, domainObjectFactory), MongoRegattaLogStoreFactory.INSTANCE.getMongoRegattaLogStore(mongoObjectFactory, domainObjectFactory), baseDomainFactory, securityService, yellowBrickTrackingAdapter);
                for (YellowBrickConfiguration yellowBrickConfig : yellowBrickDomainObjectFactory.getYellowBrickConfigurations()) {
                    securityService.migrateOwnership((WithQualifiedObjectIdentifier)yellowBrickConfig);
                    yellowBrickTrackingAdapter.addYellowBrickConfiguration(yellowBrickConfig);
                }
                yellowBrickTrackingAdapter.addYellowBrickConfigurationListener(new YellowBrickConfigurationListener(){

                    public void yellowBrickConfigurationAdded(YellowBrickConfiguration configAdded) {
                        yellowBrickMongoObjectFactory.createYellowBrickConfiguration(configAdded);
                    }

                    public void yellowBrickConfigurationRemoved(YellowBrickConfiguration configRemoved) {
                        yellowBrickMongoObjectFactory.deleteYellowBrickConfiguration(configRemoved.getCreatorName(), configRemoved.getRaceUrl());
                    }

                    public void yellowBrickConfigurationUpdated(YellowBrickConfiguration configUpdated) {
                        yellowBrickMongoObjectFactory.updateYellowBrickConfiguration(configUpdated);
                    }
                });
                securityService.assumeOwnershipMigrated(SecuredDomainType.YELLOWBRICK_ACCOUNT.getName());
                ((Dictionary)properties).put("type", "YELLOW_BRICK");
                context.registerService(RaceTrackingConnectivityParametersHandler.class, (Object)paramsHandler, properties);
                context.registerService(ClearStateTestSupport.class.getName(), (Object)new ClearStateTestSupport(){

                    public void clearState() throws Exception {
                        yellowBrickMongoObjectFactory.clear();
                    }
                }, null);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception trying to register TracTrac RaceTrackingConnectivityParametersHandler implementation", e);
            }
        }, String.valueOf(this.getClass().getName()) + " registering connectivity handler").start();
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }
}

