/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRaceOperation;
import com.sap.sse.common.TimePoint;
import java.util.logging.Logger;

public class UpdateStartOfTracking
extends AbstractRaceOperation<Void> {
    private static final long serialVersionUID = 7054690983295760375L;
    private static final Logger logger = Logger.getLogger(UpdateStartOfTracking.class.getName());
    private final TimePoint startOfTracking;

    public UpdateStartOfTracking(RegattaAndRaceIdentifier raceIdentifier, TimePoint startOfTracking) {
        super(raceIdentifier);
        this.startOfTracking = startOfTracking;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        DynamicTrackedRace trackedRace = toState.getExistingTrackedRace(this.getRaceIdentifier());
        if (trackedRace != null) {
            logger.fine("applying startOfTracking=" + this.startOfTracking + " for " + trackedRace.getRace().getName());
            trackedRace.setStartOfTrackingReceived(this.startOfTracking);
        } else {
            logger.warning("Tracked race for " + this.getRaceIdentifier() + " has disappeared");
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

