/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractRaceOperation;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.logging.Logger;

public class UpdateMarkPassings
extends AbstractRaceOperation<Void> {
    private static final long serialVersionUID = 8462323149468755367L;
    private static final Logger logger = Logger.getLogger(UpdateMarkPassings.class.getName());
    private final Competitor competitor;
    private final Iterable<MarkPassing> markPassings;

    public UpdateMarkPassings(RegattaAndRaceIdentifier raceIdentifier, Competitor competitor, Iterable<MarkPassing> markPassings) {
        super(raceIdentifier);
        this.competitor = competitor;
        ArrayList<MarkPassing> markPassingsList = new ArrayList<MarkPassing>();
        Util.addAll(markPassings, markPassingsList);
        this.markPassings = markPassingsList;
    }

    public Void internalApplyTo(RacingEventService toState) throws Exception {
        DynamicTrackedRace trackedRace = toState.getExistingTrackedRace(this.getRaceIdentifier());
        if (trackedRace != null) {
            trackedRace.updateMarkPassings(this.competitor, this.markPassings);
        } else {
            logger.warning("Tracked race for " + this.getRaceIdentifier() + " has disappeared");
        }
        return null;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }
}

