/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardColumnOperation;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;

public class UpdateLeaderboardMaxPointsReason
extends AbstractLeaderboardColumnOperation<Util.Triple<Double, Double, Boolean>> {
    private static final long serialVersionUID = -492130952256848047L;
    private final String competitorIdAsString;
    private final MaxPointsReason newMaxPointsReason;
    private final TimePoint timePoint;

    public UpdateLeaderboardMaxPointsReason(String leaderboardName, String columnName, String competitorIdAsString, MaxPointsReason newMaxPointsReason, TimePoint timePoint) {
        super(leaderboardName, columnName);
        this.competitorIdAsString = competitorIdAsString;
        this.newMaxPointsReason = newMaxPointsReason;
        this.timePoint = timePoint;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    public Util.Triple<Double, Double, Boolean> internalApplyTo(RacingEventService toState) throws NoWindException {
        Leaderboard leaderboard = toState.getLeaderboardByName(this.getLeaderboardName());
        if (leaderboard != null) {
            Competitor competitor = leaderboard.getCompetitorByIdAsString(this.competitorIdAsString);
            if (competitor != null) {
                RaceColumn raceColumn = leaderboard.getRaceColumnByName(this.getColumnName());
                if (raceColumn == null) {
                    throw new IllegalArgumentException("Didn't find race " + this.getColumnName() + " in leaderboard " + this.getLeaderboardName());
                }
                leaderboard.getScoreCorrection().setMaxPointsReason(competitor, raceColumn, this.newMaxPointsReason);
                this.updateStoredLeaderboard(toState, leaderboard);
                Leaderboard.Entry updatedEntry = leaderboard.getEntry(competitor, raceColumn, this.timePoint);
                boolean isScoreCorrected = leaderboard.getScoreCorrection().isScoreCorrected(competitor, raceColumn, this.timePoint);
                return new Util.Triple((Object)updatedEntry.getTotalPoints(), (Object)updatedEntry.getNetPoints(), (Object)isScoreCorrected);
            }
            throw new IllegalArgumentException("Didn't find competitor with ID " + this.competitorIdAsString + " in leaderboard " + this.getLeaderboardName());
        }
        throw new IllegalArgumentException("Didn't find leaderboard " + this.getLeaderboardName());
    }
}

