/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.operationaltransformation;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.operationaltransformation.AbstractLeaderboardOperation;

public class UpdateLeaderboardCarryValue
extends AbstractLeaderboardOperation<Void> {
    private static final long serialVersionUID = 5467731814788887426L;
    private final String competitorIdAsString;
    private final Double newCarriedValue;

    public UpdateLeaderboardCarryValue(String leaderboardName, String competitorIdAsString, Double newCarriedValue) {
        super(leaderboardName);
        this.competitorIdAsString = competitorIdAsString;
        this.newCarriedValue = newCarriedValue;
    }

    public RacingEventServiceOperation<?> transformClientOp(RacingEventServiceOperation<?> serverOp) {
        return null;
    }

    public RacingEventServiceOperation<?> transformServerOp(RacingEventServiceOperation<?> clientOp) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Void internalApplyTo(RacingEventService toState) {
        Leaderboard leaderboard = toState.getLeaderboardByName(this.getLeaderboardName());
        if (leaderboard == null) throw new IllegalArgumentException("Didn't find leaderboard " + this.getLeaderboardName());
        Competitor competitor = leaderboard.getCompetitorByIdAsString(this.competitorIdAsString);
        if (competitor == null) throw new IllegalArgumentException("Didn't find competitor ID " + this.competitorIdAsString + " in leaderboard " + this.getLeaderboardName());
        if (this.newCarriedValue == null) {
            leaderboard.unsetCarriedPoints(competitor);
        } else {
            leaderboard.setCarriedPoints(competitor, this.newCarriedValue.doubleValue());
        }
        this.updateStoredLeaderboard(toState, leaderboard);
        return null;
    }
}

